/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.OrderedGroup;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.GroupState;

public class OrderedGroupState
extends GroupState {
    public OrderedGroupState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        int[] childIndexOrder = ((OrderedGroup)this.node).getChildIndexOrder();
        out.writeInt(childIndexOrder.length);
        for (int i = 0; i < childIndexOrder.length; ++i) {
            out.writeInt(childIndexOrder[i]);
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        int[] childIndexOrder = new int[in.readInt()];
        for (int i = 0; i < childIndexOrder.length; ++i) {
            childIndexOrder[i] = in.readInt();
        }
        ((OrderedGroup)this.node).setChildIndexOrder(childIndexOrder);
    }

    @Override
    protected SceneGraphObject createNode() {
        return new OrderedGroup();
    }
}

