/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.line;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShape2DException;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CircleLine2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.domain.SmoothContour2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.DegeneratedLine2DException;
import math.geom2d.line.LinearShape2D;
import math.geom2d.polygon.Polyline2D;
import math.geom2d.transform.CircleInversion2D;
import math.utils.EqualUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StraightLine2D
extends AbstractLine2D
implements SmoothContour2D,
Cloneable,
CircleLine2D {
    @Deprecated
    public static StraightLine2D create(Point2D point, double angle) {
        return new StraightLine2D(point.x(), point.y(), Math.cos(angle), Math.sin(angle));
    }

    @Deprecated
    public static StraightLine2D create(Point2D p1, Point2D p2) {
        return new StraightLine2D(p1, p2);
    }

    @Deprecated
    public static StraightLine2D create(Point2D origin, Vector2D direction) {
        return new StraightLine2D(origin, direction);
    }

    public static StraightLine2D createHorizontal(Point2D origin) {
        return new StraightLine2D(origin, new Vector2D(1.0, 0.0));
    }

    public static StraightLine2D createVertical(Point2D origin) {
        return new StraightLine2D(origin, new Vector2D(0.0, 1.0));
    }

    public static StraightLine2D createMedian(Point2D p1, Point2D p2) {
        Point2D mid = Point2D.midPoint(p1, p2);
        StraightLine2D line = StraightLine2D.create(p1, p2);
        return StraightLine2D.createPerpendicular(line, mid);
    }

    public static StraightLine2D createParallel(LinearShape2D line, Point2D point) {
        return new StraightLine2D(line, point);
    }

    public static StraightLine2D createParallel(LinearShape2D linear, double d) {
        StraightLine2D line = linear.supportingLine();
        double d2 = d / Math.hypot(line.dx, line.dy);
        return new StraightLine2D(line.x0 + line.dy * d2, line.y0 - line.dx * d2, line.dx, line.dy);
    }

    public static StraightLine2D createPerpendicular(LinearShape2D linear, Point2D point) {
        StraightLine2D line = linear.supportingLine();
        return new StraightLine2D(point, -line.dy, line.dx);
    }

    public static StraightLine2D createCartesian(double a, double b, double c) {
        return new StraightLine2D(a, b, c);
    }

    public static Point2D getIntersection(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        StraightLine2D line1 = new StraightLine2D(p1, p2);
        StraightLine2D line2 = new StraightLine2D(p3, p4);
        return line1.intersection(line2);
    }

    public StraightLine2D() {
        this(0.0, 0.0, 1.0, 0.0);
    }

    public StraightLine2D(Point2D point1, Point2D point2) {
        this(point1, new Vector2D(point1, point2));
    }

    public StraightLine2D(Point2D point, Vector2D direction) {
        this(point.x(), point.y(), direction.x(), direction.y());
    }

    public StraightLine2D(Point2D point, double dx, double dy) {
        this(point.x(), point.y(), dx, dy);
    }

    public StraightLine2D(Point2D point, double angle) {
        this(point.x(), point.y(), Math.cos(angle), Math.sin(angle));
    }

    public StraightLine2D(LinearShape2D line) {
        super(line);
    }

    public StraightLine2D(double xp, double yp, double dx, double dy) {
        super(xp, yp, dx, dy);
    }

    public StraightLine2D(LinearShape2D line, Point2D point) {
        this(point, line.direction());
    }

    public StraightLine2D(double a, double b, double c) {
        this(0.0, 0.0, 1.0, 0.0);
        double d = a * a + b * b;
        this.x0 = -a * c / d;
        this.y0 = -b * c / d;
        double theta = Math.atan2(-a, b);
        this.dx = Math.cos(theta);
        this.dy = Math.sin(theta);
    }

    @Override
    public StraightLine2D parallel(Point2D point) {
        return new StraightLine2D(point, this.dx, this.dy);
    }

    @Override
    public StraightLine2D parallel(double d) {
        double d2 = Math.hypot(this.dx, this.dy);
        if (Math.abs(d2) < 1.0E-12) {
            throw new DegeneratedLine2DException("Can not compute parallel of degenerated line", this);
        }
        d2 = d / d2;
        return new StraightLine2D(this.x0 + this.dy * d2, this.y0 - this.dx * d2, this.dx, this.dy);
    }

    @Override
    public StraightLine2D perpendicular(Point2D point) {
        return new StraightLine2D(point, -this.dy, this.dx);
    }

    @Override
    public CircleLine2D transform(CircleInversion2D inv) {
        Point2D center = inv.center();
        double r = inv.radius();
        Point2D po = this.projectedPoint(center);
        double d = this.distance(center);
        if (Math.abs(d) < 1.0E-12) {
            return new StraightLine2D(this);
        }
        double angle = Angle2D.horizontalAngle(center, po);
        double r2 = r * r / d / 2.0;
        Point2D c2 = Point2D.createPolar(center, r2, angle);
        boolean direct = this.isInside(center);
        return new Circle2D(c2, r2, direct);
    }

    @Override
    public CirculinearDomain2D domain() {
        return new GenericCirculinearDomain2D(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        g2.fill(this.getGeneralPath());
    }

    @Override
    public double windingAngle(Point2D point) {
        double angle1 = Angle2D.horizontalAngle(-this.dx, -this.dy);
        double angle2 = Angle2D.horizontalAngle(this.dx, this.dy);
        if (this.isInside(point)) {
            if (angle2 > angle1) {
                return angle2 - angle1;
            }
            return Math.PI * 2 - angle1 + angle2;
        }
        if (angle2 > angle1) {
            return angle2 - angle1 - Math.PI * 2;
        }
        return angle2 - angle1;
    }

    @Override
    public Polyline2D asPolyline(int n) {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public Point2D firstPoint() {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public Point2D lastPoint() {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public Collection<Point2D> singularPoints() {
        return new ArrayList<Point2D>(0);
    }

    @Override
    public boolean isSingular(double pos) {
        return false;
    }

    @Override
    public double t0() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D point(double t) {
        return new Point2D(this.x0 + this.dx * t, this.y0 + this.dy * t);
    }

    public Collection<? extends StraightLine2D> continuousCurves() {
        ArrayList<StraightLine2D> list = new ArrayList<StraightLine2D>(1);
        list.add(this);
        return list;
    }

    @Override
    public StraightLine2D reverse() {
        return new StraightLine2D(this.x0, this.y0, -this.dx, -this.dy);
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public double distance(double x, double y) {
        Point2D proj = super.projectedPoint(x, y);
        return proj.distance(x, y);
    }

    @Override
    public Box2D boundingBox() {
        if (Math.abs(this.dx) < 1.0E-12) {
            return new Box2D(this.x0, this.x0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (Math.abs(this.dy) < 1.0E-12) {
            return new Box2D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.x0, this.y0);
        }
        return new Box2D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public StraightLine2D transform(AffineTransform2D trans) {
        double[] tab = trans.coefficients();
        return new StraightLine2D(this.x0 * tab[0] + this.y0 * tab[1] + tab[2], this.x0 * tab[3] + this.y0 * tab[4] + tab[5], this.dx * tab[0] + this.dy * tab[1], this.dx * tab[3] + this.dy * tab[4]);
    }

    @Override
    public boolean contains(double x, double y) {
        return super.supportContains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return super.supportContains(p.x(), p.y());
    }

    public GeneralPath getGeneralPath() {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StraightLine2D)) {
            return false;
        }
        StraightLine2D line = (StraightLine2D)obj;
        if (Math.abs(this.x0 - line.x0) > eps) {
            return false;
        }
        if (Math.abs(this.y0 - line.y0) > eps) {
            return false;
        }
        if (Math.abs(this.dx - line.dx) > eps) {
            return false;
        }
        return !(Math.abs(this.dy - line.dy) > eps);
    }

    public String toString() {
        return new String("StraightLine2D(" + this.x0 + "," + this.y0 + "," + this.dx + "," + this.dy + ")");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StraightLine2D)) {
            return false;
        }
        StraightLine2D that = (StraightLine2D)obj;
        if (!EqualUtils.areEqual(this.x0, that.x0)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.y0, that.y0)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.dx, that.dx)) {
            return false;
        }
        return EqualUtils.areEqual(this.dy, that.dy);
    }

    @Override
    public StraightLine2D clone() {
        return new StraightLine2D(this.x0, this.y0, this.dx, this.dy);
    }
}

