/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.Iterator;
import java.util.Spliterator;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.ColumnView;
import org.ojalgo.access.ElementView1D;
import org.ojalgo.access.ElementView2D;
import org.ojalgo.access.Factory2D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.access.Mutate2D;
import org.ojalgo.access.RowView;
import org.ojalgo.access.Structure2D;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.type.context.NumberContext;

public interface Access2D<N extends Number>
extends Structure2D,
Access1D<N> {
    public static Access2D<Double> asPrimitive2D(final Access2D<?> access) {
        return new Access2D<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long countColumns() {
                return access.countColumns();
            }

            @Override
            public long countRows() {
                return access.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long col) {
                return access.doubleValue(row, col);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long row, long col) {
                return access.doubleValue(row, col);
            }
        };
    }

    public static boolean equals(Access2D<?> accessA, Access2D<?> accessB, NumberContext context) {
        return accessA.countRows() == accessB.countRows() && accessA.countColumns() == accessB.countColumns() && Access1D.equals(accessA, accessB, context);
    }

    public static <R extends Mutate2D.Receiver<Double>> Collectable<Double, R> newPrimitiveColumnCollectable(final Access1D<?> anything1D) {
        return new Collectable<Double, R>(){

            @Override
            public long countColumns() {
                return 1L;
            }

            @Override
            public long countRows() {
                return anything1D.count();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.reset();
                anything1D.nonzeros().forEach(nz -> receiver.set(nz.index(), 0L, nz.doubleValue()));
            }
        };
    }

    public static <R extends Mutate2D.Receiver<Double>> Collectable<Double, R> newPrimitiveRowCollectable(final Access1D<?> anything1D) {
        return new Collectable<Double, R>(){

            @Override
            public long countColumns() {
                return anything1D.count();
            }

            @Override
            public long countRows() {
                return 1L;
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.reset();
                anything1D.nonzeros().forEach(nz -> receiver.set(0L, nz.index(), nz.doubleValue()));
            }
        };
    }

    public static String toString(Access2D<?> matrix) {
        StringBuilder retVal = new StringBuilder();
        int tmpRowDim = (int)matrix.countRows();
        int tmpColDim = (int)matrix.countColumns();
        retVal.append(matrix.getClass().getName());
        retVal.append(' ').append('<').append(' ').append(tmpRowDim).append(' ').append('x').append(' ').append(tmpColDim).append(' ').append('>');
        if (tmpRowDim > 0 && tmpColDim > 0 && tmpRowDim <= 50 && tmpColDim <= 50 && tmpRowDim * tmpColDim <= 200) {
            retVal.append("\n{ { ").append(matrix.get(0L, 0L));
            for (int j = 1; j < tmpColDim; ++j) {
                retVal.append(",\t").append(matrix.get(0L, j));
            }
            for (int i = 1; i < tmpRowDim; ++i) {
                retVal.append(" },\n{ ").append(matrix.get(i, 0L));
                for (int j = 1; j < tmpColDim; ++j) {
                    retVal.append(",\t").append(matrix.get(i, j));
                }
            }
            retVal.append(" } }");
        }
        return retVal.toString();
    }

    public static Access2D<Double> wrap(final double[][] target) {
        return new Access2D<Double>(){

            @Override
            public long count() {
                return target.length * target[0].length;
            }

            @Override
            public long countColumns() {
                return target[0].length;
            }

            @Override
            public long countRows() {
                return target.length;
            }

            @Override
            public double doubleValue(long row, long col) {
                return target[(int)row][(int)col];
            }

            @Override
            public Double get(long row, long col) {
                return target[(int)row][(int)col];
            }
        };
    }

    public static <N extends Number> Access2D<N> wrap(N[][] target) {
        return new Access2D<N>((Number[][])target){
            final /* synthetic */ Number[][] val$target;
            {
                this.val$target = numberArray;
            }

            @Override
            public long count() {
                return this.val$target.length * this.val$target[0].length;
            }

            @Override
            public long countColumns() {
                return this.val$target[0].length;
            }

            @Override
            public long countRows() {
                return this.val$target.length;
            }

            @Override
            public double doubleValue(long index) {
                return ((Number)this.get(index)).doubleValue();
            }

            @Override
            public double doubleValue(long row, long col) {
                return ((Number)this.get(row, col)).doubleValue();
            }

            @Override
            public N get(long row, long col) {
                return this.val$target[(int)row][(int)col];
            }
        };
    }

    @Deprecated
    public static Access2D<Double> wrapAccess2D(double[][] target) {
        return Access2D.wrap(target);
    }

    @Deprecated
    public static <N extends Number> Access2D<N> wrapAccess2D(N[][] target) {
        return Access2D.wrap(target);
    }

    default public <NN extends Number, R extends Mutate2D.Receiver<NN>> Collectable<NN, R> asCollectable2D() {
        return new Collectable<NN, R>(){

            @Override
            public long countColumns() {
                return Access2D.this.countColumns();
            }

            @Override
            public long countRows() {
                return Access2D.this.countRows();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.accept(Access2D.this);
            }
        };
    }

    default public Iterable<ColumnView<N>> columns() {
        return ColumnView.makeIterable(this);
    }

    @Override
    default public double doubleValue(long index) {
        long tmpStructure = this.countRows();
        return this.doubleValue(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure));
    }

    public double doubleValue(long var1, long var3);

    @Override
    default public ElementView2D<N, ?> elements() {
        return new ElementView(Access1D.super.elements(), this.countRows());
    }

    @Override
    default public N get(long index) {
        long tmpStructure = this.countRows();
        return this.get(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure));
    }

    public N get(long var1, long var3);

    default public Iterable<RowView<N>> rows() {
        return RowView.makeIterable(this);
    }

    default public double[][] toRawCopy2D() {
        int tmpRowDim = (int)this.countRows();
        int tmpColDim = (int)this.countColumns();
        double[][] retVal = new double[tmpRowDim][tmpColDim];
        for (int i = 0; i < tmpRowDim; ++i) {
            double[] tmpRow = retVal[i];
            for (int j = 0; j < tmpColDim; ++j) {
                tmpRow[j] = this.doubleValue(i, j);
            }
        }
        return retVal;
    }

    public static interface Visitable<N extends Number>
    extends Structure2D,
    Access1D.Visitable<N> {
        default public void visitColumn(long row, long col, VoidFunction<N> visitor) {
            this.loopColumn(row, col, (r, c) -> this.visitOne(r, c, visitor));
        }

        default public void visitColumn(long col, VoidFunction<N> visitor) {
            this.visitColumn(0L, col, visitor);
        }

        default public void visitDiagonal(long row, long col, VoidFunction<N> visitor) {
            this.loopDiagonal(row, col, (r, c) -> this.visitOne(r, c, visitor));
        }

        default public void visitDiagonal(VoidFunction<N> visitor) {
            this.visitDiagonal(0L, 0L, visitor);
        }

        public void visitOne(long var1, long var3, VoidFunction<N> var5);

        @Override
        default public void visitOne(long index, VoidFunction<N> visitor) {
            long tmpStructure = this.countRows();
            this.visitOne(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), visitor);
        }

        default public void visitRow(long row, long col, VoidFunction<N> visitor) {
            this.loopRow(row, col, (r, c) -> this.visitOne(r, c, visitor));
        }

        default public void visitRow(long row, VoidFunction<N> visitor) {
            this.visitRow(row, 0L, visitor);
        }
    }

    public static interface Sliceable<N extends Number>
    extends Structure2D,
    Access1D.Sliceable<N> {
        default public Access1D<N> sliceColumn(long col) {
            return this.sliceColumn(0L, col);
        }

        public Access1D<N> sliceColumn(long var1, long var3);

        public Access1D<N> sliceDiagonal(long var1, long var3);

        default public Access1D<N> sliceRow(long row) {
            return this.sliceRow(row, 0L);
        }

        public Access1D<N> sliceRow(long var1, long var3);
    }

    public static interface IndexOf
    extends Structure2D,
    Access1D.IndexOf {
        default public long indexOfLargestInColumn(long col) {
            return this.indexOfLargestInColumn(0L, col);
        }

        public long indexOfLargestInColumn(long var1, long var3);

        default public long indexOfLargestInRow(long row) {
            return this.indexOfLargestInRow(row, 0L);
        }

        public long indexOfLargestInRow(long var1, long var3);

        default public long indexOfLargestOnDiagonal() {
            return this.indexOfLargestOnDiagonal(0L);
        }

        public long indexOfLargestOnDiagonal(long var1);
    }

    public static final class ElementView<N extends Number>
    implements ElementView2D<N, ElementView<N>> {
        private final ElementView1D<N, ?> myDelegate;
        private final long myStructure;

        public ElementView(ElementView1D<N, ?> delegate, long structure) {
            this.myDelegate = delegate;
            this.myStructure = structure;
        }

        @Override
        public long column() {
            return Structure2D.column(this.myDelegate.index(), this.myStructure);
        }

        @Override
        public double doubleValue() {
            return this.myDelegate.doubleValue();
        }

        @Override
        public long estimateSize() {
            return this.myDelegate.estimateSize();
        }

        @Override
        public N get() {
            return this.myDelegate.get();
        }

        @Override
        public boolean hasNext() {
            return this.myDelegate.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.myDelegate.hasPrevious();
        }

        @Override
        public long index() {
            return this.myDelegate.index();
        }

        @Override
        public Iterator<ElementView<N>> iterator() {
            return this;
        }

        @Override
        public ElementView<N> next() {
            this.myDelegate.next();
            return this;
        }

        @Override
        public ElementView<N> previous() {
            this.myDelegate.previous();
            return this;
        }

        @Override
        public long row() {
            return Structure2D.row(this.myDelegate.index(), this.myStructure);
        }

        @Override
        public ElementView<N> trySplit() {
            Spliterator delegateSpliterator = this.myDelegate.trySplit();
            if (delegateSpliterator != null) {
                return new ElementView<N>(delegateSpliterator, this.myStructure);
            }
            return null;
        }
    }

    public static interface Elements
    extends Structure2D,
    Access1D.Elements {
        @Override
        default public boolean isAbsolute(long index) {
            long tmpStructure = this.countRows();
            return this.isAbsolute(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure));
        }

        public boolean isAbsolute(long var1, long var3);

        default public boolean isColumnSmall(long col, double comparedTo) {
            return this.isColumnSmall(0L, col, comparedTo);
        }

        default public boolean isColumnSmall(long row, long col, double comparedTo) {
            boolean retVal = true;
            long tmpLimit = this.countRows();
            for (long i = row; retVal && i < tmpLimit; retVal &= this.isSmall(i, col, comparedTo), ++i) {
            }
            return retVal;
        }

        default public boolean isRowSmall(long row, double comparedTo) {
            return this.isRowSmall(row, 0L, comparedTo);
        }

        default public boolean isRowSmall(long row, long col, double comparedTo) {
            boolean retVal = true;
            long tmpLimit = this.countColumns();
            for (long j = col; retVal && j < tmpLimit; retVal &= this.isSmall(row, j, comparedTo), ++j) {
            }
            return retVal;
        }

        @Override
        default public boolean isSmall(long index, double comparedTo) {
            long tmpStructure = this.countRows();
            return this.isSmall(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), comparedTo);
        }

        public boolean isSmall(long var1, long var3, double var5);
    }

    public static interface Collectable<N extends Number, R extends Mutate2D.Receiver<N>>
    extends Structure2D {
        default public <I extends R> I collect(Factory2D<I> factory) {
            Mutate2D.Receiver retVal = (Mutate2D.Receiver)factory.makeZero(this.countRows(), this.countColumns());
            this.supplyTo(retVal);
            return (I)retVal;
        }

        public void supplyTo(R var1);
    }

    public static interface Aggregatable<N extends Number>
    extends Structure2D,
    Access1D.Aggregatable<N> {
        default public N aggregateColumn(long col, Aggregator aggregator) {
            return this.aggregateColumn(0L, col, aggregator);
        }

        public N aggregateColumn(long var1, long var3, Aggregator var5);

        public N aggregateDiagonal(long var1, long var3, Aggregator var5);

        default public N aggregateRow(long row, Aggregator aggregator) {
            return this.aggregateRow(row, 0L, aggregator);
        }

        public N aggregateRow(long var1, long var3, Aggregator var5);

        default public void reduceColumns(Aggregator aggregator, Mutate1D receiver) {
            long limit = Math.min(this.countColumns(), receiver.count());
            for (long j = 0L; j < limit; ++j) {
                receiver.set(j, (Number)this.aggregateColumn(j, aggregator));
            }
        }

        default public void reduceRows(Aggregator aggregator, Mutate1D receiver) {
            long limit = Math.min(this.countRows(), receiver.count());
            for (long i = 0L; i < limit; ++i) {
                receiver.set(i, (Number)this.aggregateRow(i, aggregator));
            }
        }
    }
}

