/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.AbstractMatrix;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.RationalNumber;

public final class RationalMatrix
extends AbstractMatrix<RationalNumber, RationalMatrix> {
    public static final BasicMatrix.Factory<RationalMatrix> FACTORY = new MatrixFactory<RationalNumber, RationalMatrix>(RationalMatrix.class, GenericDenseStore.RATIONAL);

    RationalMatrix(MatrixStore<RationalNumber> aStore) {
        super(aStore);
    }

    @Override
    ElementsSupplier<RationalNumber> cast(Access1D<?> matrix) {
        if (matrix instanceof RationalMatrix) {
            return ((RationalMatrix)matrix).getStore();
        }
        if (matrix instanceof GenericDenseStore) {
            return (GenericDenseStore)matrix;
        }
        if (matrix instanceof ElementsSupplier && matrix.count() > 0L && matrix.get(0L) instanceof RationalNumber) {
            return (ElementsSupplier)((Object)matrix);
        }
        if (matrix instanceof Access2D) {
            Access2D tmpAccess2D = (Access2D)matrix;
            return this.getStore().physical().builder().makeWrapper(tmpAccess2D);
        }
        return (ElementsSupplier)this.getStore().physical().columns(matrix);
    }

    @Override
    DeterminantTask<RationalNumber> getDeterminantTask(MatrixStore<RationalNumber> template) {
        return DeterminantTask.RATIONAL.make(template, this.isHermitian(), false);
    }

    @Override
    MatrixFactory<RationalNumber, RationalMatrix> getFactory() {
        return (MatrixFactory)FACTORY;
    }

    @Override
    InverterTask<RationalNumber> getInverterTask(MatrixStore<RationalNumber> template) {
        return InverterTask.RATIONAL.make(template, this.isHermitian(), false);
    }

    @Override
    SolverTask<RationalNumber> getSolverTask(MatrixStore<RationalNumber> templateBody, Access2D<?> templateRHS) {
        return SolverTask.RATIONAL.make(templateBody, templateRHS, this.isHermitian(), false);
    }
}

