/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.multiary.CompoundFunction;
import org.ojalgo.function.multiary.ConstantFunction;
import org.ojalgo.function.multiary.LinearFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.multiary.QuadraticFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.type.TypeUtils;

public final class Expression
extends ModelEntity<Expression> {
    private transient boolean myInfeasible = false;
    private final HashMap<Structure1D.IntIndex, BigDecimal> myLinear;
    private final ExpressionsBasedModel myModel;
    private final HashMap<Structure2D.IntRowColumn, BigDecimal> myQuadratic;
    private transient boolean myRedundant = false;
    private final boolean myShallowCopy;

    private Expression(Expression entityToCopy) {
        this(entityToCopy, null, false);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected Expression(Expression expressionToCopy, ExpressionsBasedModel destinationModel, boolean deep) {
        super(expressionToCopy);
        this.myModel = destinationModel;
        if (deep) {
            this.myShallowCopy = false;
            this.myLinear = new HashMap();
            this.myLinear.putAll(expressionToCopy.getLinear());
            this.myQuadratic = new HashMap();
            this.myQuadratic.putAll(expressionToCopy.getQuadratic());
        } else {
            this.myShallowCopy = true;
            this.myLinear = expressionToCopy.getLinear();
            this.myQuadratic = expressionToCopy.getQuadratic();
        }
    }

    Expression(String name, ExpressionsBasedModel model) {
        super(name);
        this.myModel = model;
        this.myShallowCopy = false;
        this.myLinear = new HashMap();
        this.myQuadratic = new HashMap();
        ProgrammingError.throwIfNull((Object)this.myModel, this.myLinear, this.myQuadratic);
    }

    public Expression add(Structure1D.IntIndex key, Number value) {
        BigDecimal tmpExisting = this.myLinear.get(key);
        if (tmpExisting != null) {
            this.set(key, (Number)TypeUtils.toBigDecimal(value).add(tmpExisting));
        } else {
            this.set(key, value);
        }
        return this;
    }

    public Expression add(Structure2D.IntRowColumn key, Number value) {
        BigDecimal tmpExisting = this.myQuadratic.get(key);
        if (tmpExisting != null) {
            this.set(key, (Number)TypeUtils.toBigDecimal(value).add(tmpExisting));
        } else {
            this.set(key, value);
        }
        return this;
    }

    @Override
    public final int compareTo(Expression obj) {
        return this.getName().compareTo(obj.getName());
    }

    public Expression compensate(Set<Structure1D.IntIndex> fixedVariables) {
        BigDecimal tmpFactor;
        Comparable<Structure1D.IntIndex> tmpKey;
        if (fixedVariables.size() == 0 || !this.isAnyQuadraticFactorNonZero() && Collections.disjoint(fixedVariables, this.getLinearKeySet())) {
            return this;
        }
        ExpressionsBasedModel tmpModel = this.getModel();
        Expression retVal = new Expression(this.getName(), tmpModel);
        BigDecimal tmpFixedValue = BigMath.ZERO;
        for (Map.Entry<Structure1D.IntIndex, BigDecimal> entry : this.myLinear.entrySet()) {
            tmpKey = entry.getKey();
            tmpFactor = entry.getValue();
            if (fixedVariables.contains(tmpKey)) {
                BigDecimal tmpValue = tmpModel.getVariable(tmpKey.index).getValue();
                tmpFixedValue = tmpFixedValue.add(tmpFactor.multiply(tmpValue));
                continue;
            }
            retVal.set((Structure1D.IntIndex)tmpKey, (Number)tmpFactor);
        }
        for (Map.Entry<Comparable<Structure1D.IntIndex>, BigDecimal> entry : this.myQuadratic.entrySet()) {
            tmpKey = (Structure2D.IntRowColumn)entry.getKey();
            tmpFactor = entry.getValue();
            Variable tmpRowVariable = tmpModel.getVariable(((Structure2D.IntRowColumn)tmpKey).row);
            Variable tmpColVariable = tmpModel.getVariable(((Structure2D.IntRowColumn)tmpKey).column);
            Structure1D.IntIndex tmpRowKey = tmpRowVariable.getIndex();
            Structure1D.IntIndex tmpColKey = tmpColVariable.getIndex();
            if (fixedVariables.contains(tmpRowKey)) {
                BigDecimal tmpRowValue = tmpRowVariable.getValue();
                if (fixedVariables.contains(tmpColKey)) {
                    BigDecimal tmpColValue = tmpColVariable.getValue();
                    tmpFixedValue = tmpFixedValue.add(tmpFactor.multiply(tmpRowValue).multiply(tmpColValue));
                    continue;
                }
                retVal.add(tmpColKey, (Number)tmpFactor.multiply(tmpRowValue));
                continue;
            }
            if (fixedVariables.contains(tmpColKey)) {
                BigDecimal tmpColValue = tmpColVariable.getValue();
                retVal.add(tmpRowKey, (Number)tmpFactor.multiply(tmpColValue));
                continue;
            }
            retVal.set((Structure2D.IntRowColumn)tmpKey, (Number)tmpFactor);
        }
        if (this.isLowerLimitSet()) {
            retVal.lower(this.getLowerLimit().subtract(tmpFixedValue));
        }
        if (this.isUpperLimitSet()) {
            retVal.upper(this.getUpperLimit().subtract(tmpFixedValue));
        }
        return retVal;
    }

    public BigDecimal evaluate(Access1D<BigDecimal> point) {
        BigDecimal tmpFactor;
        BigDecimal retVal = BigMath.ZERO;
        for (Structure2D.IntRowColumn intRowColumn : this.getQuadraticKeySet()) {
            tmpFactor = this.get(intRowColumn);
            retVal = retVal.add(tmpFactor.multiply(point.get(intRowColumn.row)).multiply(point.get(intRowColumn.column)));
        }
        for (Structure1D.IntIndex intIndex : this.getLinearKeySet()) {
            tmpFactor = this.get(intIndex);
            retVal = retVal.add(tmpFactor.multiply(point.get(intIndex.index)));
        }
        return retVal;
    }

    public BigDecimal get(Structure1D.IntIndex key) {
        return this.getLinearFactor(key, false);
    }

    public BigDecimal get(Structure2D.IntRowColumn key) {
        return this.getQuadraticFactor(key, false);
    }

    public BigDecimal get(Variable variable) {
        Structure1D.IntIndex tmpIndex = variable.getIndex();
        if (tmpIndex != null) {
            return this.get(tmpIndex);
        }
        throw new IllegalStateException("Variable not part of (this) model!");
    }

    public MatrixStore<Double> getAdjustedGradient(Access1D<?> point) {
        UnaryFunction<double> tmpModFunc;
        double tmpAdjustedFactor;
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(this.myModel.countVariables(), 1L);
        PrimitiveFunction.Binary tmpBaseFunc = PrimitiveFunction.ADD;
        for (Structure2D.IntRowColumn intRowColumn : this.getQuadraticKeySet()) {
            tmpAdjustedFactor = this.getAdjustedQuadraticFactor(intRowColumn);
            tmpModFunc = tmpBaseFunc.second(tmpAdjustedFactor * point.doubleValue(intRowColumn.column));
            retVal.modifyOne((long)intRowColumn.row, 0L, (UnaryFunction<Double>)tmpModFunc);
            tmpModFunc = tmpBaseFunc.second(tmpAdjustedFactor * point.doubleValue(intRowColumn.row));
            retVal.modifyOne((long)intRowColumn.column, 0L, (UnaryFunction<Double>)tmpModFunc);
        }
        for (Structure1D.IntIndex intIndex : this.getLinearKeySet()) {
            tmpAdjustedFactor = this.getAdjustedLinearFactor(intIndex);
            tmpModFunc = tmpBaseFunc.second(tmpAdjustedFactor);
            retVal.modifyOne((long)intIndex.index, 0L, (UnaryFunction<Double>)tmpModFunc);
        }
        return retVal;
    }

    public MatrixStore<Double> getAdjustedHessian() {
        int tmpCountVariables = this.myModel.countVariables();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpCountVariables, tmpCountVariables);
        PrimitiveFunction.Binary tmpBaseFunc = PrimitiveFunction.ADD;
        for (Structure2D.IntRowColumn tmpKey : this.getQuadraticKeySet()) {
            UnaryFunction<double> tmpModFunc = tmpBaseFunc.second(this.getAdjustedQuadraticFactor(tmpKey));
            retVal.modifyOne((long)tmpKey.row, (long)tmpKey.column, (UnaryFunction<Double>)tmpModFunc);
            retVal.modifyOne((long)tmpKey.column, (long)tmpKey.row, (UnaryFunction<Double>)tmpModFunc);
        }
        return retVal;
    }

    public double getAdjustedLinearFactor(int aVar) {
        return this.getAdjustedLinearFactor(new Structure1D.IntIndex(aVar));
    }

    public double getAdjustedLinearFactor(Structure1D.IntIndex key) {
        return this.getLinearFactor(key, true).doubleValue();
    }

    public double getAdjustedLinearFactor(Variable aVar) {
        return this.getAdjustedLinearFactor(aVar.getIndex());
    }

    public double getAdjustedQuadraticFactor(int aVar1, int aVar2) {
        return this.getAdjustedQuadraticFactor(new Structure2D.IntRowColumn(aVar1, aVar2));
    }

    public double getAdjustedQuadraticFactor(Structure2D.IntRowColumn key) {
        return this.getQuadraticFactor(key, true).doubleValue();
    }

    public double getAdjustedQuadraticFactor(Variable aVar1, Variable aVar2) {
        return this.getAdjustedQuadraticFactor(this.myModel.indexOf(aVar1), this.myModel.indexOf(aVar2));
    }

    public Set<Map.Entry<Structure1D.IntIndex, BigDecimal>> getLinearEntrySet() {
        return this.myLinear.entrySet();
    }

    public Set<Structure1D.IntIndex> getLinearKeySet() {
        return this.myLinear.keySet();
    }

    public Set<Map.Entry<Structure2D.IntRowColumn, BigDecimal>> getQuadraticEntrySet() {
        return this.myQuadratic.entrySet();
    }

    public Set<Structure2D.IntRowColumn> getQuadraticKeySet() {
        return this.myQuadratic.keySet();
    }

    public boolean isAnyLinearFactorNonZero() {
        return this.myLinear.size() > 0;
    }

    public boolean isAnyQuadraticFactorNonZero() {
        return this.myQuadratic.size() > 0;
    }

    public boolean isFunctionCompound() {
        return this.isAnyQuadraticFactorNonZero() && this.isAnyLinearFactorNonZero();
    }

    public boolean isFunctionLinear() {
        return !this.isAnyQuadraticFactorNonZero() && this.isAnyLinearFactorNonZero();
    }

    public boolean isFunctionQuadratic() {
        return this.isAnyQuadraticFactorNonZero() && !this.isAnyLinearFactorNonZero();
    }

    public boolean isFunctionZero() {
        return !this.isAnyQuadraticFactorNonZero() && !this.isAnyLinearFactorNonZero();
    }

    public boolean isLinearAndAllBinary() {
        return this.myQuadratic.size() == 0 && this.myLinear.size() > 0 && this.myLinear.keySet().stream().allMatch(i -> this.myModel.getVariable((Structure1D.IntIndex)i).isBinary());
    }

    public boolean isLinearAndAllInteger() {
        return this.myQuadratic.size() == 0 && this.myLinear.size() > 0 && this.myLinear.keySet().stream().allMatch(i -> this.myModel.getVariable((Structure1D.IntIndex)i).isInteger());
    }

    public boolean isLinearAndAnyBinary() {
        return this.myQuadratic.size() == 0 && this.myLinear.size() > 0 && this.myLinear.keySet().stream().anyMatch(i -> this.myModel.getVariable((Structure1D.IntIndex)i).isBinary());
    }

    public boolean isLinearAndAnyInteger() {
        return this.myQuadratic.size() == 0 && this.myLinear.size() > 0 && this.myLinear.keySet().stream().anyMatch(i -> this.myModel.getVariable((Structure1D.IntIndex)i).isInteger());
    }

    public Expression set(int row, int column, Number value) {
        return this.set(new Structure2D.IntRowColumn(row, column), value);
    }

    public Expression set(int index, Number value) {
        return this.set(this.myModel.getVariable(index), value);
    }

    public Expression set(Structure1D.IntIndex key, Number value) {
        if (key != null) {
            BigDecimal tmpValue = TypeUtils.toBigDecimal(value);
            if (tmpValue.signum() != 0) {
                this.myLinear.put(key, tmpValue);
            } else {
                this.myLinear.remove(key);
            }
        } else {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Expression set(Structure2D.IntRowColumn key, Number value) {
        if (key != null) {
            BigDecimal tmpValue = TypeUtils.toBigDecimal(value);
            if (tmpValue.signum() != 0) {
                this.myQuadratic.put(key, tmpValue);
            } else {
                this.myQuadratic.remove(key);
            }
        } else {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Expression set(Variable variable, Number value) {
        return this.set(variable.getIndex(), value);
    }

    public Expression set(Variable variable1, Variable variable2, Number value) {
        return this.set(variable1.getIndex().index, variable2.getIndex().index, value);
    }

    public void setCompoundFactorsOffset(List<Variable> variables, Access1D<?> point) {
        int tmpLength = variables.size();
        if (point.count() != (long)tmpLength) {
            throw new IllegalArgumentException();
        }
        BigDecimal tmpLinearWeight = BigMath.TWO.negate();
        for (int ij = 0; ij < tmpLength; ++ij) {
            Variable tmpVariable = variables.get(ij);
            BigDecimal tmpVal = TypeUtils.toBigDecimal(point.get(ij));
            this.set(tmpVariable, tmpVariable, (Number)BigMath.ONE);
            this.set(tmpVariable, (Number)tmpVal.multiply(tmpLinearWeight));
        }
    }

    public void setLinearFactors(List<Variable> variables, Access1D<?> factors) {
        int tmpLimit = variables.size();
        if (factors.count() != (long)tmpLimit) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < tmpLimit; ++i) {
            this.set(variables.get(i), (Number)factors.get(i));
        }
    }

    public void setLinearFactorsSimple(List<Variable> variables) {
        for (Variable tmpVariable : variables) {
            this.set(tmpVariable, (Number)BigMath.ONE);
        }
    }

    public void setQuadraticFactors(List<Variable> variables, Access2D<?> factors) {
        int tmpLimit = variables.size();
        if (factors.countRows() != (long)tmpLimit || factors.countColumns() != (long)tmpLimit) {
            throw new IllegalArgumentException();
        }
        for (int j = 0; j < tmpLimit; ++j) {
            Variable tmpVar2 = variables.get(j);
            for (int i = 0; i < tmpLimit; ++i) {
                this.set(variables.get(i), tmpVar2, (Number)factors.get(i, j));
            }
        }
    }

    public MultiaryFunction.TwiceDifferentiable<Double> toFunction() {
        if (this.isFunctionCompound()) {
            return this.getCompoundFunction();
        }
        if (this.isFunctionQuadratic()) {
            return this.getQuadraticFunction();
        }
        if (this.isFunctionLinear()) {
            return this.getLinearFunction();
        }
        return this.getZeroFunction();
    }

    private final BigDecimal convert(BigDecimal value, boolean adjusted) {
        if (value != null) {
            if (adjusted) {
                int tmpAdjExp = this.getAdjustmentExponent();
                if (tmpAdjExp != 0) {
                    return value.movePointRight(tmpAdjExp);
                }
                return value;
            }
            return value;
        }
        return BigMath.ZERO;
    }

    protected void appendMiddlePart(StringBuilder builder, Access1D<BigDecimal> currentSolution) {
        builder.append(this.getName());
        builder.append(": ");
        builder.append(ModelEntity.DISPLAY.enforce(this.toFunction().invoke(Access1D.asPrimitive1D(currentSolution))));
        if (this.isObjective()) {
            builder.append(" (");
            builder.append(ModelEntity.DISPLAY.enforce(this.getContributionWeight()));
            builder.append(")");
        }
    }

    @Override
    protected void destroy() {
        super.destroy();
        if (!this.myShallowCopy) {
            this.myLinear.clear();
            this.myQuadratic.clear();
        }
    }

    void appendToString(StringBuilder aStringBuilder, Access1D<BigDecimal> aCurrentState) {
        this.appendLeftPart(aStringBuilder);
        if (aCurrentState != null) {
            this.appendMiddlePart(aStringBuilder, aCurrentState);
        } else {
            this.appendMiddlePart(aStringBuilder);
        }
        this.appendRightPart(aStringBuilder);
    }

    BigDecimal calculateFixedValue(Collection<Structure1D.IntIndex> fixedVariables) {
        BigDecimal retVal = BigMath.ZERO;
        if (fixedVariables.size() > 0) {
            BigDecimal tmpFactor;
            for (Structure1D.IntIndex intIndex : this.myLinear.keySet()) {
                if (!fixedVariables.contains(intIndex)) continue;
                tmpFactor = this.get(intIndex);
                BigDecimal tmpValue = this.myModel.getVariable(intIndex.index).getValue();
                retVal = retVal.add(tmpFactor.multiply(tmpValue));
            }
            for (Structure2D.IntRowColumn intRowColumn : this.myQuadratic.keySet()) {
                if (!fixedVariables.contains(new Structure1D.IntIndex(intRowColumn.row)) || !fixedVariables.contains(new Structure1D.IntIndex(intRowColumn.column))) continue;
                tmpFactor = this.get(intRowColumn);
                BigDecimal tmpRowValue = this.myModel.getVariable(intRowColumn.row).getValue();
                BigDecimal tmpColValue = this.myModel.getVariable(intRowColumn.column).getValue();
                retVal = retVal.add(tmpFactor.multiply(tmpRowValue).multiply(tmpColValue));
            }
        }
        return retVal;
    }

    Expression copy(ExpressionsBasedModel destinationModel, boolean deep) {
        return new Expression(this, destinationModel, deep);
    }

    int countLinearFactors() {
        return this.myLinear.size();
    }

    int countQuadraticFactors() {
        return this.myQuadratic.size();
    }

    Set<Variable> getBinaryVariables(Set<Structure1D.IntIndex> fixedVariables) {
        HashSet<Variable> retVal = new HashSet<Variable>();
        for (Structure1D.IntIndex varInd : this.myLinear.keySet()) {
            Variable variable;
            if (fixedVariables.contains(varInd) || !(variable = this.myModel.getVariable(varInd.index)).isBinary()) continue;
            retVal.add(variable);
        }
        return retVal;
    }

    CompoundFunction<Double> getCompoundFunction() {
        CompoundFunction<Double> retVal = CompoundFunction.makePrimitive(this.myModel.countVariables());
        if (this.isAnyQuadraticFactorNonZero()) {
            for (Map.Entry<Comparable<Structure2D.IntRowColumn>, BigDecimal> entry : this.myQuadratic.entrySet()) {
                retVal.quadratic().set((long)((Structure2D.IntRowColumn)entry.getKey()).row, (long)((Structure2D.IntRowColumn)entry.getKey()).column, entry.getValue().doubleValue());
            }
        }
        if (this.isAnyLinearFactorNonZero()) {
            for (Map.Entry<Comparable<Structure2D.IntRowColumn>, BigDecimal> entry : this.myLinear.entrySet()) {
                retVal.linear().set((long)((Structure1D.IntIndex)entry.getKey()).index, entry.getValue().doubleValue());
            }
        }
        return retVal;
    }

    HashMap<Structure1D.IntIndex, BigDecimal> getLinear() {
        return this.myLinear;
    }

    BigDecimal getLinearFactor(Structure1D.IntIndex key, boolean adjusted) {
        return this.convert(this.myLinear.get(key), adjusted);
    }

    LinearFunction<Double> getLinearFunction() {
        LinearFunction<Double> retVal = LinearFunction.makePrimitive(this.myModel.countVariables());
        if (this.isAnyLinearFactorNonZero()) {
            for (Map.Entry<Structure1D.IntIndex, BigDecimal> tmpEntry : this.myLinear.entrySet()) {
                retVal.linear().set((long)tmpEntry.getKey().index, tmpEntry.getValue().doubleValue());
            }
        }
        return retVal;
    }

    ExpressionsBasedModel getModel() {
        return this.myModel;
    }

    HashMap<Structure2D.IntRowColumn, BigDecimal> getQuadratic() {
        return this.myQuadratic;
    }

    BigDecimal getQuadraticFactor(Structure2D.IntRowColumn key, boolean adjusted) {
        return this.convert(this.myQuadratic.get(key), adjusted);
    }

    QuadraticFunction<Double> getQuadraticFunction() {
        QuadraticFunction<Double> retVal = QuadraticFunction.makePrimitive(this.myModel.countVariables());
        if (this.isAnyQuadraticFactorNonZero()) {
            for (Map.Entry<Structure2D.IntRowColumn, BigDecimal> tmpEntry : this.myQuadratic.entrySet()) {
                retVal.quadratic().set((long)tmpEntry.getKey().row, (long)tmpEntry.getKey().column, tmpEntry.getValue().doubleValue());
            }
        }
        return retVal;
    }

    ConstantFunction<Double> getZeroFunction() {
        return ConstantFunction.makePrimitive(this.myModel.countVariables());
    }

    boolean includes(Variable variable) {
        Structure1D.IntIndex tmpVarInd = variable.getIndex();
        return this.myLinear.containsKey(tmpVarInd) || this.myQuadratic.size() > 0 && this.myQuadratic.keySet().stream().anyMatch(k -> k.row == tmpVarInd.index || k.column == tmpVarInd.index);
    }

    @Override
    boolean isInfeasible() {
        return this.myInfeasible || super.isInfeasible();
    }

    boolean isNegative(Set<Structure1D.IntIndex> fixedVariables) {
        boolean retVal;
        boolean bl = retVal = !this.isAnyQuadraticFactorNonZero();
        if (retVal) {
            for (Map.Entry<Structure1D.IntIndex, BigDecimal> tmpLinear : this.getLinearEntrySet()) {
                if (!retVal || fixedVariables.contains(tmpLinear.getKey())) continue;
                Variable tmpFreeVariable = this.myModel.getVariable(tmpLinear.getKey().index);
                if (tmpLinear.getValue().signum() < 0 && tmpFreeVariable.isLowerLimitSet() && tmpFreeVariable.getLowerLimit().signum() >= 0) {
                    retVal &= true;
                    continue;
                }
                if (tmpLinear.getValue().signum() > 0 && tmpFreeVariable.isUpperLimitSet() && tmpFreeVariable.getUpperLimit().signum() <= 0) {
                    retVal &= true;
                    continue;
                }
                retVal &= false;
            }
        }
        return retVal;
    }

    boolean isPositive(Set<Structure1D.IntIndex> fixedVariables) {
        boolean retVal;
        boolean bl = retVal = !this.isAnyQuadraticFactorNonZero();
        if (retVal) {
            for (Map.Entry<Structure1D.IntIndex, BigDecimal> tmpLinear : this.getLinearEntrySet()) {
                if (!retVal || fixedVariables.contains(tmpLinear.getKey())) continue;
                Variable tmpFreeVariable = this.myModel.getVariable(tmpLinear.getKey().index);
                if (tmpLinear.getValue().signum() > 0 && tmpFreeVariable.isLowerLimitSet() && tmpFreeVariable.getLowerLimit().signum() >= 0) {
                    retVal &= true;
                    continue;
                }
                if (tmpLinear.getValue().signum() < 0 && tmpFreeVariable.isUpperLimitSet() && tmpFreeVariable.getUpperLimit().signum() <= 0) {
                    retVal &= true;
                    continue;
                }
                retVal &= false;
            }
        }
        return retVal;
    }

    boolean isRedundant() {
        return this.myRedundant;
    }

    void setInfeasible() {
        this.myInfeasible = true;
    }

    void setRedundant(boolean redundant) {
        this.myRedundant = redundant;
    }

    @Override
    void visitAllParameters(VoidFunction<BigDecimal> largest, VoidFunction<BigDecimal> smallest) {
        if (this.isAnyQuadraticFactorNonZero()) {
            for (BigDecimal quadraticFactor : this.myQuadratic.values()) {
                largest.invoke(quadraticFactor);
                smallest.invoke(quadraticFactor);
            }
        } else if (this.isAnyLinearFactorNonZero()) {
            for (BigDecimal linearFactor : this.myLinear.values()) {
                largest.invoke(linearFactor);
                smallest.invoke(linearFactor);
            }
        } else {
            super.visitAllParameters(largest, smallest);
        }
    }
}

