/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.ojalgo.access.Access1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.integer.NodeKey;
import org.ojalgo.optimisation.integer.OldIntegerSolver;

public abstract class IntegerSolver
extends GenericSolver {
    private volatile Optimisation.Result myBestResultSoFar = null;
    private final MultiaryFunction.TwiceDifferentiable<Double> myFunction;
    private final int[] myIntegerIndices;
    private final ExpressionsBasedModel myIntegerModel;
    private final double[] myIntegerSignificances;
    private final AtomicInteger myIntegerSolutionsCount = new AtomicInteger();
    private final boolean myMinimisation;
    private final NodeStatistics myNodeStatistics = new NodeStatistics();

    public static IntegerSolver make(ExpressionsBasedModel model) {
        return new OldIntegerSolver(model, model.options);
    }

    protected IntegerSolver(ExpressionsBasedModel model, Optimisation.Options solverOptions) {
        super(solverOptions);
        this.myIntegerModel = model.simplify();
        this.myFunction = this.myIntegerModel.objective().toFunction();
        this.myMinimisation = this.myIntegerModel.isMinimisation();
        List<Variable> integerVariables = this.myIntegerModel.getIntegerVariables();
        this.myIntegerIndices = new int[integerVariables.size()];
        for (int i = 0; i < this.myIntegerIndices.length; ++i) {
            this.myIntegerIndices[i] = this.myIntegerModel.indexOf(integerVariables.get(i));
        }
        this.myIntegerSignificances = new double[integerVariables.size()];
        Arrays.fill(this.myIntegerSignificances, PrimitiveMath.ONE);
    }

    protected int countIntegerSolutions() {
        return this.myIntegerSolutionsCount.intValue();
    }

    @Override
    protected final double evaluateFunction(Access1D<?> solution) {
        if (this.myFunction != null && solution != null && (long)this.myFunction.arity() == solution.count()) {
            return this.myFunction.invoke(Access1D.asPrimitive1D(solution));
        }
        return Double.NaN;
    }

    protected Optimisation.Result getBestResultSoFar() {
        Optimisation.Result tmpCurrentlyTheBest = this.myBestResultSoFar;
        if (tmpCurrentlyTheBest != null) {
            return tmpCurrentlyTheBest;
        }
        Optimisation.State tmpSate = Optimisation.State.INVALID;
        double tmpValue = this.myMinimisation ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        Object tmpSolution = MatrixStore.PRIMITIVE.makeZero(this.getIntegerModel().countVariables(), 1).get();
        return new Optimisation.Result(tmpSate, tmpValue, (Access1D<?>)tmpSolution);
    }

    protected final MatrixStore<Double> getGradient(Access1D<Double> solution) {
        return this.myFunction.getGradient(solution);
    }

    protected ExpressionsBasedModel getIntegerModel() {
        return this.myIntegerModel;
    }

    protected final ExpressionsBasedModel getRelaxedModel() {
        return this.myIntegerModel.relax(false);
    }

    protected abstract boolean initialise(Optimisation.Result var1);

    protected final boolean isFunctionSet() {
        return this.myFunction != null;
    }

    protected boolean isGoodEnoughToContinueBranching(double relaxedNodeValue) {
        Optimisation.Result bestResultSoFar = this.myBestResultSoFar;
        if (bestResultSoFar == null || Double.isNaN(relaxedNodeValue)) {
            return true;
        }
        double bestIntegerValue = bestResultSoFar.getValue();
        double absoluteGap = PrimitiveFunction.ABS.invoke(bestIntegerValue - relaxedNodeValue);
        double relativeGap = PrimitiveFunction.ABS.invoke(absoluteGap / bestIntegerValue);
        if (this.myMinimisation) {
            return relaxedNodeValue < bestIntegerValue && relativeGap > this.options.mip_gap && absoluteGap > this.options.mip_gap;
        }
        return relaxedNodeValue > bestIntegerValue && relativeGap > this.options.mip_gap && absoluteGap > this.options.mip_gap;
    }

    protected boolean isIntegerSolutionFound() {
        return this.myBestResultSoFar != null;
    }

    protected boolean isIterationNecessary() {
        if (this.myBestResultSoFar == null) {
            return true;
        }
        return this.countTime() < this.options.time_suffice && this.countIterations() < this.options.iterations_suffice;
    }

    protected final boolean isModelSet() {
        return this.myIntegerModel != null;
    }

    protected synchronized void markInteger(NodeKey key, ExpressionsBasedModel model, Optimisation.Result result) {
        Optimisation.Result tmpCurrentlyTheBest;
        if (this.isProgress()) {
            this.log("New integer solution {}", result);
            this.log("\t@ node {}", key);
        }
        if ((tmpCurrentlyTheBest = this.myBestResultSoFar) == null) {
            this.myBestResultSoFar = result;
        } else if (this.myMinimisation && result.getValue() < tmpCurrentlyTheBest.getValue()) {
            this.myBestResultSoFar = result;
        } else if (!this.myMinimisation && result.getValue() > tmpCurrentlyTheBest.getValue()) {
            this.myBestResultSoFar = result;
        } else if (this.isDebug()) {
            this.log("Previously best {}", this.myBestResultSoFar);
        }
        if (tmpCurrentlyTheBest != null) {
            double objDiff = PrimitiveFunction.ABS.invoke((result.getValue() - tmpCurrentlyTheBest.getValue()) / tmpCurrentlyTheBest.getValue());
            for (int i = 0; i < this.myIntegerIndices.length; ++i) {
                double varDiff = PrimitiveFunction.ABS.invoke(result.doubleValue(this.myIntegerIndices[i]) - tmpCurrentlyTheBest.doubleValue(this.myIntegerIndices[i]));
                if (this.options.feasibility.isZero(varDiff)) continue;
                this.addIntegerSignificance(i, objDiff / varDiff);
            }
        } else {
            MatrixStore<Double> gradient = this.getGradient(Access1D.asPrimitive1D(result));
            double largest = gradient.aggregateAll(Aggregator.LARGEST);
            if (largest > PrimitiveMath.ZERO) {
                for (int i = 0; i < this.myIntegerIndices.length; ++i) {
                    this.addIntegerSignificance(i, PrimitiveFunction.ABS.invoke(gradient.doubleValue(this.myIntegerIndices[i])) / largest);
                }
            }
        }
        this.myIntegerSolutionsCount.incrementAndGet();
    }

    protected abstract boolean needsAnotherIteration();

    protected abstract boolean validate();

    void addIntegerSignificance(int index, double significance) {
        int n = index;
        this.myIntegerSignificances[n] = this.myIntegerSignificances[n] + significance;
    }

    final int getGlobalIndex(int integerIndex) {
        return this.myIntegerIndices[integerIndex];
    }

    final int[] getIntegerIndices() {
        return this.myIntegerIndices;
    }

    double getIntegerSignificance(int index) {
        return this.myIntegerSignificances[index];
    }

    final int identifyNonIntegerVariable(Optimisation.Result nodeResult, NodeKey nodeKey) {
        int retVal = -1;
        double compareFraction = PrimitiveMath.ZERO;
        double maxFraction = PrimitiveMath.ZERO;
        for (int i = 0; i < this.myIntegerIndices.length; ++i) {
            double fraction = nodeKey.getFraction(i, nodeResult.doubleValue(this.myIntegerIndices[i]));
            if (this.options.feasibility.isZero(fraction) || !((compareFraction = this.isIntegerSolutionFound() ? fraction * this.getIntegerSignificance(i) : PrimitiveMath.ONE - fraction) > maxFraction)) continue;
            retVal = i;
            maxFraction = compareFraction;
        }
        return retVal;
    }

    static final class NodeStatistics {
        private final AtomicInteger myAbandoned = new AtomicInteger();
        private final AtomicInteger myBranched = new AtomicInteger();
        private final AtomicInteger myExhausted = new AtomicInteger();
        private final AtomicInteger myFailed = new AtomicInteger();
        private final AtomicInteger myInfeasible = new AtomicInteger();
        private final AtomicInteger myInteger = new AtomicInteger();
        private final AtomicInteger myTruncated = new AtomicInteger();

        NodeStatistics() {
        }

        public int countCreated() {
            return this.myTruncated.get() + this.myAbandoned.get() + this.countEvaluated();
        }

        public int countEvaluated() {
            return this.myInfeasible.get() + this.myFailed.get() + this.myExhausted.get() + this.myBranched.get();
        }

        boolean abandoned() {
            this.myAbandoned.incrementAndGet();
            return true;
        }

        boolean branched() {
            this.myBranched.incrementAndGet();
            return true;
        }

        boolean exhausted() {
            this.myExhausted.incrementAndGet();
            return true;
        }

        boolean failed(boolean state) {
            this.myFailed.incrementAndGet();
            return state;
        }

        boolean infeasible() {
            this.myInfeasible.incrementAndGet();
            return true;
        }

        boolean infeasible(boolean state) {
            this.myInfeasible.incrementAndGet();
            return state;
        }

        boolean integer() {
            this.myInteger.incrementAndGet();
            return true;
        }

        boolean truncated(boolean state) {
            this.myTruncated.incrementAndGet();
            return state;
        }
    }

    public static final class ModelIntegration
    extends ExpressionsBasedModel.Integration<IntegerSolver> {
        @Override
        public IntegerSolver build(ExpressionsBasedModel model) {
            return IntegerSolver.make(model);
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            return !model.isAnyConstraintQuadratic();
        }

        @Override
        public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
            return solverState;
        }

        @Override
        public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
            return modelState;
        }

        @Override
        protected boolean isSolutionMapped() {
            return false;
        }
    }
}

