/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.ojalgo.access.Access1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.random.Normal1D;
import org.ojalgo.type.keyvalue.ComparableToDouble;

public final class GaussianField<K extends Comparable<? super K>> {
    private static final PhysicalStore.Factory<Double, PrimitiveDenseStore> FACTORY = PrimitiveDenseStore.FACTORY;
    private final Covariance<K> myCovarianceFunction;
    private final Mean<K> myMeanFunction;
    private final TreeSet<ComparableToDouble<K>> myObservations;

    private static <K extends Comparable<? super K>> Mean<K> mean() {
        return new Mean<K>(){

            @Override
            public void calibrate(Collection<ComparableToDouble<K>> observations) {
            }

            @Override
            public double invoke(K anArg) {
                return PrimitiveMath.ZERO;
            }
        };
    }

    public GaussianField(Covariance<K> covarFunc) {
        this(GaussianField.mean(), covarFunc, new TreeSet<ComparableToDouble<K>>());
    }

    public GaussianField(Mean<K> meanFunc, Covariance<K> covarFunc) {
        this(meanFunc, covarFunc, new TreeSet<ComparableToDouble<K>>());
    }

    private GaussianField() {
        this(null, null, null);
    }

    GaussianField(Covariance<K> covarFunc, TreeSet<ComparableToDouble<K>> observations) {
        this(GaussianField.mean(), covarFunc, observations);
    }

    GaussianField(Mean<K> meanFunc, Covariance<K> covarFunc, TreeSet<ComparableToDouble<K>> observations) {
        this.myMeanFunction = meanFunc;
        this.myCovarianceFunction = covarFunc;
        this.myObservations = observations;
    }

    public void addObservation(K key, double value) {
        this.myObservations.add(new ComparableToDouble<K>(key, value));
    }

    public void calibrate() {
        this.myMeanFunction.calibrate(this.myObservations);
        this.myCovarianceFunction.calibrate(this.myObservations, this.myMeanFunction);
    }

    public Normal1D getDistribution(boolean cleanCovariances, K ... evaluationPoint) {
        MatrixStore tmpRegCoef = this.getRegressionCoefficients((Comparable[])evaluationPoint);
        MatrixStore tmpM1 = this.getM1((Comparable[])evaluationPoint);
        MatrixStore<Double> tmpM2differenses = this.getM2differenses();
        PrimitiveDenseStore tmpLocations = (PrimitiveDenseStore)FACTORY.makeZero(tmpM1.countRows(), tmpM1.countColumns());
        tmpLocations.fillMatching(tmpM1, PrimitiveFunction.ADD, (Access1D<Double>)tmpRegCoef.multiply(tmpM2differenses));
        MatrixStore tmpC11 = this.getC11((Comparable[])evaluationPoint);
        MatrixStore tmpC21 = this.getC21((Comparable[])evaluationPoint);
        PrimitiveDenseStore tmpCovariances = (PrimitiveDenseStore)FACTORY.makeZero(tmpC11.countRows(), tmpC11.countColumns());
        tmpCovariances.fillMatching(tmpC11, PrimitiveFunction.SUBTRACT, (Access1D<Double>)tmpRegCoef.multiply(tmpC21));
        if (cleanCovariances) {
            Eigenvalue<Double> tmpEvD = Eigenvalue.PRIMITIVE.make(true);
            tmpEvD.decompose(tmpCovariances);
            MatrixStore<Double> tmpV = tmpEvD.getV();
            PhysicalStore<Double> tmpD = tmpEvD.getD().copy();
            double tmpLargest = tmpD.doubleValue(0L, 0L);
            double tmpLimit = PrimitiveFunction.MAX.invoke(PrimitiveMath.MACHINE_EPSILON * tmpLargest, 1.0E-12);
            int tmpLength = (int)Math.min(tmpD.countRows(), tmpD.countColumns());
            for (int ij = 0; ij < tmpLength; ++ij) {
                if (!(tmpD.doubleValue(ij, ij) < tmpLimit)) continue;
                tmpD.set((long)ij, (long)ij, tmpLimit);
            }
            tmpCovariances.fillMatching(tmpV.multiply((Double)((Object)tmpD)).multiply((PhysicalStore<Double>)((MatrixStore.LogicalBuilder)tmpV.logical().transpose()).get()));
        }
        return new Normal1D(tmpLocations, tmpCovariances);
    }

    public Normal1D getDistribution(K ... evaluationPoint) {
        return this.getDistribution(false, (Comparable[])evaluationPoint);
    }

    MatrixStore<Double> getC11(K[] args) {
        int tmpLength = args.length;
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)FACTORY.makeZero(tmpLength, tmpLength);
        for (int j = 0; j < tmpLength; ++j) {
            for (int i = 0; i < tmpLength; ++i) {
                retVal.set((long)i, (long)j, this.myCovarianceFunction.invoke(args[i], args[j]));
            }
        }
        return retVal;
    }

    MatrixStore<Double> getC12(K[] args) {
        List<ComparableToDouble<K>> tmpObservations = this.getObservations();
        int tmpRowDim = args.length;
        int tmpColDim = tmpObservations.size();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)FACTORY.makeZero(tmpRowDim, tmpColDim);
        for (int j = 0; j < tmpColDim; ++j) {
            for (int i = 0; i < tmpRowDim; ++i) {
                retVal.set((long)i, (long)j, this.myCovarianceFunction.invoke(args[i], tmpObservations.get((int)j).key));
            }
        }
        return retVal;
    }

    MatrixStore<Double> getC21(K[] args) {
        List<ComparableToDouble<K>> tmpObservations = this.getObservations();
        int tmpRowDim = tmpObservations.size();
        int tmpColDim = args.length;
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)FACTORY.makeZero(tmpRowDim, tmpColDim);
        for (int j = 0; j < tmpColDim; ++j) {
            for (int i = 0; i < tmpRowDim; ++i) {
                retVal.set((long)i, (long)j, this.myCovarianceFunction.invoke(tmpObservations.get((int)i).key, args[j]));
            }
        }
        return retVal;
    }

    MatrixDecomposition.Solver<Double> getC22() {
        List<ComparableToDouble<K>> tmpObservations = this.getObservations();
        int tmpSize = tmpObservations.size();
        PrimitiveDenseStore tmpMatrix = (PrimitiveDenseStore)FACTORY.makeZero(tmpSize, tmpSize);
        for (int j = 0; j < tmpSize; ++j) {
            Object tmpColumnKey = tmpObservations.get((int)j).key;
            for (int i = 0; i < tmpSize; ++i) {
                tmpMatrix.set((long)i, (long)j, this.myCovarianceFunction.invoke(tmpObservations.get((int)i).key, tmpColumnKey));
            }
        }
        SingularValue retVal = (SingularValue)SingularValue.PRIMITIVE.make();
        retVal.decompose(tmpMatrix);
        return retVal;
    }

    MatrixStore<Double> getM1(K[] args) {
        int tmpLength = args.length;
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)FACTORY.makeZero(tmpLength, 1L);
        for (int i = 0; i < tmpLength; ++i) {
            retVal.set((long)i, 0L, this.myMeanFunction.invoke(args[i]));
        }
        return retVal;
    }

    MatrixStore<Double> getM2() {
        List<ComparableToDouble<K>> tmpObservations = this.getObservations();
        int tmpSize = tmpObservations.size();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)FACTORY.makeZero(tmpSize, 1L);
        for (int i = 0; i < tmpSize; ++i) {
            retVal.set((long)i, 0L, this.myMeanFunction.invoke(tmpObservations.get((int)i).key));
        }
        return retVal;
    }

    MatrixStore<Double> getM2differenses() {
        List<ComparableToDouble<K>> tmpObservations = this.getObservations();
        int tmpSize = tmpObservations.size();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)FACTORY.makeZero(tmpSize, 1L);
        for (int i = 0; i < tmpSize; ++i) {
            ComparableToDouble<K> tmpObservation = tmpObservations.get(i);
            double tmpDiff = tmpObservation.value - this.myMeanFunction.invoke(tmpObservation.key);
            retVal.set((long)i, 0L, tmpDiff);
        }
        return retVal;
    }

    List<ComparableToDouble<K>> getObservations() {
        return new ArrayList<ComparableToDouble<K>>(this.myObservations);
    }

    MatrixStore<Double> getRegressionCoefficients(K[] args) {
        return ((MatrixStore.LogicalBuilder)this.getC22().getSolution(this.getC21((Comparable[])args)).logical().transpose()).get();
    }

    public static interface Mean<K extends Comparable<? super K>> {
        public void calibrate(Collection<ComparableToDouble<K>> var1);

        public double invoke(K var1);
    }

    public static interface Covariance<K extends Comparable<? super K>> {
        public void calibrate(Collection<ComparableToDouble<K>> var1, Mean<K> var2);

        public double invoke(K var1, K var2);
    }
}

