/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import view5d.AnElement;

public class DoubleElement
extends AnElement {
    public double[] myData;
    int SizeXY;

    DoubleElement(int SX, int SY, int SZ, double MaxVal) {
        super(SX, SY, SZ, MaxVal);
        this.myData = new double[this.Sizes[0] * this.Sizes[1] * this.Sizes[2]];
        this.SizeXY = this.Sizes[0] * this.Sizes[1];
        this.DataType = DoubleType;
    }

    @Override
    void Clear() {
        for (int i = 0; i < this.Sizes[0] * this.Sizes[1] * this.Sizes[2]; ++i) {
            this.myData[i] = 0.0;
        }
    }

    @Override
    void DeleteData() {
        this.myData = null;
    }

    @Override
    int GetStdByteNum() {
        return 8;
    }

    @Override
    void SetValueAt(int x, int y, int z, double val) {
        this.myData[x + this.Sizes[0] * y + this.SizeXY * z] = (float)val;
    }

    @Override
    int GetIntValueAt(int x, int y, int z) {
        return (int)((this.myData[x + this.Sizes[0] * y + this.SizeXY * z] - this.shift) * this.scaleI);
    }

    @Override
    int GetByteValueAt(int x, int y, int z) {
        return (int)((this.myData[x + this.Sizes[0] * y + this.SizeXY * z] - this.shift) * this.scaleB);
    }

    @Override
    double GetRawValueAt(int x, int y, int z) {
        return this.myData[x + this.Sizes[0] * y + this.SizeXY * z];
    }

    @Override
    double GetValueAt(int x, int y, int z) {
        return this.myData[x + this.Sizes[0] * y + this.SizeXY * z] * this.ScaleV + this.OffsetV;
    }

    @Override
    String GetValueStringAt(int x, int y, int z) {
        String ff = "%g";
        return String.format(ff, this.GetValueAt(x, y, z));
    }

    @Override
    void ConvertSliceFromSimilar(int myslice, int bufslice, Object Ibuffer, int mstep, int moff) {
        float[] mbuffer = (float[])Ibuffer;
        for (int i = 0; i < this.SizeXY; i += mstep) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice] = mbuffer[bufslice * this.SizeXY + i + moff];
        }
    }

    @Override
    void ConvertSliceFromByte(int myslice, int bufslice, byte[] Ibuffer, int mstep, int moff) {
        int SliceSize = 8 * this.SizeXY;
        for (int i = 0; i < this.SizeXY; i += mstep) {
            double fval;
            long ival = 0L;
            for (int b = 1; b < 8; ++b) {
                long val = Ibuffer[bufslice * SliceSize + 8 * (i + moff) + b] & 0xFF;
                ival |= val << 8 * b;
            }
            this.myData[i + this.SizeXY * myslice] = fval = Double.longBitsToDouble(ival);
        }
    }

    @Override
    void ConvertSliceFromRGB(int myslice, int bufslice, int[] Ibuffer, int mstep, int moff, int soff) {
        throw new IllegalArgumentException("Int: Inapplicable conversion\n");
    }

    @Override
    void CopySliceToSimilar(int myslice, Object buffer) {
        float[] mbuffer = (float[])buffer;
        for (int i = 0; i < this.SizeXY; ++i) {
            mbuffer[i] = (float)this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice];
        }
    }
}

