/*
 * Decompiled with CFR 0.152.
 */
package video2;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class WritableVirtualStack
extends ImageStack {
    private final String dir;
    private final ImageProcessor template;
    private int nSlices;
    private int highestIndex;
    private List<Integer> indices;

    public WritableVirtualStack(String dir, int w, int h) {
        this.dir = dir;
        this.open();
        if (this.nSlices != 0) {
            this.template = IJ.openImage((String)(dir + "/" + this.getFileName(1))).getProcessor();
            if (this.template.getWidth() != w && this.template.getHeight() != h) {
                throw new IllegalArgumentException("Specified image dimensions do not fit to existing images");
            }
        } else {
            this.template = new ColorProcessor(w, h);
        }
    }

    public WritableVirtualStack(String dir) {
        this.dir = dir;
        this.open();
        if (this.nSlices == 0) {
            throw new RuntimeException("Specified directory is empty, and no dimensions are specified");
        }
        this.template = IJ.openImage((String)(dir + "/" + this.getFileName(1))).getProcessor();
    }

    private void open() {
        File indexfile;
        this.highestIndex = 0;
        this.nSlices = 0;
        this.indices = new ArrayList<Integer>();
        File f = new File(this.dir);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(indexfile = new File(f, "indices")).exists()) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(indexfile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                int index = Integer.parseInt(line);
                if (index > this.highestIndex) {
                    this.highestIndex = index;
                }
                this.indices.add(index);
                ++this.nSlices;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getWidth() {
        return this.template.getWidth();
    }

    public int getHeight() {
        return this.template.getHeight();
    }

    public void saveIndicesFile() {
        File f = new File(this.dir, "indices");
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(f));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Integer i : this.indices) {
            out.println(i);
        }
        out.flush();
        out.close();
    }

    public void addSlice(String name) {
        this.addSlice(name, this.template.duplicate());
    }

    public void addSlice(String name, Object pixels) {
        ImageProcessor ip = this.template.duplicate();
        ip.setPixels(pixels);
        this.addSlice(name, ip);
    }

    public void addSlice(String name, ImageProcessor ip) {
        this.addSlice(name, ip, this.nSlices);
    }

    public void addSlice(String name, ImageProcessor ip, int n) {
        ++this.nSlices;
        ++this.highestIndex;
        this.indices.add(n, this.highestIndex);
        IJ.save((ImagePlus)new ImagePlus("", ip), (String)(this.dir + "/" + this.highestIndex + ".tif"));
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            return;
        }
        int index = this.indices.get(n - 1);
        File f = new File(this.dir, this.getFileName(n));
        this.indices.remove(n - 1);
        f.delete();
        --this.nSlices;
        if (index == this.highestIndex) {
            --this.highestIndex;
        }
    }

    public void deleteLastSlice() {
        if (this.nSlices > 0) {
            this.deleteSlice(this.nSlices);
        }
    }

    public Object getPixels(int n) {
        ImageProcessor ip = this.getProcessor(n);
        if (ip != null) {
            return ip.getPixels();
        }
        return null;
    }

    public void setPixels(Object pixels, int n) {
        ImageProcessor ip = this.getProcessor(n);
        if (ip == null) {
            return;
        }
        ip.setPixels(pixels);
        IJ.save((ImagePlus)new ImagePlus("", ip), (String)(this.dir + "/" + this.getFileName(n)));
    }

    public ImageProcessor getProcessor(int n) {
        ImagePlus imp = IJ.openImage((String)(this.dir + "/" + this.getFileName(n)));
        if (imp != null) {
            return imp.getProcessor();
        }
        return null;
    }

    public int getSize() {
        return this.nSlices;
    }

    public String getSliceLabel(int n) {
        return this.getFileName(n);
    }

    public Object[] getImageArray() {
        return null;
    }

    public void setSliceLabel(String label, int n) {
    }

    public boolean isVirtual() {
        return true;
    }

    public void trim() {
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getFileName(int n) {
        return this.indices.get(n - 1) + ".tif";
    }
}

