/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.uploaders.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.imagej.updater.util.UpdaterUserInterface;

final class SFTPOperations {
    private final Session session;
    private final ChannelSftp sftp;

    public SFTPOperations(Session session) throws JSchException {
        this.session = session;
        this.sftp = (ChannelSftp)session.openChannel("sftp");
        this.sftp.connect();
    }

    public void disconnect() throws IOException {
        int exitStatus = this.sftp.getExitStatus();
        this.sftp.disconnect();
        this.session.disconnect();
        if (exitStatus != -1) {
            throw new IOException("Command failed (see Log)!");
        }
    }

    public void put(InputStream in, String dest) throws IOException {
        this.put(in, dest, null);
    }

    public void put(InputStream in, String dest, ProgressListener listener) throws IOException {
        UpdaterUserInterface.get().debug("SFTPOperations.put(...,...," + dest + ")");
        this.mkParentDirs(dest);
        ProgressMonitor monitor = new ProgressMonitor(listener);
        try {
            this.sftp.put(in, dest, (SftpProgressMonitor)monitor);
        }
        catch (SftpException ex) {
            throw this.wrapException("Failed to upload file '" + dest + "'.", ex);
        }
    }

    public void rename(String src, String dest) throws IOException {
        this.rm(dest);
        this.mkParentDirs(dest);
        try {
            this.sftp.rename(src, dest);
        }
        catch (SftpException ex) {
            throw this.wrapException("Failed to rename remote file '" + src + "' to '" + dest + "'.", ex);
        }
    }

    public void rm(String path) throws IOException {
        if (this.fileExists(path)) {
            try {
                this.sftp.rm(path);
            }
            catch (SftpException ex) {
                throw this.wrapException("Failed to remove remote file '" + path + "'.", ex);
            }
        }
    }

    public boolean fileExists(String path) {
        UpdaterUserInterface.get().debug("SFTPOperations.fileExists2(" + path + ")");
        try {
            this.sftp.stat(path);
            return true;
        }
        catch (SftpException e) {
            return false;
        }
    }

    public void mkParentDirs(String path) throws IOException {
        UpdaterUserInterface.get().debug("SFTPOperations.mkParentDirs(" + path + ")");
        this.mkParentDirs("", path);
    }

    public long timestamp(String file) throws IOException {
        int mTime;
        try {
            SftpATTRS stats = this.sftp.stat(file);
            mTime = stats.getMTime();
        }
        catch (SftpException ex) {
            throw new IOException("Failed to extract remote timestamp from file '" + file + "'.", ex);
        }
        Date date = new Date((long)mTime * 1000L);
        return Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmss").format(date));
    }

    private void mkParentDirs(String root, String path) throws IOException {
        if (path.contains("/")) {
            int index = path.indexOf(47);
            String newRoot = root + path.substring(0, index + 1);
            String newPath = path.substring(index + 1);
            if (!"/".equals(newRoot) && !this.fileExists(newRoot)) {
                try {
                    this.sftp.mkdir(newRoot);
                }
                catch (SftpException ex) {
                    throw this.wrapException("Failed to create directory '" + newRoot + "'", ex);
                }
            }
            this.mkParentDirs(newRoot, newPath);
        }
    }

    private IOException wrapException(String message, SftpException ex) {
        String m = message + " SFTP error id=" + ex.id + ": " + ex.getMessage();
        UpdaterUserInterface.get().log(m);
        return new IOException(m);
    }

    private static class ProgressMonitor
    implements SftpProgressMonitor {
        private long count = 0L;
        private final ProgressListener listener;

        public ProgressMonitor(ProgressListener listener) {
            this.listener = listener;
        }

        public void init(int op, String src, String dest, long max) {
            this.count = 0L;
        }

        public boolean count(long chunk) {
            this.count += chunk;
            if (this.listener != null) {
                this.listener.progress(this.count);
            }
            return true;
        }

        public void end() {
        }
    }

    public static interface ProgressListener {
        public void progress(long var1);
    }
}

