/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.ImagePlus;
import landmarks.FineTuneProgressListener;
import landmarks.NamePoints;
import landmarks.NamedPointWorld;
import landmarks.ProgressWindow;
import landmarks.RegistrationResult;
import landmarks.TransformationAttempt;
import pal.math.ConjugateDirectionSearch;

public class FineTuneThread
extends Thread {
    boolean keepResults = true;
    int method;
    double cubeSide;
    ImagePlus croppedTemplate;
    ImagePlus template;
    NamedPointWorld templatePoint;
    ImagePlus newImage;
    NamedPointWorld guessedPoint;
    double[] initialTransformation;
    double[] guessedTransformation;
    ProgressWindow progressWindow;
    FineTuneProgressListener listener;
    ConjugateDirectionSearch optimizer;
    volatile boolean pleaseStop = false;

    public void setInitialTransformation(double[] initialTransformation) {
        if (initialTransformation.length != 6) {
            throw new RuntimeException("initialTransformation passed to FineTuneThread must be 6 in length");
        }
        this.initialTransformation = initialTransformation;
    }

    public FineTuneThread(int method, double cubeSide, ImagePlus croppedTemplate, ImagePlus template, NamedPointWorld templatePoint, ImagePlus newImage, NamedPointWorld guessedPoint, double[] initialTransformation, double[] guessedTransformation, ProgressWindow progressWindow, FineTuneProgressListener listener) {
        this.method = method;
        this.cubeSide = cubeSide;
        this.croppedTemplate = croppedTemplate;
        this.template = template;
        this.templatePoint = templatePoint;
        this.newImage = newImage;
        this.guessedPoint = guessedPoint;
        if (initialTransformation != null && initialTransformation.length != 6) {
            throw new RuntimeException("initialTransformation passed to FineTuneThread must be 6 in length");
        }
        this.initialTransformation = initialTransformation;
        if (guessedTransformation != null && guessedTransformation.length != 6) {
            throw new RuntimeException("guessedTransformation passed to FineTuneThread must be 6 in length, if non-null");
        }
        this.guessedTransformation = guessedTransformation;
        this.progressWindow = progressWindow;
        this.listener = listener;
    }

    @Override
    public void run() {
        double[] startValues = (double[])this.initialTransformation.clone();
        this.optimizer = new ConjugateDirectionSearch();
        this.optimizer.step = 1.0;
        this.optimizer.scbd = 10.0;
        this.optimizer.illc = true;
        TransformationAttempt attempt = new TransformationAttempt(this.cubeSide, this.croppedTemplate, this.templatePoint, this.newImage, this.guessedPoint, this.method, this.listener, this.progressWindow);
        this.optimizer.optimize(attempt, startValues, 2.0, 2.0);
        if (this.pleaseStop) {
            this.listener.fineTuneThreadFinished(2, null, this);
            return;
        }
        if (this.pleaseStop) {
            this.listener.fineTuneThreadFinished(2, null, this);
            return;
        }
        RegistrationResult r = NamePoints.mapImageWith(this.croppedTemplate, this.newImage, this.templatePoint, this.guessedPoint, startValues, this.cubeSide, this.method, "score: ");
        this.listener.fineTuneThreadFinished(1, r, this);
    }

    public void askToFinish() {
        this.pleaseStop = true;
        if (this.optimizer != null) {
            this.optimizer.interrupt = true;
        }
    }
}

