/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import vib.FloatMatrix;
import vib.InterpolatedImage;
import vib.VIB;

public class DiffusionInterpol2 {
    ImagePlus image;
    FloatMatrix[] labelTransformations;
    FloatMatrix globalTransformation;
    boolean reuse;
    boolean remember;
    float tolerance;
    static float[][] savedDisplace;
    InterpolatedImage template;
    InterpolatedImage templateLabels;
    InterpolatedImage model;
    float[][] displace;
    int level;
    float accumX;
    float accumY;
    float accumZ;
    float curX;
    float curY;
    float curZ;
    int changed;
    int bchanged;
    float mdelta;
    final float MAGIC = 40711.22f;

    public void initialize(ImagePlus image, ImagePlus templateLabels, ImagePlus model, FloatMatrix[] labelTransformations, boolean reuse, boolean remember, float tolerance) {
        this.image = image;
        this.template = new InterpolatedImage(image);
        this.templateLabels = new InterpolatedImage(templateLabels);
        this.model = new InterpolatedImage(model);
        this.labelTransformations = labelTransformations;
        this.reuse = reuse;
        this.remember = remember;
        this.tolerance = tolerance;
    }

    public void doit() {
        try {
            this.reuse = savedDisplace != null ? this.reuse : false;
            FloatMatrix fromTemplate = FloatMatrix.fromCalibration(this.template.image);
            FloatMatrix toModel = FloatMatrix.fromCalibration(this.model.image).inverse();
            for (int i = 1; i < this.labelTransformations.length; ++i) {
                if (this.labelTransformations[i] == null) continue;
                this.labelTransformations[i] = toModel.times(this.labelTransformations[i].inverse().times(fromTemplate));
            }
            this.labelTransformations[0] = null;
            this.globalTransformation = FloatMatrix.average(this.labelTransformations);
            if (this.reuse) {
                this.displace = savedDisplace;
            } else {
                if (savedDisplace != null) {
                    savedDisplace = null;
                    System.gc();
                    System.gc();
                }
                this.displace = new float[this.template.d][];
                for (int k = 0; k < this.template.d; ++k) {
                    this.displace[k] = new float[3 * this.template.w * this.template.h];
                }
                this.init();
                this.iterate(this.tolerance, false);
            }
            this.apply();
            savedDisplace = this.remember ? this.displace : (float[][])null;
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of Memory: DiffusionInterpol2 " + Macro.getOptions());
            e.printStackTrace();
            throw e;
        }
    }

    private final void accumAdd(int i, int j, int k) {
        this.accumX += this.displace[k][3 * (j * this.template.w + i) + 0];
        this.accumY += this.displace[k][3 * (j * this.template.w + i) + 1];
        this.accumZ += this.displace[k][3 * (j * this.template.w + i) + 2];
    }

    final void iterateInnerPart(int i, int j, int k) {
        if (this.templateLabels.getNoInterpol(i, j, k) != 0) {
            return;
        }
        this.accumZ = 0.0f;
        this.accumY = 0.0f;
        this.accumX = 0.0f;
        this.curX = this.displace[k][3 * (j * this.template.w + i) + 0];
        this.curY = this.displace[k][3 * (j * this.template.w + i) + 1];
        this.curZ = this.displace[k][3 * (j * this.template.w + i) + 2];
        if (k - this.level >= 0) {
            this.accumAdd(i, j, k - this.level);
        } else {
            this.accumAdd(i, j, k + this.level);
        }
        if (j - this.level >= 0) {
            this.accumAdd(i, j - this.level, k);
        } else {
            this.accumAdd(i, j + this.level, k);
        }
        if (i - this.level >= 0) {
            this.accumAdd(i - this.level, j, k);
        } else {
            this.accumAdd(i + this.level, j, k);
        }
        if (k + this.level < this.template.d) {
            this.accumAdd(i, j, k + this.level);
        } else {
            this.accumAdd(i, j, k - this.level);
        }
        if (j + this.level < this.template.h) {
            this.accumAdd(i, j + this.level, k);
        } else {
            this.accumAdd(i, j - this.level, k);
        }
        if (i + this.level < this.template.w) {
            this.accumAdd(i + this.level, j, k);
        } else {
            this.accumAdd(i - this.level, j, k);
        }
        this.accumX /= 6.0f;
        this.accumY /= 6.0f;
        this.accumZ /= 6.0f;
        float delta = Math.abs(this.curX - this.accumX) + Math.abs(this.curY - this.accumY) + Math.abs(this.curZ - this.accumZ);
        if (delta > 0.0f) {
            this.displace[k][3 * (j * this.template.w + i) + 0] = this.accumX;
            this.displace[k][3 * (j * this.template.w + i) + 1] = this.accumY;
            this.displace[k][3 * (j * this.template.w + i) + 2] = this.accumZ;
            if ((double)delta > 0.1) {
                ++this.changed;
            }
            if (delta > 3.0f) {
                ++this.changed;
            }
            if (delta > this.mdelta) {
                this.mdelta = delta;
            }
        }
    }

    float iterateNormal() {
        int i;
        int j;
        int maxD;
        int k;
        this.bchanged = 0;
        this.changed = 0;
        this.mdelta = 0.0f;
        int maxW = this.template.w - 1 - (this.template.w - 1) % this.level;
        int maxH = this.template.h - 1 - (this.template.h - 1) % this.level;
        for (k = maxD = this.template.d - 1 - (this.template.d - 1) % this.level; k >= 0; k -= this.level) {
            for (j = maxH; j >= 0; j -= this.level) {
                for (i = maxW; i >= 0; i -= this.level) {
                    this.iterateInnerPart(i, j, k);
                }
            }
            IJ.showProgress((int)(1 * this.template.d - k), (int)(2 * this.template.d));
        }
        for (k = 0; k < this.template.d; k += this.level) {
            for (j = 0; j < this.template.h; j += this.level) {
                for (i = 0; i < this.template.w; i += this.level) {
                    this.iterateInnerPart(i, j, k);
                }
            }
            IJ.showProgress((int)(this.template.d + k + 1), (int)(this.template.d * 2));
        }
        IJ.showProgress((int)1, (int)1);
        return this.mdelta;
    }

    void propagateInitial() {
        int i;
        int j;
        int k;
        VIB.showStatus("initializing domain (1/2)");
        for (k = 0; k < this.template.d; ++k) {
            IJ.showProgress((int)k, (int)(this.template.d * 2));
            for (j = 0; j < this.template.h; ++j) {
                for (i = 0; i < this.template.w; ++i) {
                    if (this.displace[k][3 * (j * this.template.w + i)] != 40711.22f) continue;
                    if (k > 0 && this.displace[k - 1][3 * (j * this.template.w + i)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i, j, k - 1);
                        continue;
                    }
                    if (j > 0 && this.displace[k][3 * ((j - 1) * this.template.w + i)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i, j - 1, k);
                        continue;
                    }
                    if (i > 0 && this.displace[k][3 * (j * this.template.w + i - 1)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i - 1, j, k);
                        continue;
                    }
                    if (i > 0 && j > 0 && this.displace[k][3 * ((j - 1) * this.template.w + i - 1)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i - 1, j - 1, k);
                        continue;
                    }
                    if (i > 0 && k > 0 && this.displace[k - 1][3 * (j * this.template.w + i - 1)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i - 1, j, k - 1);
                        continue;
                    }
                    if (j > 0 && k > 0 && this.displace[k - 1][3 * ((j - 1) * this.template.w + i)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i, j - 1, k - 1);
                        continue;
                    }
                    if (i <= 0 || j <= 0 || k <= 0 || this.displace[k - 1][3 * ((j - 1) * this.template.w + i - 1)] == 40711.22f) continue;
                    this.copyDisplace(i, j, k, i - 1, j - 1, k - 1);
                }
            }
        }
        VIB.showStatus("initializing domain (2/2)");
        for (k = this.template.d - 1; k >= 0; --k) {
            IJ.showProgress((int)(2 * this.template.d - k), (int)(2 * this.template.d));
            for (j = this.template.h - 1; j >= 0; --j) {
                for (i = this.template.w - 1; i >= 0; --i) {
                    if (this.displace[k][3 * (j * this.template.w + i)] != 40711.22f) continue;
                    if (k < this.template.d - 1 && this.displace[k + 1][3 * (j * this.template.w + i)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i, j, k + 1);
                        continue;
                    }
                    if (j < this.template.h - 1 && this.displace[k][3 * ((j + 1) * this.template.w + i)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i, j + 1, k);
                        continue;
                    }
                    if (i < this.template.w - 1 && this.displace[k][3 * (j * this.template.w + i + 1)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i + 1, j, k);
                        continue;
                    }
                    if (i < this.template.w - 1 && j < this.template.h - 1 && this.displace[k][3 * ((j + 1) * this.template.w + i + 1)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i + 1, j + 1, k);
                        continue;
                    }
                    if (i < this.template.w - 1 && k < this.template.d - 1 && this.displace[k + 1][3 * (j * this.template.w + i + 1)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i + 1, j, k + 1);
                        continue;
                    }
                    if (k < this.template.d - 1 && j < this.template.h - 1 && this.displace[k + 1][3 * ((j + 1) * this.template.w + i)] != 40711.22f) {
                        this.copyDisplace(i, j, k, i, j + 1, k + 1);
                        continue;
                    }
                    if (i >= this.template.w - 1 || j >= this.template.h - 1 || k >= this.template.d - 1 || this.displace[k + 1][3 * ((j + 1) * this.template.w + i + 1)] == 40711.22f) continue;
                    this.copyDisplace(i, j, k, i + 1, j + 1, k + 1);
                }
            }
        }
        IJ.showProgress((int)1, (int)1);
        for (k = 0; k < this.template.d; ++k) {
            for (j = 0; j < this.template.h; ++j) {
                for (i = 0; i < this.template.w; ++i) {
                    if (this.displace[k][3 * (j * this.template.w + i)] != 40711.22f) continue;
                    throw new RuntimeException("Nonono: " + i + ", " + j + ", " + k);
                }
            }
        }
    }

    void copyDisplace(int di, int dj, int dk, int i, int j, int k) {
        this.displace[dk][3 * (dj * this.template.w + di) + 0] = this.displace[k][3 * (j * this.template.w + i) + 0];
        this.displace[dk][3 * (dj * this.template.w + di) + 1] = this.displace[k][3 * (j * this.template.w + i) + 1];
        this.displace[dk][3 * (dj * this.template.w + di) + 2] = this.displace[k][3 * (j * this.template.w + i) + 2];
    }

    void iterate(float tolerance, boolean fine) {
        VIB.showStatus("diffusion in progress");
        int n = this.level = fine ? 1 : 16;
        while (this.level >= 1) {
            int i = 1;
            while (true) {
                float tol = tolerance / (float)this.level;
                VIB.showStatus("Level " + this.level + ", Iteration " + i + " (delta was " + this.mdelta + ")");
                if (this.iterateNormal() < tol) break;
                ++i;
            }
            if (this.level > 1) {
                VIB.showStatus("Level jump " + this.level + " -> " + this.level / 2);
                for (int k = 0; k < this.template.d; k += this.level) {
                    for (int j = 0; j < this.template.h; j += this.level) {
                        for (int i2 = 0; i2 < this.template.w; i2 += this.level) {
                            int kMax = k + this.level >= this.template.d ? this.template.d : k + this.level;
                            int jMax = j + this.level >= this.template.h ? this.template.h : j + this.level;
                            int iMax = i2 + this.level >= this.template.w ? this.template.w : i2 + this.level;
                            for (int dk = k; dk < kMax; ++dk) {
                                for (int dj = j; dj < jMax; ++dj) {
                                    for (int di = i2; di < iMax; ++di) {
                                        if (this.templateLabels.getNoInterpol(di, dj, dk) != 0) continue;
                                        this.copyDisplace(di, dj, dk, i2, j, k);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.level /= 2;
        }
    }

    void apply() {
        VIB.showStatus("Applying displacement");
        for (int k = 0; k < this.template.d; ++k) {
            for (int j = 0; j < this.template.h; ++j) {
                for (int i = 0; i < this.template.w; ++i) {
                    this.globalTransformation.apply(i, j, k);
                    this.template.set(i, j, k, (byte)this.model.interpol.get(this.displace[k][3 * (j * this.template.w + i) + 0] + this.globalTransformation.x, this.displace[k][3 * (j * this.template.w + i) + 1] + this.globalTransformation.y, this.displace[k][3 * (j * this.template.w + i) + 2] + this.globalTransformation.z));
                }
            }
            IJ.showProgress((int)(k + 1), (int)this.template.d);
        }
        new AmiraParameters(this.model.image).setParameters(this.template.image, false);
    }

    void init() {
        VIB.showStatus("Initializing displacement");
        for (int k = 0; k < this.template.d; ++k) {
            IJ.showProgress((int)k, (int)this.template.d);
            for (int j = 0; j < this.template.h; ++j) {
                for (int i = 0; i < this.template.w; ++i) {
                    int material = this.templateLabels.getNoInterpol(i, j, k);
                    if (material > 0 && material < this.labelTransformations.length && this.labelTransformations[material] != null) {
                        this.labelTransformations[material].apply(i, j, k);
                        this.globalTransformation.apply(i, j, k);
                        this.displace[k][3 * (j * this.template.w + i) + 0] = this.labelTransformations[material].x - this.globalTransformation.x;
                        this.displace[k][3 * (j * this.template.w + i) + 1] = this.labelTransformations[material].y - this.globalTransformation.y;
                        this.displace[k][3 * (j * this.template.w + i) + 2] = this.labelTransformations[material].z - this.globalTransformation.z;
                        continue;
                    }
                    this.displace[k][3 * (j * this.template.w + i) + 0] = 0.0f;
                    this.displace[k][3 * (j * this.template.w + i) + 1] = 0.0f;
                    this.displace[k][3 * (j * this.template.w + i) + 2] = 0.0f;
                }
            }
        }
        IJ.showProgress((int)1, (int)1);
        this.propagateInitial();
    }

    public ImagePlus[] getDisplacementField() {
        int i;
        ImagePlus[] results = new ImagePlus[3];
        ImageStack[] stack = new ImageStack[3];
        for (i = 0; i < 3; ++i) {
            stack[i] = new ImageStack(this.template.w, this.template.h);
        }
        for (int k = 0; k < this.template.d; ++k) {
            int i2;
            float[][] slice = new float[3][];
            for (i2 = 0; i2 < 3; ++i2) {
                slice[i2] = new float[this.template.w * this.template.h];
            }
            for (int j = 0; j < this.template.w * this.template.h; ++j) {
                for (int i3 = 0; i3 < 3; ++i3) {
                    slice[i3][j] = this.displace[k][3 * j + i3];
                }
            }
            for (i2 = 0; i2 < 3; ++i2) {
                stack[i2].addSlice("", (Object)slice[i2]);
            }
        }
        for (i = 0; i < 3; ++i) {
            results[i] = new ImagePlus("displace " + i, stack[i]);
        }
        return results;
    }

    private void debugDisplace() {
        ImagePlus[] xyz = this.getDisplacementField();
        for (int i = 0; i < 3; ++i) {
            xyz[i].show();
        }
        throw new RuntimeException("debugDisplace");
    }
}

