/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import amira.AmiraParameters;
import ij.ImagePlus;
import ij.measure.Calibration;
import vib.InterpolatedImage;
import vib.app.ImageMetaData;
import vib.app.module.Module;
import vib.app.module.ResampleLabels;
import vib.app.module.State;

public class TissueStatistics
extends Module {
    @Override
    public String getName() {
        return "TissueStatistics";
    }

    @Override
    protected String getMessage() {
        return "Calculating tissue statistics";
    }

    @Override
    protected void run(State state, int index) {
        new ResampleLabels().runOnOneImage(state, index);
        this.prereqsDone(state, index);
        String statisticsPath = state.getStatisticsPath(index);
        String labelsPath = state.getImagePath(-1, index);
        if (State.upToDate(labelsPath, statisticsPath)) {
            return;
        }
        ImagePlus labelField = state.getImage(labelsPath);
        Statistics stats = TissueStatistics.getStatistics(labelField);
        ImageMetaData metaData = new ImageMetaData();
        for (int i = 0; i < stats.materials.length; ++i) {
            metaData.setMaterial(stats.materials[i], (int)stats.count[i], (double)stats.count[i] * stats.voxelVolume(), stats.centerX(i), stats.centerY(i), stats.centerZ(i));
        }
        if (!metaData.saveTo(statisticsPath)) {
            throw new RuntimeException("Could not save " + statisticsPath);
        }
    }

    public static Statistics getStatistics(ImagePlus labelfield) {
        InterpolatedImage ii = new InterpolatedImage(labelfield);
        return new Statistics(ii);
    }

    public static class Statistics {
        Calibration cal;
        AmiraParameters parameters;
        public String[] materials;
        public long[] count;
        public long[] cX;
        public long[] cY;
        public long[] cZ;
        public int[] minX;
        public int[] maxX;
        public int[] minY;
        public int[] maxY;
        public int[] minZ;
        public int[] maxZ;

        public Statistics(InterpolatedImage ii) {
            this.cal = ii.image.getCalibration();
            this.parameters = new AmiraParameters(ii.image);
            this.materials = this.parameters.getMaterialList();
            this.count = new long[this.materials.length];
            this.cX = new long[this.materials.length];
            this.cY = new long[this.materials.length];
            this.cZ = new long[this.materials.length];
            this.minX = new int[this.materials.length];
            this.maxX = new int[this.materials.length];
            this.minY = new int[this.materials.length];
            this.maxY = new int[this.materials.length];
            this.minZ = new int[this.materials.length];
            this.maxZ = new int[this.materials.length];
            for (int i = 0; i < this.materials.length; ++i) {
                this.minZ[i] = Integer.MAX_VALUE;
                this.minY[i] = Integer.MAX_VALUE;
                this.minX[i] = Integer.MAX_VALUE;
            }
            this.doit(ii);
        }

        public void doit(InterpolatedImage ii) {
            InterpolatedImage.Iterator iter = ii.iterator(true);
            while (iter.next() != null) {
                int v;
                int n = v = ii.getNoInterpol(iter.i, iter.j, iter.k);
                this.count[n] = this.count[n] + 1L;
                int n2 = v;
                this.cX[n2] = this.cX[n2] + (long)iter.i;
                int n3 = v;
                this.cY[n3] = this.cY[n3] + (long)iter.j;
                int n4 = v;
                this.cZ[n4] = this.cZ[n4] + (long)iter.k;
                if (this.minX[v] > iter.i) {
                    this.minX[v] = iter.i;
                } else if (this.maxX[v] < iter.i) {
                    this.maxX[v] = iter.i;
                }
                if (this.minY[v] > iter.j) {
                    this.minY[v] = iter.j;
                } else if (this.maxY[v] < iter.j) {
                    this.maxY[v] = iter.j;
                }
                if (this.minZ[v] > iter.k) {
                    this.minZ[v] = iter.k;
                    continue;
                }
                if (this.maxZ[v] >= iter.k) continue;
                this.maxZ[v] = iter.k;
            }
        }

        public double x(double i) {
            return this.cal.xOrigin + (i + 0.5) * this.cal.pixelWidth;
        }

        public double y(double j) {
            return this.cal.yOrigin + (j + 0.5) * this.cal.pixelHeight;
        }

        public double z(double k) {
            return this.cal.yOrigin + (k + 0.5) * this.cal.pixelDepth;
        }

        public double voxelVolume() {
            return this.cal.pixelWidth * this.cal.pixelHeight * this.cal.pixelDepth;
        }

        public double centerX(int index) {
            return this.x((double)this.cX[index] / (double)this.count[index]);
        }

        public double centerY(int index) {
            return this.y((double)this.cY[index] / (double)this.count[index]);
        }

        public double centerZ(int index) {
            return this.z((double)this.cZ[index] / (double)this.count[index]);
        }

        public String getResult() {
            double voxelVolume = this.voxelVolume();
            String result = "";
            for (int i = 0; i < this.materials.length; ++i) {
                result = result + (i + 1) + "\t";
                result = result + this.materials[i] + "\t";
                result = result + this.count[i] + "\t";
                if (this.count[i] == 0L) {
                    result = result + "0\t0\t0\t0\t0\t0\t0\t0\t0\t0\n";
                    continue;
                }
                result = result + (double)this.count[i] * voxelVolume + "\t";
                result = result + this.centerX(i) + "\t";
                result = result + this.centerY(i) + "\t";
                result = result + this.centerZ(i) + "\t";
                result = result + this.x(this.minX[i]) + "\t";
                result = result + this.x(this.maxX[i]) + "\t";
                result = result + this.y(this.minY[i]) + "\t";
                result = result + this.y(this.maxY[i]) + "\t";
                result = result + this.z(this.minZ[i]) + "\t";
                result = result + this.z(this.maxZ[i]) + "\n";
            }
            return result;
        }
    }
}

