/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.opencv;

import net.imagej.opencv.ImgToMatConverter;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.MatVector;
import org.scijava.Prioritized;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.log.LogService;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=-100.0)
public class ImgToMatVectorConverter
extends AbstractConverter<RandomAccessibleInterval, MatVector> {
    public int compareTo(Prioritized o) {
        return super.compareTo(o);
    }

    public LogService log() {
        return super.log();
    }

    public String getIdentifier() {
        return super.getIdentifier();
    }

    public <T> T convert(Object o, Class<T> type) {
        RandomAccessibleInterval img = (RandomAccessibleInterval)o;
        int[] dims = Intervals.dimensionsAsIntArray((Dimensions)img);
        if (dims.length < 3) {
            throw new IllegalArgumentException("Images with less than 3 dimensions are not supported here, use ImgToMatConverter");
        }
        MatVector matVector = new MatVector((long)dims[2]);
        ImgToMatConverter converter = new ImgToMatConverter();
        for (int i = 0; i < dims[2]; ++i) {
            IntervalView ijSlice = Views.hyperSlice((RandomAccessibleInterval)img, (int)(dims.length - 1), (long)i);
            Mat mSlice = converter.convert(ijSlice, Mat.class);
            matVector.put((long)i, mSlice);
        }
        return (T)matVector;
    }

    public Class<MatVector> getOutputType() {
        return MatVector.class;
    }

    public Class<RandomAccessibleInterval> getInputType() {
        return RandomAccessibleInterval.class;
    }
}

