/*
 * Decompiled with CFR 0.152.
 */
import ij.process.ColorProcessor;
import java.awt.Rectangle;

class ColorStats {
    int[][] histogram = new int[3][256];
    double[] hmean = new double[3];
    double[] hmin = new double[3];
    double[] hmax = new double[3];
    int[] hmode = new int[3];
    int[] hmodecnt = new int[3];
    double[] hstdev = new double[3];
    int histcount = 0;
    public static final int WHITE = 255;

    public ColorStats(ColorProcessor cp, Rectangle rect) {
        int[] pixels = (int[])cp.getPixels();
        int width = cp.getWidth();
        this.histogram = this.getHistogram(width, pixels, rect);
        this.calculateStatistics(this.histogram);
    }

    public ColorStats(ColorProcessor cp, byte[] mask, Rectangle rect) {
        int[] pixels = (int[])cp.getPixels();
        int width = cp.getWidth();
        this.histogram = this.getHistogram(width, pixels, mask, rect);
        this.calculateStatistics(this.histogram);
    }

    public int[][] getHistogram(int width, int[] pixels, Rectangle roi) {
        int roiY = roi.y;
        int roiX = roi.x;
        int roiWidth = roi.width;
        int roiHeight = roi.height;
        this.histcount = roi.width * roi.height;
        int[][] histogram = new int[3][256];
        for (int y = roiY; y < roiY + roiHeight; ++y) {
            int i = y * width + roiX;
            for (int x = 0; x < roiWidth; ++x) {
                int c = pixels[i];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                int[] nArray = histogram[0];
                int n = r;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = histogram[1];
                int n2 = g;
                nArray2[n2] = nArray2[n2] + 1;
                int[] nArray3 = histogram[2];
                int n3 = b;
                nArray3[n3] = nArray3[n3] + 1;
                ++i;
            }
        }
        return histogram;
    }

    public int[][] getHistogram(int width, int[] pixels, byte[] mask, Rectangle roi) {
        int[][] histogram = new int[3][256];
        int roiY = roi.y;
        int roiX = roi.x;
        int roiWidth = roi.width;
        int roiHeight = roi.height;
        int v = 0;
        int y = roiY;
        int my = 0;
        while (y < roiY + roiHeight) {
            int i = y * width + roiX;
            int mi = my * roiWidth;
            int x = roiX;
            int mx = 0;
            while (x < roiX + roiWidth) {
                int cnt = mi + mx;
                if ((mask[cnt] & 0xFF) == 255) {
                    int c = pixels[i];
                    int r = (c & 0xFF0000) >> 16;
                    int g = (c & 0xFF00) >> 8;
                    int b = c & 0xFF;
                    int[] nArray = histogram[0];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = histogram[1];
                    int n2 = g;
                    nArray2[n2] = nArray2[n2] + 1;
                    int[] nArray3 = histogram[2];
                    int n3 = b;
                    nArray3[n3] = nArray3[n3] + 1;
                    ++v;
                }
                ++i;
                ++x;
                ++mx;
            }
            ++y;
            ++my;
        }
        this.histcount = v;
        return histogram;
    }

    public int getHistcount() {
        return this.histcount;
    }

    public int[][] getHistogram() {
        return this.histogram;
    }

    public double[] getMean() {
        return this.hmean;
    }

    public int[] getMode() {
        return this.hmode;
    }

    public int[] getModeCnt() {
        return this.hmodecnt;
    }

    public double[] getStdev() {
        return this.hstdev;
    }

    protected void calculateStatistics(int[][] histogram) {
        double[] h2 = new double[256];
        for (int col = 0; col < 3; ++col) {
            int max;
            int min;
            int[][] tmp = this.getMinMax(histogram[col]);
            this.hmode[col] = tmp[1][0];
            this.hmodecnt[col] = tmp[1][1];
            for (min = 0; histogram[col][min] == 0 && min < 256; ++min) {
            }
            this.hmin[col] = min;
            for (max = 255; histogram[col][max] == 0 && max > 0; --max) {
            }
            this.hmax[col] = max;
            double sum = 0.0;
            double sum2 = 0.0;
            for (int i = 0; i < 256; ++i) {
                sum += (double)(i * histogram[col][i]);
                sum2 += (double)(i * i * histogram[col][i]);
            }
            this.hmean[col] = sum / (double)this.histcount;
            double histVar = (sum2 - sum * sum / (double)this.histcount) / ((double)this.histcount - 1.0);
            this.hstdev[col] = Math.sqrt(histVar);
        }
    }

    public int[][] getMinMax(int[] a) {
        int min = a[0];
        int max = a[0];
        int cntmin = -1;
        int cntmax = -1;
        for (int i = 0; i < a.length; ++i) {
            int value = a[i];
            if (value <= min) {
                min = value;
                cntmin = i;
            }
            if (value < max) continue;
            max = value;
            cntmax = i;
        }
        int[][] minAndMax = new int[2][2];
        minAndMax[0][0] = min;
        minAndMax[1][0] = max;
        minAndMax[0][1] = cntmin;
        minAndMax[1][1] = cntmax;
        return minAndMax;
    }

    public double[] getMax() {
        return this.hmax;
    }

    public double[] getMin() {
        return this.hmin;
    }
}

