/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.awt.Image;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PDF_Writer
implements PlugIn {
    static String PREF_KEY = "PDF_Writer.";
    static boolean canUsePrefs = false;
    static boolean showName = true;
    static boolean showSize = true;
    static boolean scaleToFit = true;
    static boolean saveAllImages = false;
    static boolean includeAllSlices = false;
    static boolean singleImage = false;
    static boolean isLetter = true;
    int spcNm = 0;
    int spcSz = 0;
    boolean isFirst;
    PdfWriter writer;
    Document document;
    Paragraph paragraph;
    com.itextpdf.text.Image image;

    public PDF_Writer() {
        try {
            Class<?> ImageJClass = Class.forName("ij.ImageJ");
            String vers = (String)ImageJClass.getField("VERSION").get(null);
            canUsePrefs = vers.compareTo("1.32c") >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (canUsePrefs) {
            showName = Prefs.get((String)(PREF_KEY + "showName"), (boolean)true);
            showSize = Prefs.get((String)(PREF_KEY + "showSize"), (boolean)true);
            scaleToFit = Prefs.get((String)(PREF_KEY + "scaleToFit"), (boolean)true);
            saveAllImages = Prefs.get((String)(PREF_KEY + "saveAllImages"), (boolean)false);
            includeAllSlices = Prefs.get((String)(PREF_KEY + "includeAllSlices"), (boolean)false);
            singleImage = Prefs.get((String)(PREF_KEY + "singleImage"), (boolean)false);
            isLetter = Prefs.get((String)(PREF_KEY + "isLetter"), (boolean)true);
        }
    }

    protected void addImage(Image awtImage, String printName) throws DocumentException, IOException {
        if (!this.isFirst) {
            if (singleImage) {
                this.document.newPage();
            } else {
                this.document.add((Element)new Paragraph("\n"));
                float vertPos = this.writer.getVerticalPosition(true);
                PdfContentByte cb = this.writer.getDirectContent();
                cb.setLineWidth(1.0f);
                if (isLetter) {
                    cb.moveTo(PageSize.LETTER.getLeft(50.0f), vertPos);
                    cb.lineTo(PageSize.LETTER.getRight(50.0f), vertPos);
                } else {
                    cb.moveTo(PageSize.A4.getLeft(50.0f), vertPos);
                    cb.lineTo(PageSize.A4.getRight(50.0f), vertPos);
                }
                cb.stroke();
            }
        }
        if (showName) {
            this.paragraph = new Paragraph(printName);
            this.paragraph.setAlignment(1);
            this.document.add((Element)this.paragraph);
        }
        if (showSize) {
            this.paragraph = new Paragraph(awtImage.getWidth(null) + " x " + awtImage.getHeight(null));
            this.paragraph.setAlignment(1);
            this.document.add((Element)this.paragraph);
        }
        if (singleImage) {
            if (showName) {
                this.spcNm = 40;
            }
            if (showSize) {
                this.spcSz = 40;
            }
        }
        this.image = com.itextpdf.text.Image.getInstance((Image)awtImage, null);
        if (scaleToFit) {
            if (isLetter) {
                this.image.scaleToFit(PageSize.LETTER.getRight((float)(50 + this.spcNm + this.spcSz)), PageSize.LETTER.getTop((float)(50 + this.spcNm + this.spcSz)));
            } else {
                this.image.scaleToFit(PageSize.A4.getRight((float)(50 + this.spcNm + this.spcSz)), PageSize.A4.getTop((float)(50 + this.spcNm + this.spcSz)));
            }
        }
        this.image.setAlignment(1);
        this.document.add((Element)this.image);
        this.isFirst = false;
    }

    public void run(String arg) {
        ImagePlus image = WindowManager.getCurrentImage();
        if (image == null) {
            IJ.showStatus((String)"No image is open");
            return;
        }
        GenericDialog gd = new GenericDialog("PDF Writer");
        gd.addCheckbox("Show image name", showName);
        gd.addCheckbox("Show image size", showSize);
        gd.addCheckbox("Scale to fit", scaleToFit);
        gd.addCheckbox("Save all images", saveAllImages);
        gd.addCheckbox("Include all slices", includeAllSlices);
        gd.addCheckbox("One image per page", singleImage);
        gd.addCheckbox("US Letter", isLetter);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        showName = gd.getNextBoolean();
        showSize = gd.getNextBoolean();
        scaleToFit = gd.getNextBoolean();
        saveAllImages = gd.getNextBoolean();
        includeAllSlices = gd.getNextBoolean();
        singleImage = gd.getNextBoolean();
        isLetter = gd.getNextBoolean();
        if (canUsePrefs) {
            Prefs.set((String)(PREF_KEY + "showName"), (boolean)showName);
            Prefs.set((String)(PREF_KEY + "showSize"), (boolean)showSize);
            Prefs.set((String)(PREF_KEY + "scaleToFit"), (boolean)scaleToFit);
            Prefs.set((String)(PREF_KEY + "saveAllImages"), (boolean)saveAllImages);
            Prefs.set((String)(PREF_KEY + "includeAllSlices"), (boolean)includeAllSlices);
            Prefs.set((String)(PREF_KEY + "singleImage"), (boolean)singleImage);
            Prefs.set((String)(PREF_KEY + "isLetter"), (boolean)isLetter);
        }
        String name = IJ.getImage().getTitle();
        SaveDialog sd = new SaveDialog("Save as PDF", name, ".pdf");
        name = sd.getFileName();
        String directory = sd.getDirectory();
        String path = directory + name;
        this.document = new Document(isLetter ? PageSize.LETTER : PageSize.A4);
        this.document.addCreationDate();
        this.document.addTitle(name);
        try {
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(path));
            this.document.open();
            for (int idx = 1; idx <= WindowManager.getWindowCount(); ++idx) {
                String printName;
                if (saveAllImages) {
                    image = WindowManager.getImage((int)idx);
                    printName = WindowManager.getImage((int)idx).getTitle();
                } else {
                    printName = name;
                }
                if (includeAllSlices) {
                    ImageStack stack = image.getStack();
                    int total = stack.getSize();
                    for (int i = 1; i <= total; ++i) {
                        this.addImage(stack.getProcessor(i).createImage(), printName + " (" + i + "/" + total + ")");
                    }
                } else {
                    this.addImage(image.getImage(), printName);
                }
                if (saveAllImages) {
                    continue;
                }
                break;
            }
        }
        catch (DocumentException de) {
            IJ.showMessage((String)"PDF Writer", (String)de.getMessage());
        }
        catch (IOException ioe) {
            IJ.showMessage((String)"PDF Writer", (String)ioe.getMessage());
        }
        this.document.close();
        IJ.showStatus((String)"");
    }
}

