/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.utility.arrays;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class ArraySortedIndices {
    public static int[] sort(double[] input) {
        int[] indices = new int[input.length];
        TreeMap<Double, Integer> tm = ArraySortedIndices.sortedKeysAndValues(input);
        int index = 0;
        for (Integer v : tm.values()) {
            indices[index] = v;
            ++index;
        }
        return indices;
    }

    public static int[] sortForward(double[] input) {
        int[] arr = ArraySortedIndices.sort(input);
        int[] res = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[arr[i]] = i;
        }
        return res;
    }

    public static void sort(double[] input, int[] forward, int[] backward) {
        TreeMap<Double, Integer> tm = ArraySortedIndices.sortedKeysAndValues(input);
        int index = 0;
        for (Map.Entry<Double, Integer> entry : tm.entrySet()) {
            backward[index] = entry.getValue();
            forward[backward[index]] = index;
            input[index] = entry.getKey();
            ++index;
        }
    }

    public static int[] getSortedIndicesFromMap(TreeMap<Double, Integer> tm) {
        int[] result = new int[tm.size()];
        int index = 0;
        for (Integer v : tm.values()) {
            result[index++] = v;
        }
        return result;
    }

    public static double[] getSortedArrayFromMap(TreeMap<Double, Integer> tm) {
        double[] result = new double[tm.size()];
        int index = 0;
        for (Double v : tm.keySet()) {
            result[index++] = v;
        }
        return result;
    }

    public static TreeMap<Double, Integer> sortedKeysAndValues(double[] input) {
        TreeMap<Double, Integer> tm = new TreeMap<Double, Integer>();
        for (int i = 0; i < input.length; ++i) {
            tm.put(input[i], i);
        }
        return tm;
    }

    public static void main(String[] args) {
        double[] a = new double[]{1.0, 2.0, 3.0, 4.0, 2.5};
        double[] c = (double[])a.clone();
        int[] indices = ArraySortedIndices.sort(a);
        System.out.println(Arrays.toString(indices));
        TreeMap<Double, Integer> tm = ArraySortedIndices.sortedKeysAndValues(a);
        System.out.println(Arrays.toString(ArraySortedIndices.getSortedIndicesFromMap(tm)));
        System.out.println(Arrays.toString(ArraySortedIndices.getSortedArrayFromMap(tm)));
        double[] b = (double[])a.clone();
        for (int i = 0; i < b.length; ++i) {
            b[indices[i]] = a[i];
        }
        System.out.println(Arrays.toString(b));
        int[] fwd = new int[c.length];
        int[] bck = new int[c.length];
        ArraySortedIndices.sort(c, fwd, bck);
        System.out.println();
        System.out.println(Arrays.toString(a));
        System.out.println(Arrays.toString(c));
        System.out.println(Arrays.toString(fwd));
        System.out.println(Arrays.toString(bck));
    }
}

