/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars;

import groovyx.gpars.GParsExecutorsPool;
import groovyx.gpars.GParsPool;
import groovyx.gpars.scheduler.Pool;
import groovyx.gpars.scheduler.ResizeablePool;
import groovyx.gpars.scheduler.Timer;
import groovyx.gpars.util.GeneralTimer;
import groovyx.gpars.util.PoolFactory;
import groovyx.gpars.util.TimerFactory;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public final class GParsConfig {
    private static volatile PoolFactory poolFactory;
    private static volatile TimerFactory timerFactory;
    private static volatile boolean poolFactoryFlag;
    private static volatile boolean timerFactoryFlag;
    private static final Collection<GeneralTimer> timers;

    public static synchronized void setPoolFactory(PoolFactory pool) {
        if (poolFactoryFlag) {
            throw new IllegalArgumentException("The pool factory cannot be altered at this stage. It has already been set before.");
        }
        poolFactoryFlag = true;
        poolFactory = pool;
    }

    public static PoolFactory getPoolFactory() {
        return poolFactory;
    }

    public static Pool retrieveDefaultPool() {
        if (poolFactory != null) {
            return poolFactory.createPool();
        }
        return new ResizeablePool(true, 1);
    }

    public static synchronized void setTimerFactory(TimerFactory timerFactory) {
        if (timerFactoryFlag) {
            throw new IllegalArgumentException("The timer factory cannot be altered at this stage. It has already been set before.");
        }
        timerFactoryFlag = true;
        GParsConfig.timerFactory = timerFactory;
    }

    public static TimerFactory getTimerFactory() {
        return timerFactory;
    }

    public static GeneralTimer retrieveDefaultTimer(String name, boolean daemon) {
        GeneralTimer timer = timerFactory != null ? timerFactory.createTimer(name, daemon) : new GeneralTimer(){

            @Override
            public void schedule(Runnable task, long timeout) {
                Timer.timer.schedule(task, timeout, TimeUnit.MILLISECONDS);
            }

            @Override
            public void shutdown() {
                Timer.timer.shutdown();
            }
        };
        if (!timers.contains(timer)) {
            timers.add(timer);
        }
        return timer;
    }

    public static void shutdown() {
        for (GeneralTimer timer : timers) {
            timer.shutdown();
        }
        GParsPool.shutdown();
        GParsExecutorsPool.shutdown();
    }

    static {
        poolFactoryFlag = false;
        timerFactoryFlag = false;
        timers = new CopyOnWriteArrayList<GeneralTimer>();
    }
}

