/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.FlowJCanvas;
import FlowJ.FlowJDisplay;
import FlowJ.FlowJDynamicColor;
import FlowJ.FlowJError;
import FlowJ.FlowJException;
import FlowJ.FlowJFleet;
import FlowJ.FlowJFlow;
import FlowJ.FlowJLucas;
import FlowJ.FlowJSingh;
import FlowJ.FlowJUras;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Vector;

public class FlowJUserInterface
extends ImagePlus
implements ActionListener,
ClipboardOwner {
    private static String version = "1.29";
    private Button save;
    private Button copy;
    private Button error;
    private Button read;
    private Button rotate;
    private Button display;
    private Button centralImage;
    private Button graph;
    private Button compute;
    private Button computeAll;
    private Button trans;
    private Button indexButton;
    private Label rLabel;
    private Label sLabel;
    private Label alphaField;
    private Label posLabel;
    private Choice gradientChoice;
    private Choice regularizationChoice;
    private Choice algorithmChoice;
    private Choice mappingChoice;
    private TextField rhoField;
    private TextField tauField;
    private TextField sigmasField;
    private TextField regionField;
    private TextField sigmatField;
    private TextField frameField;
    private TextField xField;
    private TextField yField;
    private TextField recursionsLabel;
    private TextField lambdaField;
    private TextField kField;
    private TextField sigmawField;
    private TextField resLabel;
    private TextField condField;
    private TextField sigmafField;
    private TextField maxampField;
    private TextField taufField;
    private TextField taus1Field;
    private TextField taus2Field;
    private TextField scaleField;
    private Checkbox staticCheckbox;
    private Checkbox normalsCheckbox;
    private static String defaultDirectory = null;
    private float rho;
    private float tau;
    private float sigmas;
    private float sigmat;
    private int region;
    private int xError;
    private int yError;
    private int frame;
    private FlowJFlow trueFlow;
    private FlowJFlow flow;
    private Vector flows;
    private FlowJError flowError;
    private ImagePlus imp;
    private String description = "";
    private boolean firstTime;
    private boolean hasVolume;
    private static final int LK = 0;
    private static final int URAS = 1;
    private static final int SINGH = 2;
    private static final int FLEET = 3;

    public FlowJUserInterface() {
        this.discoverEnvironment();
    }

    protected void discoverEnvironment() {
        if (!this.firstTime) {
            this.firstTime = true;
            this.imp = WindowManager.getCurrentImage();
            int width = 100;
            int height = 100;
            if (this.imp instanceof ImagePlus && this.imp.getStackSize() > 1) {
                this.imp = this.imp;
                this.hasVolume = true;
                this.imp.setSlice(this.imp.getStackSize() / 2);
                ImageStack stack = this.imp.getStack();
                width = stack.getWidth();
                height = stack.getHeight();
            }
            ColorProcessor cp = new ColorProcessor(width, height, new int[width * height]);
            cp.setColor(new Color(0xFFFFFF));
            cp.fill();
            this.setProcessor("2D Optical flow", (ImageProcessor)cp);
            this.show();
        }
    }

    public void show() {
        this.setTitle("FlowJ " + version + " ");
        this.img = this.ip.createImage();
        this.win = new ImageWindow((ImagePlus)this, (ImageCanvas)new FlowJCanvas(this));
        this.win.setLayout((LayoutManager)new FlowLayout());
        Panel buttons = new Panel();
        buttons.setLayout(new GridLayout(0, 1));
        this.compute = new Button("Compute flow field");
        this.compute.addActionListener(this);
        buttons.add(this.compute);
        this.computeAll = new Button("Compute all flow fields");
        this.computeAll.addActionListener(this);
        buttons.add(this.computeAll);
        this.display = new Button("Display");
        this.display.addActionListener(this);
        buttons.add(this.display);
        this.read = new Button("Open flow-field... ");
        this.read.addActionListener(this);
        buttons.add(this.read);
        this.save = new Button("Save flow-field... ");
        this.save.addActionListener(this);
        buttons.add(this.save);
        this.error = new Button("\u03c8 vs. true file... ");
        this.error.addActionListener(this);
        buttons.add(this.error);
        this.copy = new Button("\u03c8 field to Clipboard ");
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.trans = new Button("Translating flow field ");
        this.trans.setEnabled(false);
        this.trans.addActionListener(this);
        buttons.add(this.trans);
        this.rotate = new Button(" Rotation flow field ");
        this.rotate.setEnabled(false);
        this.rotate.addActionListener(this);
        buttons.add(this.rotate);
        this.centralImage = new Button(" Copy central frame ");
        this.centralImage.addActionListener(this);
        buttons.add(this.centralImage);
        this.graph = new Button(" Graph ");
        this.graph.addActionListener(this);
        buttons.add(this.graph);
        this.indexButton = new Button(" Display DC index image");
        this.indexButton.addActionListener(this);
        buttons.add(this.indexButton);
        this.staticCheckbox = new Checkbox("Display static background");
        this.staticCheckbox.setState(true);
        buttons.add(this.staticCheckbox);
        this.normalsCheckbox = new Checkbox("Include normals");
        this.normalsCheckbox.setState(false);
        buttons.add(this.normalsCheckbox);
        this.rLabel = new Label("");
        buttons.add(this.rLabel);
        this.sLabel = new Label("");
        buttons.add(this.sLabel);
        this.alphaField = new Label("");
        buttons.add(this.alphaField);
        this.posLabel = new Label("x:   y:            ");
        buttons.add(this.posLabel);
        this.win.add((Component)buttons);
        ((FlowJCanvas)this.win.getCanvas()).setFields(this.alphaField, this.rLabel, this.sLabel, this.posLabel);
        Panel params = new Panel();
        params.setLayout(new GridLayout(0, 2));
        if (this.hasVolume) {
            this.frameField = this.CreateTextField(params, "Central slice:", "" + this.imp.getStackSize() / 2, 0);
        }
        String[] salgorithm = new String[]{"Lucas & Kanade", "Uras", "Singh", "Fleet & Jepson"};
        this.algorithmChoice = this.CreateChoice(params, "Algorithm", salgorithm, 0);
        this.gradientChoice = this.CreateChoice(params, "Gradient method:", FlowJLucas.sderiv, 0);
        this.sigmasField = this.CreateTextField(params, "\u03a3-s (LK,U,FJ):", "1.5", 2);
        this.sigmatField = this.CreateTextField(params, "\u03a3-t (LK,U,FJ):", "1.0", 2);
        this.tauField = this.CreateTextField(params, "\u03c4 (LK,U):", "1.0", 2);
        this.sigmawField = this.CreateTextField(params, "\u03a3-w (LK):", "1.0", 2);
        this.regularizationChoice = this.CreateChoice(params, "Regularization (LK)", FlowJLucas.sregul, 0);
        this.regionField = this.CreateTextField(params, "Region-size (U):", "1", 0);
        this.resLabel = this.CreateTextField(params, "Residual < (F)", "0.5", 2);
        this.condField = this.CreateTextField(params, "Condition number < (F)", "10.0", 2);
        this.maxampField = this.CreateTextField(params, "Maxamp (F):", "0.1", 2);
        this.taufField = this.CreateTextField(params, "\u03c4 (F):", "2.5", 2);
        this.taus1Field = this.CreateTextField(params, "\u03c4-1 (S):", "0.0", 2);
        this.taus2Field = this.CreateTextField(params, "\u03c4-2 (S):", "0.0", 2);
        this.mappingChoice = this.CreateChoice(params, "Mapping type", FlowJDisplay.description, 0);
        this.rhoField = this.CreateTextField(params, "\u03c1:", "2.0", 1);
        this.scaleField = this.CreateTextField(params, "Display scaling:", "2", 1);
        this.win.add((Component)params);
        this.win.pack();
        this.draw();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.compute) {
            this.doCompute(false);
        } else if (e.getSource() == this.computeAll) {
            this.doCompute(true);
        } else if (e.getSource() == this.display) {
            this.display();
        } else if (e.getSource() == this.rotate) {
            this.doRotation();
        } else if (e.getSource() == this.error) {
            this.doError();
        } else if (e.getSource() == this.read) {
            this.doRead();
        } else if (e.getSource() == this.save) {
            this.doSave();
        } else if (e.getSource() == this.centralImage) {
            this.doCentralImage();
        } else if (e.getSource() == this.graph) {
            this.doGraph();
        } else if (e.getSource() == this.indexButton) {
            this.doIndex();
        } else {
            this.copyToClipboard();
        }
    }

    private void fastDisplay() {
        if (this.flow instanceof FlowJFlow) {
            ImageStack stack = this.imp.getStack();
            ImageProcessor ip = this.staticCheckbox.getState() ? this.flow.mapImage(stack.getProcessor((int)this.getFloatField(this.frameField)), 0, 0, 1.0f, this.getFloatField(this.rhoField)) : this.flow.mapImage(null, 0, 0, 1.0f, this.getFloatField(this.rhoField));
            this.setProcessor("2D DCM " + this.description, ip);
            this.draw();
        }
    }

    private void display() {
        ImagePlus nimp;
        this.rho = this.getFloatField(this.rhoField);
        ImageStack stack = this.imp.getStack();
        float scale = this.getFloatField(this.scaleField);
        int mapping = this.mappingChoice.getSelectedIndex();
        if (this.flows.size() == 1) {
            FlowJFlow flow = (FlowJFlow)this.flows.elementAt(0);
            ImageProcessor ip = this.staticCheckbox.getState() ? flow.mapImage(stack.getProcessor((int)this.getFloatField(this.frameField)), mapping, 0, scale, this.rho) : flow.mapImage(null, mapping, 0, scale, this.rho);
            nimp = new ImagePlus(flow.getTitle(mapping, scale, this.rho), ip);
        } else {
            ImageProcessor ip = this.flow.mapImage(stack.getProcessor(stack.getSize() / 2), mapping, 0, scale, this.rho);
            ImageStack is = new ImageStack(ip.getWidth(), ip.getHeight());
            for (int frame = 0; frame < stack.getSize(); ++frame) {
                FlowJFlow flow = (FlowJFlow)this.flows.elementAt(frame);
                if (flow == null) continue;
                ip = flow.mapImage(stack.getProcessor(frame + 1), mapping, 0, scale, this.rho);
                is.addSlice("" + frame, ip);
            }
            nimp = new ImagePlus("All flows", is);
        }
        nimp.show();
    }

    private void doIndex() {
        int w;
        int h = w = 256;
        ColorProcessor ip = new ColorProcessor(w, h);
        int[] pixels = (int[])ip.getPixels();
        int i = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                float rx = ((float)x - (float)w / 2.0f) / ((float)w / 2.0f);
                float ry = -((float)y - (float)h / 2.0f) / ((float)w / 2.0f);
                float[] p = FlowJFlow.polar(rx, ry);
                if (p[0] <= 1.0f) {
                    byte[] rgb = new byte[3];
                    FlowJDynamicColor.map2D(rgb, (double)p[0], (double)p[1]);
                    pixels[i] = (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | rgb[2] & 0xFF;
                }
                ++i;
            }
        }
        new ImagePlus("DC Index", (ImageProcessor)ip).show();
    }

    private void doGraph() {
        if (this.flow instanceof FlowJFlow && this.trueFlow instanceof FlowJFlow) {
            ImagePlus imp = new ImagePlus("True-Estimate " + this.description, GUI.createBlankImage((int)300, (int)300));
            ImageWindow imw = new ImageWindow(imp);
            imp.show();
            Image img = imp.getImage();
            FlowJError.map(img.getGraphics(), 300, 300, this.flow, this.trueFlow);
        } else {
            IJ.error((String)"flow or true flow not known");
        }
    }

    private void doError() {
        String directory;
        FileDialog fd = new FileDialog((Frame)this.win, "True flow field to compare to...", 0);
        if (defaultDirectory != null) {
            fd.setDirectory(defaultDirectory);
        }
        fd.setVisible(true);
        String name = fd.getFile();
        defaultDirectory = directory = fd.getDirectory();
        fd.dispose();
        this.trueFlow = new FlowJFlow();
        if (!this.trueFlow.read(directory + name)) {
            return;
        }
        if (this.flow.getWidth() != this.trueFlow.getWidth() || this.flow.getHeight() != this.trueFlow.getHeight()) {
            IJ.error((String)("flow field and " + name + " not the same size"));
            return;
        }
        this.flowError = new FlowJError(this.flow.getWidth(), this.flow.getHeight());
        ((FlowJCanvas)this.win.getCanvas()).setDisplayed(this.flowError);
        this.flowError.computePsi(this.flow, this.trueFlow);
        ColorProcessor cp = new ColorProcessor(this.flow.getWidth(), this.flow.getHeight());
        this.flowError.map(cp);
        this.setProcessor("Errors", (ImageProcessor)cp);
        this.draw();
        this.flowError.averageOverVelocity();
    }

    private void doRotation() {
        ImageStack stack = this.imp.getStack();
        this.flow = new FlowJFlow(stack.getWidth(), stack.getHeight());
        this.xError = this.getIntField(this.xField);
        this.yError = this.getIntField(this.yField);
        this.flow.createRotation(this.xError, this.yError, -0.08726647f, this.getRoi());
        ((FlowJCanvas)this.win.getCanvas()).setDisplayed(this.flow);
        this.description = "rotation field";
        this.fastDisplay();
    }

    private void doCentralImage() {
        ImageStack stack = this.imp.getStack();
        this.frame = (int)this.getFloatField(this.frameField);
        this.setProcessor("Central image", stack.getProcessor(this.frame));
        this.draw();
    }

    private void doRead() {
        String directory;
        FileDialog fd = new FileDialog((Frame)this.win, "Read flow file...", 0);
        if (defaultDirectory != null) {
            fd.setDirectory(defaultDirectory);
        }
        fd.setVisible(true);
        String name = fd.getFile();
        defaultDirectory = directory = fd.getDirectory();
        fd.dispose();
        FlowJFlow newflow = new FlowJFlow();
        ImageStack stack = this.imp.getStack();
        if (this.flow.read(directory + name)) {
            if (this.flow.getWidth() != stack.getWidth() || this.flow.getHeight() != stack.getHeight()) {
                IJ.error((String)"Flow field does not fit this estimator.\nPlease create a new one.");
                return;
            }
            IJ.wait((int)250);
            this.description = name;
            this.fastDisplay();
            IJ.log((String)("Read: " + name));
            this.flow = newflow;
        }
    }

    private void doSave() {
        String directory;
        FileDialog fd = new FileDialog((Frame)this.win, "Save flow in file...", 1);
        if (defaultDirectory != null) {
            fd.setDirectory(defaultDirectory);
        }
        fd.setFile(this.description + ".flow");
        fd.setVisible(true);
        String name = fd.getFile();
        defaultDirectory = directory = fd.getDirectory();
        fd.dispose();
        this.flow.write(directory + name);
    }

    /*
     * Unable to fully structure code
     */
    public void doCompute(boolean all) {
        start = System.currentTimeMillis();
        IJ.showStatus((String)"Computing 2D optical flow...");
        this.flows = new Vector<E>();
        if (!all) {
            frame = (int)this.getFloatField(this.frameField);
            try {
                this.computeSingleFrame(frame);
                this.flows.addElement(this.flow);
                new ImagePlus("2D Flow xy", this.flow.toStack()).show();
                if (!(this.trueFlow instanceof FlowJFlow)) ** GOTO lbl33
                this.flowError.computePsi(this.flow, this.trueFlow);
                this.flowError.averageOverVelocity();
            }
            catch (FlowJException e) {
                IJ.error((String)e.toString());
                return;
            }
        } else {
            stack = this.imp.getStack();
            first = FlowJLucas.firstFrame(stack, this.getFloatField(this.sigmatField), this.gradientChoice.getSelectedIndex());
            last = FlowJLucas.lastFrame(stack, this.getFloatField(this.sigmatField), this.gradientChoice.getSelectedIndex());
            for (frame = 1; frame <= stack.getSize(); ++frame) {
                if (frame >= first && frame <= last) {
                    try {
                        IJ.showStatus((String)("Computing 2D optical flow (" + frame + ")..."));
                        this.computeSingleFrame(frame);
                        this.flows.addElement(this.flow);
                    }
                    catch (FlowJException e) {
                        IJ.log((String)("FlowJException: " + e));
                        this.flows.addElement(null);
                    }
                    continue;
                }
                this.flows.addElement(null);
            }
        }
lbl33:
        // 3 sources

        elapsedTime = System.currentTimeMillis() - start;
        seconds = (float)elapsedTime / 1000.0f;
        pxs = this.imp.getStack().getWidth() * this.imp.getStack().getHeight();
        IJ.log((String)("" + seconds + " sec, " + (int)((float)pxs / seconds) + " pixels/second"));
    }

    public void computeSingleFrame(int frame) throws FlowJException {
        ImageStack stack = this.imp.getStack();
        this.sigmat = this.getFloatField(this.sigmatField);
        this.tau = this.getFloatField(this.tauField);
        this.region = this.getIntField(this.regionField);
        this.sigmas = this.getFloatField(this.sigmasField);
        switch (this.algorithmChoice.getSelectedIndex()) {
            case 3: {
                FlowJFleet fleet = new FlowJFleet();
                fleet.filterAll(stack, frame, this.sigmat, this.sigmas);
                fleet.normals(this.getFloatField(this.maxampField), this.getFloatField(this.taufField));
                this.flow = new FlowJFlow(fleet.getWidth(), fleet.getHeight());
                IJ.showStatus((String)"computing flows (Fleet)...");
                fleet.computeFull(this.flow, this.getFloatField(this.condField), this.getFloatField(this.resLabel));
                this.description = fleet.toString();
                IJ.log((String)this.description);
                break;
            }
            case 0: {
                FlowJLucas lk = new FlowJLucas();
                lk.filterAll(stack, frame, this.sigmat, this.sigmas, this.gradientChoice.getSelectedIndex());
                this.flow = new FlowJFlow(stack.getWidth(), stack.getHeight());
                IJ.showStatus((String)"computing flows (LK)...");
                lk.computeFull(this.flow, this.normalsCheckbox.getState(), this.getFloatField(this.sigmawField), this.tau, this.regularizationChoice.getSelectedIndex());
                this.description = lk.toString();
                IJ.log((String)this.description);
                break;
            }
            case 1: {
                FlowJUras uras = new FlowJUras();
                uras.filterAll(stack, frame, this.sigmat, this.sigmas);
                uras.gradients();
                this.flow = new FlowJFlow(uras.getWidth(), uras.getHeight());
                uras.computeFull(this.flow, this.region, this.tau);
                this.description = uras.toString();
                IJ.log((String)this.description);
                break;
            }
            case 2: {
                FlowJSingh singh = new FlowJSingh();
                singh.filterAll(stack, frame, 1.0f);
                this.flow = new FlowJFlow(singh.getWidth(), singh.getHeight());
                singh.compute1(this.flow, this.getFloatField(this.taus1Field));
                this.description = singh.toString();
                IJ.log((String)this.description);
            }
        }
        IJ.showStatus((String)"displaying...");
        ((FlowJCanvas)this.win.getCanvas()).setDisplayed(this.flow);
        this.fastDisplay();
        this.flow.setCalibration(this.imp.getCalibration());
        IJ.showStatus((String)"");
    }

    void copyToClipboard() {
        if (this.flowError instanceof FlowJError) {
            Clipboard systemClipboard = null;
            try {
                systemClipboard = this.win.getToolkit().getSystemClipboard();
            }
            catch (Exception e) {
                systemClipboard = null;
            }
            if (systemClipboard == null) {
                IJ.error((String)"Unable to copy to Clipboard.");
                return;
            }
            IJ.showStatus((String)"Copying error statistics...");
            CharArrayWriter aw = new CharArrayWriter(8);
            PrintWriter pw = new PrintWriter(aw);
            this.flowError.clipboard(pw);
            String text = aw.toString();
            pw.close();
            StringSelection contents = new StringSelection(text);
            systemClipboard.setContents(contents, this);
            IJ.showStatus((String)(text.length() + " characters copied to Clipboard"));
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private Choice CreateChoice(Panel p, String s, String[] d, int i) {
        Label l = new Label(s);
        p.add(l);
        Choice t = new Choice();
        for (int j = 0; j < d.length; ++j) {
            t.addItem(d[j]);
        }
        t.select(i);
        p.add(t);
        return t;
    }

    private TextField CreateTextField(Panel p, String s, String d, int i) {
        Label l = new Label(s);
        p.add(l);
        TextField t = new TextField(d + "", i);
        t.setEditable(true);
        p.add(t);
        return t;
    }

    private float getFloatField(TextField t) {
        Float d;
        String s = t.getText();
        try {
            d = new Float(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d.floatValue();
        }
        return 0.0f;
    }

    private int getIntField(TextField t) {
        Integer d;
        String s = t.getText();
        try {
            d = new Integer(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0;
    }

    public static void showStatus(String s) {
        IJ.showStatus((String)s);
    }

    public static void write(String s) {
        IJ.log((String)s);
    }

    public static void showProgress(float d) {
        IJ.showProgress((double)d);
    }

    public static void error(String s) {
        IJ.error((String)s);
    }
}

