/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJCell;
import VolumeJ.VJGradient;
import VolumeJ.VJValue;
import VolumeJ.VJValueHSB;
import VolumeJ.VJVoxelLoc;
import volume.Volume;
import volume.VolumeRGB;

public abstract class VJInterpolator {
    public abstract boolean isValid(VJVoxelLoc var1, Volume var2);

    public abstract boolean isValidGradient(VJVoxelLoc var1, Volume var2);

    public abstract boolean isValidGradient(VJCell var1, Volume var2);

    public abstract VJValue value(VJValue var1, Volume var2, VJVoxelLoc var3);

    public abstract VJGradient gradient(Volume var1, VJVoxelLoc var2);

    public abstract String toString();

    public VJValueHSB valueHS(VJValueHSB hsb, VolumeRGB v, double threshold, VJVoxelLoc vl) {
        VJVoxelLoc smallestVl = new VJVoxelLoc();
        int smallestDelta = 256;
        int REGION = 2;
        for (int z = vl.iz; z < vl.iz + REGION; ++z) {
            for (int y = vl.iy; y < vl.iy + REGION; ++y) {
                for (int x = vl.ix; x < vl.ix + REGION; ++x) {
                    int delta = (int)threshold - (v.b[z * v.getHeight() * v.getWidth() + y * v.getWidth() + x] & 0xFF);
                    if (Math.abs(delta) >= Math.abs(smallestDelta)) continue;
                    smallestVl.setx(x);
                    smallestVl.sety(y);
                    smallestVl.setz(z);
                    smallestDelta = delta;
                }
            }
        }
        int[] slice = (int[])v.sliceArray[smallestVl.iz];
        int voxel = slice[smallestVl.iy * v.getWidth() + smallestVl.ix];
        VolumeRGB.intToHSB(hsb.hsb, voxel);
        return hsb;
    }
}

