/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.measure.ResultsTable;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.IndexColorModel;

class LutWindow
extends ImageWindow
implements ActionListener {
    private Button button;
    private ImageProcessor ip;

    LutWindow(ImagePlus imp, ImageCanvas ic, ImageProcessor ip) {
        super(imp, ic);
        this.ip = ip;
        this.addPanel();
    }

    void addPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.button = new Button(" List... ");
        this.button.addActionListener(this);
        panel.add(this.button);
        this.add(panel);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.button) {
            this.list(this.ip);
        }
    }

    void list(ImageProcessor ip) {
        IndexColorModel icm = (IndexColorModel)ip.getColorModel();
        int size = icm.getMapSize();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        icm.getReds(r);
        icm.getGreens(g);
        icm.getBlues(b);
        ResultsTable rt = new ResultsTable();
        for (int i = 0; i < size; ++i) {
            rt.setValue("Index", i, (double)i);
            rt.setValue("Red", i, (double)(r[i] & 0xFF));
            rt.setValue("Green", i, (double)(g[i] & 0xFF));
            rt.setValue("Blue", i, (double)(b[i] & 0xFF));
        }
        rt.show("LUT");
    }
}

