/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.map;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.Parallel;
import net.imagej.ops.map.AbstractMapBinaryComputer;
import net.imagej.ops.map.Maps;
import net.imagej.ops.thread.chunker.ChunkerOp;
import net.imagej.ops.thread.chunker.CursorBasedChunk;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import org.scijava.plugin.Plugin;

public class MapBinaryComputers {
    private MapBinaryComputers() {
    }

    @Plugin(type=Ops.Map.class, priority=-89.0)
    public static class RAIAndRAIToIIParallel<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, RandomAccessibleInterval<EI1>, RandomAccessibleInterval<EI2>, IterableInterval<EO>>
    implements Contingent,
    Parallel {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((RandomAccessibleInterval)this.in1(), (RandomAccessibleInterval)this.in2(), (IterableInterval)this.out());
        }

        @Override
        public void compute(final RandomAccessibleInterval<EI1> input1, final RandomAccessibleInterval<EI2> input2, final IterableInterval<EO> output) {
            this.ops().run(ChunkerOp.class, new CursorBasedChunk(){

                @Override
                public void execute(long startIndex, long stepSize, long numSteps) {
                    Maps.map(input1, input2, output, this.getOp().getIndependentInstance(), startIndex, stepSize, numSteps);
                }
            }, output.size());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-99.0)
    public static class RAIAndRAIToII<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, RandomAccessibleInterval<EI1>, RandomAccessibleInterval<EI2>, IterableInterval<EO>>
    implements Contingent {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((RandomAccessibleInterval)this.in1(), (RandomAccessibleInterval)this.in2(), (IterableInterval)this.out());
        }

        @Override
        public void compute(RandomAccessibleInterval<EI1> input1, RandomAccessibleInterval<EI2> input2, IterableInterval<EO> output) {
            Maps.map(input1, input2, output, this.getOp());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-88.0)
    public static class RAIAndIIToRAIParallel<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, RandomAccessibleInterval<EI1>, IterableInterval<EI2>, RandomAccessibleInterval<EO>>
    implements Contingent,
    Parallel {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((RandomAccessibleInterval)this.in1(), (IterableInterval)this.in2(), (RandomAccessibleInterval)this.out());
        }

        @Override
        public void compute(final RandomAccessibleInterval<EI1> input1, final IterableInterval<EI2> input2, final RandomAccessibleInterval<EO> output) {
            this.ops().run(ChunkerOp.class, new CursorBasedChunk(){

                @Override
                public void execute(long startIndex, long stepSize, long numSteps) {
                    Maps.map(input1, input2, output, this.getOp().getIndependentInstance(), startIndex, stepSize, numSteps);
                }
            }, input2.size());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-98.0)
    public static class RAIAndIIToRAI<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, RandomAccessibleInterval<EI1>, IterableInterval<EI2>, RandomAccessibleInterval<EO>>
    implements Contingent {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((RandomAccessibleInterval)this.in1(), (IterableInterval)this.in2(), (RandomAccessibleInterval)this.out());
        }

        @Override
        public void compute(RandomAccessibleInterval<EI1> input1, IterableInterval<EI2> input2, RandomAccessibleInterval<EO> output) {
            Maps.map(input1, input2, output, this.getOp());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-87.0)
    public static class RAIAndIIToIIParallel<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, RandomAccessibleInterval<EI1>, IterableInterval<EI2>, IterableInterval<EO>>
    implements Contingent,
    Parallel {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((RandomAccessibleInterval)this.in1(), (IterableInterval)this.in2(), (IterableInterval)this.out());
        }

        @Override
        public void compute(final RandomAccessibleInterval<EI1> input1, final IterableInterval<EI2> input2, final IterableInterval<EO> output) {
            this.ops().run(ChunkerOp.class, new CursorBasedChunk(){

                @Override
                public void execute(long startIndex, long stepSize, long numSteps) {
                    Maps.map(input1, input2, output, this.getOp().getIndependentInstance(), startIndex, stepSize, numSteps);
                }
            }, input2.size());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-97.0)
    public static class RAIAndIIToII<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, RandomAccessibleInterval<EI1>, IterableInterval<EI2>, IterableInterval<EO>>
    implements Contingent {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((RandomAccessibleInterval)this.in1(), (IterableInterval)this.in2(), (IterableInterval)this.out());
        }

        @Override
        public void compute(RandomAccessibleInterval<EI1> input1, IterableInterval<EI2> input2, IterableInterval<EO> output) {
            Maps.map(input1, input2, output, this.getOp());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-86.0)
    public static class IIAndRAIToRAIParallel<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, IterableInterval<EI1>, RandomAccessibleInterval<EI2>, RandomAccessibleInterval<EO>>
    implements Contingent,
    Parallel {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in1(), (RandomAccessibleInterval)this.in2(), (RandomAccessibleInterval)this.out());
        }

        @Override
        public void compute(final IterableInterval<EI1> input1, final RandomAccessibleInterval<EI2> input2, final RandomAccessibleInterval<EO> output) {
            this.ops().run(ChunkerOp.class, new CursorBasedChunk(){

                @Override
                public void execute(long startIndex, long stepSize, long numSteps) {
                    Maps.map(input1, input2, output, this.getOp().getIndependentInstance(), startIndex, stepSize, numSteps);
                }
            }, input1.size());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-96.0)
    public static class IIAndRAIToRAI<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, IterableInterval<EI1>, RandomAccessibleInterval<EI2>, RandomAccessibleInterval<EO>>
    implements Contingent {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in1(), (RandomAccessibleInterval)this.in2(), (RandomAccessibleInterval)this.out());
        }

        @Override
        public void compute(IterableInterval<EI1> input1, RandomAccessibleInterval<EI2> input2, RandomAccessibleInterval<EO> output) {
            Maps.map(input1, input2, output, this.getOp());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-85.0)
    public static class IIAndRAIToIIParallel<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, IterableInterval<EI1>, RandomAccessibleInterval<EI2>, IterableInterval<EO>>
    implements Contingent,
    Parallel {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in1(), (RandomAccessibleInterval)this.in2(), (IterableInterval)this.out());
        }

        @Override
        public void compute(final IterableInterval<EI1> input1, final RandomAccessibleInterval<EI2> input2, final IterableInterval<EO> output) {
            this.ops().run(ChunkerOp.class, new CursorBasedChunk(){

                @Override
                public void execute(long startIndex, long stepSize, long numSteps) {
                    Maps.map(input1, input2, output, this.getOp().getIndependentInstance(), startIndex, stepSize, numSteps);
                }
            }, input1.size());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-95.0)
    public static class IIAndRAIToII<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, IterableInterval<EI1>, RandomAccessibleInterval<EI2>, IterableInterval<EO>>
    implements Contingent {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in1(), (RandomAccessibleInterval)this.in2(), (IterableInterval)this.out());
        }

        @Override
        public void compute(IterableInterval<EI1> input1, RandomAccessibleInterval<EI2> input2, IterableInterval<EO> output) {
            Maps.map(input1, input2, output, this.getOp());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-84.0)
    public static class IIAndIIToRAIParallel<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, IterableInterval<EI1>, IterableInterval<EI2>, RandomAccessibleInterval<EO>>
    implements Contingent,
    Parallel {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in1(), (IterableInterval)this.in2(), (RandomAccessibleInterval)this.out());
        }

        @Override
        public void compute(final IterableInterval<EI1> input1, final IterableInterval<EI2> input2, final RandomAccessibleInterval<EO> output) {
            this.ops().run(ChunkerOp.class, new CursorBasedChunk(){

                @Override
                public void execute(long startIndex, long stepSize, long numSteps) {
                    Maps.map(input1, input2, output, this.getOp().getIndependentInstance(), startIndex, stepSize, numSteps);
                }
            }, input1.size());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-94.0)
    public static class IIAndIIToRAI<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, IterableInterval<EI1>, IterableInterval<EI2>, RandomAccessibleInterval<EO>>
    implements Contingent {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in1(), (IterableInterval)this.in2(), (RandomAccessibleInterval)this.out());
        }

        @Override
        public void compute(IterableInterval<EI1> input1, IterableInterval<EI2> input2, RandomAccessibleInterval<EO> output) {
            Maps.map(input1, input2, output, this.getOp());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-83.0)
    public static class IIAndIIToIIParallel<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, IterableInterval<EI1>, IterableInterval<EI2>, IterableInterval<EO>>
    implements Contingent,
    Parallel {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in1(), (IterableInterval)this.in2(), (IterableInterval)this.out());
        }

        @Override
        public void compute(final IterableInterval<EI1> input1, final IterableInterval<EI2> input2, final IterableInterval<EO> output) {
            this.ops().run(ChunkerOp.class, new CursorBasedChunk(){

                @Override
                public void execute(long startIndex, long stepSize, long numSteps) {
                    Maps.map(input1, input2, output, this.getOp().getIndependentInstance(), startIndex, stepSize, numSteps);
                }
            }, input1.size());
        }
    }

    @Plugin(type=Ops.Map.class, priority=-93.0)
    public static class IIAndIIToII<EI1, EI2, EO>
    extends AbstractMapBinaryComputer<EI1, EI2, EO, IterableInterval<EI1>, IterableInterval<EI2>, IterableInterval<EO>>
    implements Contingent {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in1(), (IterableInterval)this.in2(), (IterableInterval)this.out());
        }

        @Override
        public void compute(IterableInterval<EI1> input1, IterableInterval<EI2> input2, IterableInterval<EO> output) {
            Maps.map(input1, input2, output, this.getOp());
        }
    }
}

