/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.ui;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.listen.NodeStateListener;
import edu.utexas.clm.archipelago.network.node.ClusterNode;
import edu.utexas.clm.archipelago.network.node.ClusterNodeState;
import edu.utexas.clm.archipelago.ui.ClusterUI;
import ij.gui.GenericDialog;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BoxLayout;

public class ClusterNodeStatusUI
implements ActionListener {
    private final Frame frame;
    private final Panel mainPanel;
    private final Panel uiPanel;
    private final ScrollPane pane;
    private final Cluster cluster;
    private final Hashtable<Long, NodeStatusPanel> statusPanels;
    private final Hashtable<Long, ClusterNode> nodeTable;
    private final ReentrantLock updateLock;
    private final AtomicBoolean active;
    private final ClusterUI ui;

    public static void doNodeLayout(Container container, Component ... components) {
        double containerWidth = 640.0;
        double[] widthWeight = new double[]{5.0, 1.0, 1.0, 2.0, 2.0, 2.0, 1.0};
        double totalWeight = 14.0;
        int x = 0;
        for (int i = 0; i < components.length && i < widthWeight.length; ++i) {
            int w = (int)(640.0 * widthWeight[i] / 14.0);
            int h = 24;
            Component c = components[i];
            container.add(c);
            c.setBounds(x, 0, w, 24);
            c.setMaximumSize(new Dimension(w, 24));
            c.setPreferredSize(new Dimension(w, 24));
            x += w;
        }
        container.validate();
    }

    public ClusterNodeStatusUI(Cluster c, ClusterUI cui) {
        Button clearButton = new Button("Clear Inactive Nodes");
        Button hideButton = new Button("Hide");
        GridBagConstraints gbc = new GridBagConstraints();
        this.statusPanels = new Hashtable();
        this.nodeTable = new Hashtable();
        this.active = new AtomicBoolean(true);
        this.cluster = c;
        this.ui = cui;
        this.frame = new Frame("Cluster Node Status");
        this.mainPanel = new Panel();
        this.uiPanel = new Panel();
        this.pane = new ScrollPane();
        this.updateLock = new ReentrantLock();
        clearButton.setActionCommand("clear");
        hideButton.setActionCommand("hide");
        clearButton.addActionListener(this);
        hideButton.addActionListener(this);
        this.mainPanel.setPreferredSize(new Dimension(512, 300));
        this.mainPanel.setMinimumSize(new Dimension(512, 300));
        this.pane.setPreferredSize(new Dimension(512, 300));
        this.pane.setMinimumSize(new Dimension(512, 300));
        gbc.gridwidth = 0;
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.pane, gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 1.0;
        this.mainPanel.add((Component)clearButton, gbc);
        gbc.gridwidth = 0;
        this.mainPanel.add((Component)hideButton, gbc);
        this.uiPanel.setLayout(new BoxLayout(this.uiPanel, 1));
        this.pane.add(this.uiPanel);
        this.addUIHeaders();
        this.stateChanged();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ClusterNodeStatusUI.this.toggleVisible();
                ClusterNodeStatusUI.this.ui.updateUI();
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                Dimension d = new Dimension(ClusterNodeStatusUI.this.frame.getSize());
                d.width -= 38;
                d.height -= 50;
                ClusterNodeStatusUI.this.pane.setMinimumSize(d);
                ClusterNodeStatusUI.this.pane.setPreferredSize(d);
            }
        });
        this.frame.add(this.mainPanel);
        this.frame.setVisible(false);
        this.frame.setPreferredSize(new Dimension(550, 350));
        this.frame.setMinimumSize(new Dimension(550, 350));
        this.frame.validate();
    }

    private void addUIHeaders() {
        Panel hp = new Panel();
        ClusterUI.doRowPanelLayout(hp, 640.0f, 24, new float[]{5.0f, 2.0f, 1.0f, 2.0f, 2.0f, 2.0f, 1.0f}, new Label("Host"), new Label("state"), new Label("n Jobs"), new Label("Beat"), new Label("MB used"), new Label("MB Total"), new Label(""));
        this.uiPanel.add(hp);
        this.uiPanel.validate();
    }

    public synchronized void stateChanged() {
        Set<ClusterNode> nodes = this.cluster.getNodes();
        Set<Long> keySet = this.nodeTable.keySet();
        for (ClusterNode node : nodes) {
            long id = node.getID();
            if (node.getState() == ClusterNodeState.STOPPED || node.getState() == ClusterNodeState.FAILED || keySet.contains(id)) continue;
            NodeStatusPanel panel = new NodeStatusPanel(node);
            this.nodeTable.put(id, node);
            this.statusPanels.put(id, panel);
            this.uiPanel.add(panel);
            this.frame.validate();
        }
    }

    private void doValidate() {
        this.frame.validate();
        this.pane.validate();
    }

    public void update() {
        if (this.updateLock.tryLock()) {
            for (NodeStatusPanel panel : this.statusPanels.values()) {
                panel.update();
            }
            this.frame.validate();
            this.updateLock.unlock();
        }
    }

    public synchronized void clearStoppedNodes() {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(this.nodeTable.values());
        for (ClusterNode node : nodes) {
            if (node.getState() != ClusterNodeState.STOPPED && node.getState() != ClusterNodeState.FAILED) continue;
            long id = node.getID();
            this.nodeTable.remove(id);
            this.uiPanel.remove(this.statusPanels.get(id));
            this.statusPanels.remove(id);
        }
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void setVisible(boolean v) {
        this.frame.setVisible(v);
    }

    public void toggleVisible() {
        this.setVisible(!this.frame.isVisible());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("clear")) {
            this.clearStoppedNodes();
        } else if (ae.getActionCommand().equals("hide")) {
            this.toggleVisible();
            this.ui.updateUI();
        }
    }

    public void stop() {
        this.active.set(false);
        this.frame.setVisible(false);
        this.frame.removeAll();
        this.mainPanel.removeAll();
        this.uiPanel.removeAll();
    }

    private class NodeStatusPanel
    extends Panel
    implements NodeStateListener,
    ActionListener {
        private final ClusterNode node;
        private final Label hostLabel;
        private final Label stateLabel;
        private final Label jobsLabel;
        private final Label beatLabel;
        private final Label ramUseLabel;
        private final Label ramTotLabel;
        private final Button killButton;

        public NodeStatusPanel(ClusterNode n) {
            this.node = n;
            this.hostLabel = new Label();
            this.jobsLabel = new Label();
            this.beatLabel = new Label();
            this.ramUseLabel = new Label();
            this.ramTotLabel = new Label();
            this.stateLabel = new Label();
            this.killButton = new Button("Stop");
            this.killButton.setActionCommand("stop");
            this.killButton.addActionListener(this);
            ClusterNodeStatusUI.doNodeLayout(this, this.hostLabel, this.stateLabel, this.jobsLabel, this.beatLabel, this.ramUseLabel, this.ramTotLabel, this.killButton);
            this.hostLabel.setText(this.node.getHost());
            ClusterNodeStatusUI.this.doValidate();
            this.node.addListener(this);
        }

        public synchronized void update() {
            long lastBeat = this.node.lastBeat();
            int beatSec = (int)((float)(System.currentTimeMillis() - lastBeat) / 1000.0f);
            int ramTot = this.node.getTotalRamMB();
            int ramAvail = this.node.getAvailableRamMB();
            int ramMax = this.node.getMaxRamMB();
            String beatString = lastBeat == 0L ? "~" : (beatSec > 0 ? "" + beatSec : "< 1");
            this.hostLabel.setText(this.node.getHost());
            this.jobsLabel.setText("" + this.node.numRunningThreads() + "/" + this.node.getThreadLimit());
            this.beatLabel.setText("" + beatString + "s ago");
            this.ramUseLabel.setText("" + (ramTot - ramAvail) + "MB");
            this.ramTotLabel.setText("" + ramMax + "MB");
            this.validate();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("stop")) {
                GenericDialog gd = new GenericDialog("Sure?");
                gd.addMessage("Really stop node " + this.node.getHost() + "?");
                gd.addMessage("Running processes may be rescheduled on other nodes.");
                gd.showDialog();
                if (gd.wasOKed()) {
                    this.node.close();
                }
            }
        }

        @Override
        public synchronized void stateChanged(ClusterNode node, ClusterNodeState stateNow, ClusterNodeState lastState) {
            if (stateNow != lastState) {
                String stateString = ClusterNode.stateString(stateNow);
                this.stateLabel.setText(stateString);
                if (stateNow == ClusterNodeState.FAILED) {
                    this.stateLabel.setForeground(Color.red);
                } else {
                    this.stateLabel.setForeground(Color.black);
                }
            }
        }
    }
}

