/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.Arrays;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Meshes;
import net.imglib2.mesh.Triangles;
import net.imglib2.mesh.Vertices;
import net.imglib2.mesh.util.MeshUtil;
import net.imglib2.mesh.util.SortArray;
import net.imglib2.mesh.util.SortBy;
import net.imglib2.util.Intervals;

public class Interior {
    private static final double SCALE_FRAC = 4.0E-4;
    private static final double PRECISION_LIMIT = 1.0E-7;
    private static final double RX = 1.0;
    private static final double RY = 0.0;
    private static final double RZ = 0.0;
    private final double[] minZs;
    private final int[] indexMin;
    private final double[] maxZs;
    private final int[] indices;
    private final Mesh mesh;
    private final double[] tmp = new double[3];
    private final TDoubleArrayList xIntersect = new TDoubleArrayList();
    private final TDoubleArrayList xNormals = new TDoubleArrayList();
    private final double[] intersection;
    private final RealInterval boundingBox;

    public Interior(Mesh mesh, double scale) {
        this(mesh, Meshes.boundingBox(mesh), scale);
    }

    public Interior(Mesh mesh, RealInterval boundingBox, double scale) {
        this.mesh = mesh;
        this.boundingBox = boundingBox;
        double eps = 4.0E-4 * scale;
        Triangles triangles = mesh.triangles();
        Vertices vertices = mesh.vertices();
        this.minZs = new double[triangles.size()];
        this.maxZs = new double[triangles.size()];
        for (int t = 0; t < triangles.size(); ++t) {
            long v0 = triangles.vertex0(t);
            long v1 = triangles.vertex1(t);
            long v2 = triangles.vertex2(t);
            this.minZs[t] = MeshUtil.minZ(vertices, v0, v1, v2, eps);
            this.maxZs[t] = MeshUtil.maxZ(vertices, v0, v1, v2, eps);
        }
        this.indexMin = SortArray.quicksort(this.minZs);
        this.indices = new int[this.indexMin.length];
        this.intersection = new double[3];
    }

    public boolean isInside(RealPoint p) {
        if (p.numDimensions() < 3) {
            throw new IllegalArgumentException("Point must have at least 3 dimensions. Got " + p.numDimensions() + ".");
        }
        if (!Intervals.contains((RealInterval)this.boundingBox, (RealLocalizable)p)) {
            return false;
        }
        double ox = p.getDoublePosition(0);
        double oy = p.getDoublePosition(1);
        double oz = MeshUtil.mround(p.getDoublePosition(2), 4.0E-4, 2, 1);
        int k1 = Arrays.binarySearch(this.minZs, oz);
        if (k1 < 0) {
            k1 = -(k1 + 1);
        }
        System.arraycopy(this.indexMin, 0, this.indices, 0, k1);
        SortBy.sortBy(this.indices, this.maxZs, 0, k1 - 1);
        int k2 = SortBy.binarySearch(this.indices, this.maxZs, 0, k1, oz);
        if (k2 < 0) {
            k2 = -(k2 + 1);
        }
        int start = k2;
        int end = k1;
        this.xIntersect.resetQuick();
        this.xNormals.resetQuick();
        for (int i = start; i < end; ++i) {
            int id = this.indices[i];
            boolean intersects = this.rayIntersectsTriangle(id, ox, oy, oz, 1.0, 0.0, 0.0, this.intersection);
            if (!intersects) continue;
            this.xIntersect.add(this.intersection[0]);
            this.xNormals.add(this.mesh.triangles().nx(id));
        }
        if (this.xIntersect.size() < 1) {
            return false;
        }
        this.xIntersect.sort();
        int nCross = 0;
        double previousX = Double.NaN;
        double previousN = this.xNormals.get(0);
        for (int i = 0; i < this.xIntersect.size(); ++i) {
            double v = this.xIntersect.get(i);
            double n = this.xNormals.get(i);
            if (v != previousX || n * previousN > 0.0) {
                ++nCross;
            }
            previousX = v;
            previousN = n;
        }
        return nCross % 2 != 0;
    }

    private final boolean rayIntersectsTriangle(long id, double ox, double oy, double oz, double rx, double ry, double rz, double[] intersection) {
        long vertex0 = this.mesh.triangles().vertex0(id);
        long vertex1 = this.mesh.triangles().vertex1(id);
        long vertex2 = this.mesh.triangles().vertex2(id);
        double x0 = this.mesh.vertices().x(vertex0);
        double y0 = this.mesh.vertices().y(vertex0);
        double z0 = MeshUtil.mround(this.mesh.vertices().z(vertex0), 4.0E-4, 2, 0);
        double x1 = this.mesh.vertices().x(vertex1);
        double y1 = this.mesh.vertices().y(vertex1);
        double z1 = MeshUtil.mround(this.mesh.vertices().z(vertex1), 4.0E-4, 2, 0);
        double x2 = this.mesh.vertices().x(vertex2);
        double y2 = this.mesh.vertices().y(vertex2);
        double z2 = MeshUtil.mround(this.mesh.vertices().z(vertex2), 4.0E-4, 2, 0);
        double e1x = x1 - x0;
        double e1y = y1 - y0;
        double e1z = z1 - z0;
        double e2x = x2 - x0;
        double e2y = y2 - y0;
        double e2z = z2 - z0;
        this.cross(rx, ry, rz, e2x, e2y, e2z, this.tmp);
        double hx = this.tmp[0];
        double hy = this.tmp[1];
        double hz = this.tmp[2];
        double a = this.dot(e1x, e1y, e1z, hx, hy, hz);
        if (a > -1.0E-7 && a < 1.0E-7) {
            return false;
        }
        double f = 1.0 / a;
        double sx = ox - x0;
        double sy = oy - y0;
        double sz = oz - z0;
        double u = f * this.dot(sx, sy, sz, hx, hy, hz);
        if (u < 0.0 || u > 1.0) {
            return false;
        }
        this.cross(sx, sy, sz, e1x, e1y, e1z, this.tmp);
        double qx = this.tmp[0];
        double qy = this.tmp[1];
        double qz = this.tmp[2];
        double v = f * this.dot(rx, ry, rz, qx, qy, qz);
        if (v < 0.0 || u + v > 1.0) {
            return false;
        }
        double t = f * this.dot(e2x, e2y, e2z, qx, qy, qz);
        if (t < 1.0E-7) {
            return false;
        }
        intersection[0] = ox + t * rx;
        intersection[1] = oy + t * ry;
        intersection[2] = oy + t * rz;
        return true;
    }

    private double dot(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 * x2 + y1 * y2 + z1 * z2;
    }

    private void cross(double x1, double y1, double z1, double x2, double y2, double z2, double[] out) {
        out[0] = y1 * z2 - z1 * y2;
        out[1] = -x1 * z2 + z1 * x2;
        out[2] = x1 * y2 - y1 * x2;
    }
}

