/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongLongHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.BitSet;
import java.util.Iterator;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangles;
import net.imglib2.mesh.Vertices;
import net.imglib2.mesh.impl.nio.BufferMesh;

public class MeshConnectedComponents {
    public static final int n(Mesh mesh) {
        Triangles triangles = mesh.triangles();
        Vertices vertices = mesh.vertices();
        int nVertices = vertices.size();
        TIntObjectHashMap<TIntArrayList> map = MeshConnectedComponents.triangleMap(mesh);
        BitSet visited = new BitSet(nVertices);
        TIntLinkedList queue = new TIntLinkedList(-1);
        int nCC = 0;
        int nextClearBit = 0;
        while ((nextClearBit = visited.nextClearBit(nextClearBit)) < nVertices) {
            for (int vid = nextClearBit; vid < nVertices; ++vid) {
                if (visited.get(vid)) continue;
                int start = vid;
                ++nCC;
                queue.clear();
                queue.add(start);
                while (!queue.isEmpty()) {
                    int v = queue.removeAt(queue.size() - 1);
                    visited.set(v);
                    TIntArrayList ts = map.get(v);
                    int nts = ts.size();
                    for (int i = 0; i < nts; ++i) {
                        int t = ts.get(i);
                        MeshConnectedComponents.visit(triangles.vertex0(t), visited, queue);
                        MeshConnectedComponents.visit(triangles.vertex1(t), visited, queue);
                        MeshConnectedComponents.visit(triangles.vertex2(t), visited, queue);
                    }
                }
                nextClearBit = start;
            }
        }
        return nCC;
    }

    public static Iterator<BufferMesh> iterator(Mesh mesh) {
        return new MyCCIterator(mesh);
    }

    public static Iterable<BufferMesh> iterable(final Mesh mesh) {
        return new Iterable<BufferMesh>(){

            @Override
            public Iterator<BufferMesh> iterator() {
                return MeshConnectedComponents.iterator(mesh);
            }
        };
    }

    private static final boolean visit(int v, BitSet visited, TIntLinkedList queue) {
        if (!visited.get(v)) {
            queue.add(v);
            return true;
        }
        return false;
    }

    private static final TIntObjectHashMap<TIntArrayList> triangleMap(Mesh mesh) {
        Triangles triangles = mesh.triangles();
        int nTriangles = triangles.size();
        Vertices vertices = mesh.vertices();
        int nVertices = vertices.size();
        TIntObjectHashMap<TIntArrayList> map = new TIntObjectHashMap<TIntArrayList>(nVertices);
        for (int tid = 0; tid < nTriangles; ++tid) {
            MeshConnectedComponents.addToMap(map, triangles.vertex0(tid), tid);
            MeshConnectedComponents.addToMap(map, triangles.vertex1(tid), tid);
            MeshConnectedComponents.addToMap(map, triangles.vertex2(tid), tid);
        }
        return map;
    }

    private static void addToMap(TIntObjectHashMap<TIntArrayList> map, int v, int tid) {
        TIntArrayList ts = map.get(v);
        if (ts == null) {
            ts = new TIntArrayList();
            map.put(v, ts);
        }
        ts.add(tid);
    }

    private static final class MyCCIterator
    implements Iterator<BufferMesh> {
        private final Mesh mesh;
        private final BitSet visited;
        private BufferMesh next;
        private final TIntObjectHashMap<TIntArrayList> map;
        private int currentStartVertex;
        private final int nVertices;

        public MyCCIterator(Mesh mesh) {
            this.mesh = mesh;
            this.map = MeshConnectedComponents.triangleMap(mesh);
            this.nVertices = mesh.vertices().size();
            this.visited = new BitSet(this.nVertices);
            this.currentStartVertex = 0;
            this.next = this.prefetch();
        }

        private BufferMesh prefetch() {
            Triangles triangles = this.mesh.triangles();
            TIntHashSet cc = new TIntHashSet();
            while ((this.currentStartVertex = this.visited.nextClearBit(this.currentStartVertex)) < this.nVertices) {
                for (int vid = this.currentStartVertex; vid < this.nVertices; ++vid) {
                    if (this.visited.get(vid)) continue;
                    int start = vid;
                    TIntLinkedList queue = new TIntLinkedList(-1);
                    queue.add(start);
                    while (!queue.isEmpty()) {
                        int v = queue.removeAt(queue.size() - 1);
                        this.visited.set(v);
                        TIntArrayList ts = this.map.get(v);
                        int nts = ts.size();
                        for (int i = 0; i < nts; ++i) {
                            int t = ts.get(i);
                            boolean add = false;
                            add = MeshConnectedComponents.visit(triangles.vertex0(t), this.visited, queue) || add;
                            add = MeshConnectedComponents.visit(triangles.vertex1(t), this.visited, queue) || add;
                            boolean bl = add = MeshConnectedComponents.visit(triangles.vertex2(t), this.visited, queue) || add;
                            if (!add) continue;
                            cc.add(t);
                        }
                    }
                    this.currentStartVertex = start;
                    return this.makeCC(cc);
                }
            }
            return null;
        }

        private BufferMesh makeCC(TIntHashSet cc) {
            final Triangles inTriangles = this.mesh.triangles();
            final Vertices inVertices = this.mesh.vertices();
            final TLongHashSet vs = new TLongHashSet();
            cc.forEach(new TIntProcedure(){

                @Override
                public boolean execute(int t) {
                    vs.add(inTriangles.vertex0(t));
                    vs.add(inTriangles.vertex1(t));
                    vs.add(inTriangles.vertex2(t));
                    return true;
                }
            });
            BufferMesh out = new BufferMesh(vs.size(), cc.size());
            final BufferMesh.Vertices outVertices = out.vertices();
            final BufferMesh.Triangles outTriangles = out.triangles();
            final TLongLongHashMap inOutMap = new TLongLongHashMap(this.nVertices, 0.5f, -1L, -1L);
            cc.forEach(new TIntProcedure(){

                @Override
                public boolean execute(int t) {
                    long inv2;
                    long outv2;
                    long inv1;
                    long outv1;
                    long inv0 = inTriangles.vertex0(t);
                    long outv0 = inOutMap.get(inv0);
                    if (inOutMap.get(inv0) < 0L) {
                        float x0 = inVertices.xf(inv0);
                        float y0 = inVertices.yf(inv0);
                        float z0 = inVertices.zf(inv0);
                        outv0 = outVertices.addf(x0, y0, z0);
                        inOutMap.put(inv0, outv0);
                    }
                    if ((outv1 = inOutMap.get(inv1 = (long)inTriangles.vertex1(t))) < 0L) {
                        float x1 = inVertices.xf(inv1);
                        float y1 = inVertices.yf(inv1);
                        float z1 = inVertices.zf(inv1);
                        outv1 = outVertices.addf(x1, y1, z1);
                        inOutMap.put(inv1, outv1);
                    }
                    if ((outv2 = inOutMap.get(inv2 = (long)inTriangles.vertex2(t))) < 0L) {
                        float x2 = inVertices.xf(inv2);
                        float y2 = inVertices.yf(inv2);
                        float z2 = inVertices.zf(inv2);
                        outv2 = outVertices.addf(x2, y2, z2);
                        inOutMap.put(inv2, outv2);
                    }
                    float nxf = inTriangles.nxf(t);
                    float nyf = inTriangles.nyf(t);
                    float nzf = inTriangles.nzf(t);
                    outTriangles.addf(outv0, outv1, outv2, nxf, nyf, nzf);
                    return true;
                }
            });
            return out;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public BufferMesh next() {
            BufferMesh out = this.next;
            this.next = this.prefetch();
            return out;
        }
    }
}

