/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.util;

import net.imglib2.RealLocalizable;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Meshes;
import net.imglib2.mesh.Triangle;
import net.imglib2.mesh.impl.naive.NaiveDoubleMesh;
import net.imglib2.mesh.impl.nio.BufferMesh;

public final class Icosahedron {
    public static final Mesh core() {
        NaiveDoubleMesh mesh = new NaiveDoubleMesh();
        double t = (1.0 + Math.sqrt(5.0)) / 2.0;
        double[][] vs = new double[][]{{-1.0, t, 0.0}, {1.0, t, 0.0}, {-1.0, -t, 0.0}, {1.0, -t, 0.0}, {0.0, -1.0, t}, {0.0, 1.0, t}, {0.0, -1.0, -t}, {0.0, 1.0, -t}, {t, 0.0, -1.0}, {t, 0.0, 1.0}, {-t, 0.0, -1.0}, {-t, 0.0, 1.0}};
        double[] tmp = new double[3];
        for (double[] v : vs) {
            Icosahedron.normalize(v, tmp);
            mesh.vertices().add(tmp[0], tmp[1], tmp[2]);
        }
        mesh.triangles().add(0L, 11L, 5L);
        mesh.triangles().add(0L, 5L, 1L);
        mesh.triangles().add(0L, 1L, 7L);
        mesh.triangles().add(0L, 7L, 10L);
        mesh.triangles().add(0L, 10L, 11L);
        mesh.triangles().add(1L, 5L, 9L);
        mesh.triangles().add(5L, 11L, 4L);
        mesh.triangles().add(11L, 10L, 2L);
        mesh.triangles().add(10L, 7L, 6L);
        mesh.triangles().add(7L, 1L, 8L);
        mesh.triangles().add(3L, 9L, 4L);
        mesh.triangles().add(3L, 4L, 2L);
        mesh.triangles().add(3L, 2L, 6L);
        mesh.triangles().add(3L, 6L, 8L);
        mesh.triangles().add(3L, 8L, 9L);
        mesh.triangles().add(4L, 9L, 5L);
        mesh.triangles().add(2L, 4L, 11L);
        mesh.triangles().add(6L, 2L, 10L);
        mesh.triangles().add(8L, 6L, 7L);
        mesh.triangles().add(9L, 8L, 1L);
        return mesh;
    }

    public static final BufferMesh refine(Mesh core) {
        int nVerticesOut = 6 * core.triangles().size();
        int nTrianglesOut = 4 * core.triangles().size();
        BufferMesh out = new BufferMesh(nVerticesOut, nTrianglesOut);
        double[] tmpIn = new double[3];
        double[] tmpOut = new double[3];
        for (Triangle t : core.triangles()) {
            long v0 = out.vertices().add(t.v0x(), t.v0y(), t.v0z());
            long v1 = out.vertices().add(t.v1x(), t.v1y(), t.v1z());
            long v2 = out.vertices().add(t.v2x(), t.v2y(), t.v2z());
            tmpIn[0] = 0.5 * (double)(t.v0xf() + t.v1xf());
            tmpIn[1] = 0.5 * (double)(t.v0yf() + t.v1yf());
            tmpIn[2] = 0.5 * (double)(t.v0zf() + t.v1zf());
            Icosahedron.normalize(tmpIn, tmpOut);
            long v3 = out.vertices().add(tmpOut[0], tmpOut[1], tmpOut[2]);
            tmpIn[0] = 0.5 * (double)(t.v2xf() + t.v1xf());
            tmpIn[1] = 0.5 * (double)(t.v2yf() + t.v1yf());
            tmpIn[2] = 0.5 * (double)(t.v2zf() + t.v1zf());
            Icosahedron.normalize(tmpIn, tmpOut);
            long v4 = out.vertices().add(tmpOut[0], tmpOut[1], tmpOut[2]);
            tmpIn[0] = 0.5 * (double)(t.v0xf() + t.v2xf());
            tmpIn[1] = 0.5 * (double)(t.v0yf() + t.v2yf());
            tmpIn[2] = 0.5 * (double)(t.v0zf() + t.v2zf());
            Icosahedron.normalize(tmpIn, tmpOut);
            long v5 = out.vertices().add(tmpOut[0], tmpOut[1], tmpOut[2]);
            out.triangles().add(v0, v3, v5);
            out.triangles().add(v3, v1, v4);
            out.triangles().add(v5, v4, v2);
            out.triangles().add(v3, v4, v5);
        }
        return out;
    }

    public static BufferMesh sphere(RealLocalizable center, double radius) {
        return Icosahedron.sphere(center, radius, 3);
    }

    public static BufferMesh sphere(RealLocalizable center, double radius, int nSubdivisions) {
        Mesh mesh = Icosahedron.core();
        for (int i = 0; i < nSubdivisions; ++i) {
            mesh = Icosahedron.refine(mesh);
        }
        Icosahedron.scale(mesh, center, radius);
        BufferMesh out = new BufferMesh(mesh.vertices().size(), mesh.triangles().size());
        Meshes.calculateNormals(mesh, out);
        return out;
    }

    private static void scale(Mesh mesh, RealLocalizable center, double radius) {
        long nV = mesh.vertices().size();
        int i = 0;
        while ((long)i < nV) {
            double x = mesh.vertices().x(i) * radius + center.getDoublePosition(0);
            double y = mesh.vertices().y(i) * radius + center.getDoublePosition(1);
            double z = mesh.vertices().z(i) * radius + center.getDoublePosition(2);
            mesh.vertices().set(i, x, y, z);
            ++i;
        }
    }

    private static void normalize(double[] v, double[] tmp) {
        double l = Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        tmp[0] = v[0] / l;
        tmp[1] = v[1] / l;
        tmp[2] = v[2] / l;
    }

    private Icosahedron() {
    }
}

