/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.view;

import java.util.Iterator;
import net.imglib2.RealLocalizable;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangles;
import net.imglib2.mesh.Vertex;
import net.imglib2.mesh.Vertices;

public class TranslateMesh
implements Mesh {
    private final Mesh in;
    private final TranslatedVertices vertices;

    public static final Mesh translate(Mesh in, RealLocalizable t) {
        return new TranslateMesh(in, t);
    }

    private TranslateMesh(Mesh in, RealLocalizable t) {
        this.in = in;
        this.vertices = new TranslatedVertices(in.vertices(), t);
    }

    @Override
    public Vertices vertices() {
        return this.vertices;
    }

    @Override
    public Triangles triangles() {
        return this.in.triangles();
    }

    private static final class TranslatedVertices
    implements Vertices {
        private final Vertices invs;
        private final RealLocalizable t;

        public TranslatedVertices(Vertices invs, RealLocalizable t) {
            this.invs = invs;
            this.t = t;
        }

        @Override
        public Iterator<Vertex> iterator() {
            return new Iterator<Vertex>(){
                private long index = -1L;
                private final Vertex vertex = new Vertex(){

                    @Override
                    public Mesh mesh() {
                        return this.mesh();
                    }

                    @Override
                    public long index() {
                        return index;
                    }

                    @Override
                    public double x() {
                        return this.x(this.index());
                    }

                    @Override
                    public double y() {
                        return this.y(this.index());
                    }

                    @Override
                    public double z() {
                        return this.z(this.index());
                    }

                    @Override
                    public float xf() {
                        return this.xf(this.index());
                    }

                    @Override
                    public float yf() {
                        return this.yf(this.index());
                    }

                    @Override
                    public float zf() {
                        return this.zf(this.index());
                    }
                };

                @Override
                public boolean hasNext() {
                    return this.index + 1L < this.sizel();
                }

                @Override
                public Vertex next() {
                    ++this.index;
                    return this.vertex;
                }
            };
        }

        @Override
        public Mesh mesh() {
            return this.invs.mesh();
        }

        @Override
        public long sizel() {
            return this.invs.sizel();
        }

        @Override
        public float xf(long vIndex) {
            return this.invs.xf(vIndex) + this.t.getFloatPosition(0);
        }

        @Override
        public double x(long vIndex) {
            return this.invs.x(vIndex) + this.t.getDoublePosition(0);
        }

        @Override
        public float yf(long vIndex) {
            return this.invs.yf(vIndex) + this.t.getFloatPosition(1);
        }

        @Override
        public double y(long vIndex) {
            return this.invs.y(vIndex) + this.t.getDoublePosition(1);
        }

        @Override
        public float zf(long vIndex) {
            return this.invs.zf(vIndex) + this.t.getFloatPosition(2);
        }

        @Override
        public double z(long vIndex) {
            return this.invs.z(vIndex) + this.t.getDoublePosition(2);
        }

        @Override
        public float nxf(long vIndex) {
            return this.invs.nxf(vIndex);
        }

        @Override
        public float nyf(long vIndex) {
            return this.invs.nyf(vIndex);
        }

        @Override
        public float nzf(long vIndex) {
            return this.invs.nzf(vIndex);
        }

        @Override
        public float uf(long vIndex) {
            return this.invs.uf(vIndex);
        }

        @Override
        public float vf(long vIndex) {
            return this.invs.vf(vIndex);
        }

        @Override
        public long addf(float x, float y, float z, float nx, float ny, float nz, float u, float v) {
            throw new IllegalArgumentException("The position of mesh views are not modifiable.");
        }

        @Override
        public void setf(long vIndex, float x, float y, float z, float nx, float ny, float nz, float u, float v) {
            throw new IllegalArgumentException("The position of mesh views are not modifiable.");
        }

        @Override
        public void setf(long vIndex, float x, float y, float z) {
            throw new IllegalArgumentException("The position of mesh views are not modifiable.");
        }

        @Override
        public void set(long vIndex, double x, double y, double z) {
            throw new IllegalArgumentException("The position of mesh views are not modifiable.");
        }

        @Override
        public void set(long vIndex, double x, double y, double z, double nx, double ny, double nz, double u, double v) {
            throw new IllegalArgumentException("The position of mesh views are not modifiable.");
        }

        @Override
        public void setPositionf(long vIndex, float x, float y, float z) {
            throw new IllegalArgumentException("The position of mesh views are not modifiable.");
        }

        @Override
        public void setPosition(long vIndex, double x, double y, double z) {
            throw new IllegalArgumentException("The position of mesh views are not modifiable.");
        }

        @Override
        public void setNormalf(long vIndex, float nx, float ny, float nz) {
            this.invs.setNormalf(vIndex, nx, ny, nz);
        }

        @Override
        public void setTexturef(long vIndex, float u, float v) {
            this.invs.setTexturef(vIndex, u, v);
        }
    }
}

