/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.roi.Masks;
import net.imglib2.roi.RealMask;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ops.flim.FitParams;

public class ParamEstimator<I extends RealType<I>> {
    private static final float SAMPLE_RATE = 0.05f;
    private static final float END_PERSENTAGE = 0.9f;
    private final FitParams<I> params;
    private final Img<FloatType> iMap;
    private final List<int[]> pos;
    private final int lifetimeAxis;
    private final int nData;
    private final int nTrans;
    private final float[] sumAcrossTrans;
    private final float[] iSmpls;

    public ParamEstimator(FitParams<I> params, List<int[]> pos) {
        this.params = params;
        this.pos = pos;
        this.lifetimeAxis = params.ltAxis;
        this.nData = (int)params.transMap.dimension(this.lifetimeAxis);
        this.nTrans = pos.size();
        this.iSmpls = params.iThreshPercent > 0.0f && params.iThresh <= 0.0f ? new float[(int)Math.max((float)this.nTrans * 0.05f, 1.0f)] : null;
        this.sumAcrossTrans = new float[this.nData];
        this.iMap = this.calcIMap();
    }

    public ParamEstimator(FitParams<I> params) {
        this(params, ParamEstimator.getRoiPositions(params.transMap, params.roiMask == null ? Masks.allRealMask((int)0) : params.roiMask, params.ltAxis));
    }

    public void estimateStartEnd() {
        if (this.params.fitStart < 0) {
            int max_idx = 0;
            for (int t = 0; t < this.sumAcrossTrans.length; ++t) {
                max_idx = this.sumAcrossTrans[t] > this.sumAcrossTrans[max_idx] ? t : max_idx;
            }
            this.params.fitStart = max_idx;
        }
        if (this.params.fitEnd < 0 || this.params.fitEnd <= this.params.fitStart) {
            this.params.fitEnd = (int)((float)this.params.fitStart + (float)(this.nData - this.params.fitStart) * 0.9f);
        }
    }

    public void estimateIThreshold() {
        if (this.iSmpls != null) {
            Arrays.sort(this.iSmpls);
            this.params.iThreshPercent = Math.min(this.params.iThreshPercent, 100.0f);
            this.params.iThresh = this.iSmpls[(int)((double)this.params.iThreshPercent / 100.0 * (double)(this.iSmpls.length - 1))];
        }
    }

    public Img<FloatType> getIntensityMap() {
        return this.iMap;
    }

    private Img<FloatType> calcIMap() {
        long[] dimFit = new long[this.params.transMap.numDimensions()];
        this.params.transMap.dimensions(dimFit);
        dimFit[this.lifetimeAxis] = 1L;
        ArrayImg iMap = ArrayImgs.floats((long[])dimFit);
        RandomAccess transRA = this.params.transMap.randomAccess();
        RandomAccess iMapRA = iMap.randomAccess();
        int iSmplCnt = 0;
        for (int i = 0; i < this.pos.size(); ++i) {
            int[] xytPos = this.pos.get(i);
            transRA.setPosition(xytPos);
            float intensity = 0.0f;
            int t = 0;
            while (t < this.nData) {
                float count = ((RealType)transRA.get()).getRealFloat();
                intensity += count;
                int n = t++;
                this.sumAcrossTrans[n] = this.sumAcrossTrans[n] + count;
                transRA.fwd(this.lifetimeAxis);
            }
            if (this.iSmpls != null && (float)(iSmplCnt + 1) <= (float)i * 0.05f) {
                this.iSmpls[iSmplCnt++] = intensity;
            }
            iMapRA.setPosition(xytPos);
            ((FloatType)iMapRA.get()).set(intensity);
        }
        return iMap;
    }

    private static <I> List<int[]> getRoiPositions(RandomAccessibleInterval<I> trans, RealMask mask, int lifetimeAxis) {
        ArrayList<int[]> interested = new ArrayList<int[]>();
        IntervalView xyPlane = Views.hyperSlice(trans, (int)lifetimeAxis, (long)0L);
        Cursor xyCursor = xyPlane.localizingCursor();
        while (xyCursor.hasNext()) {
            xyCursor.fwd();
            if (!mask.test((Object)xyCursor)) continue;
            int[] pos = new int[3];
            xyCursor.localize(pos);
            for (int i = 2; i > lifetimeAxis; --i) {
                int tmp = pos[i];
                pos[i] = pos[i - 1];
                pos[i - 1] = tmp;
            }
            pos[lifetimeAxis] = 0;
            interested.add(pos);
        }
        return interested;
    }
}

