/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim.impl;

import flimlib.FLIMLib;
import flimlib.RestrainType;
import java.util.Arrays;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.flim.FitParams;
import org.scijava.ops.flim.FitResults;
import org.scijava.ops.flim.FitWorker;

public abstract class AbstractFitWorker<I extends RealType<I>>
implements FitWorker<I> {
    protected final FitParams<I> params;
    protected final FitResults results;
    protected final int nData;
    protected final int nParam;
    protected int adjFitStart;
    protected int adjFitEnd;
    protected int nDataTotal;
    protected float rawChisq_target;

    public AbstractFitWorker(FitParams<I> params, FitResults results) {
        int fillStart;
        this.params = params;
        this.results = results;
        this.nData = this.nDataOut();
        this.nParam = this.nParamOut();
        if (params.paramFree == null) {
            params.paramFree = new boolean[this.nParam];
            fillStart = 0;
        } else if (params.paramFree.length < this.nParam) {
            fillStart = params.paramFree.length;
            params.paramFree = Arrays.copyOf(params.paramFree, this.nParam);
        } else {
            fillStart = params.paramFree.length;
        }
        for (int i = fillStart; i < params.paramFree.length; ++i) {
            params.paramFree[i] = true;
        }
        this.populate();
    }

    public void populate() {
        int instrLen = this.params.instr == null ? 0 : this.params.instr.length;
        int prefixLen = Math.min(instrLen, this.params.fitStart);
        int suffixLen = Math.min(instrLen, (int)this.params.transMap.dimension(this.params.ltAxis) - this.params.fitEnd);
        this.nDataTotal = prefixLen + this.nData + suffixLen;
        this.adjFitStart = prefixLen;
        this.adjFitEnd = this.adjFitStart + this.nData;
        this.rawChisq_target = this.params.chisq_target * (float)(this.nData - this.nParam);
        this.results.ltAxis = this.params.ltAxis;
        if (this.params.restrain.equals((Object)RestrainType.ECF_RESTRAIN_USER) && (this.params.restraintMin != null || this.params.restraintMax != null)) {
            boolean[] restrain = new boolean[this.nParam];
            float[] rMinOrig = this.params.restraintMin;
            float[] rMaxOrig = this.params.restraintMax;
            float[] rMin = new float[this.nParam];
            float[] rMax = new float[this.nParam];
            for (int i = 0; i < restrain.length; ++i) {
                boolean restrainCurrent = false;
                if (rMinOrig != null && i < rMinOrig.length && !Float.isNaN(rMinOrig[i])) {
                    rMin[i] = rMinOrig[i];
                    restrainCurrent = true;
                } else {
                    rMin[i] = Float.NEGATIVE_INFINITY;
                }
                if (rMaxOrig != null && i < rMaxOrig.length && !Float.isNaN(rMaxOrig[i])) {
                    rMax[i] = rMaxOrig[i];
                    restrainCurrent = true;
                } else {
                    rMax[i] = Float.POSITIVE_INFINITY;
                }
                restrain[i] = restrainCurrent;
            }
            FLIMLib.GCI_set_restrain_limits((boolean[])restrain, (float[])rMin, (float[])rMax);
        }
    }

    @Override
    public int nParamOut() {
        return this.params.nComp * 2 + 1;
    }

    @Override
    public int nDataOut() {
        return this.params.fitEnd - this.params.fitStart;
    }
}

