/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim.impl;

import flimlib.FLIMLib;
import flimlib.FitFunc;
import flimlib.Float2DMatrix;
import flimlib.NoiseType;
import flimlib.RestrainType;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.flim.AbstractFitRAI;
import org.scijava.ops.flim.FitParams;
import org.scijava.ops.flim.FitResults;
import org.scijava.ops.flim.FitWorker;
import org.scijava.ops.flim.impl.AbstractSingleFitWorker;
import org.scijava.ops.flim.impl.RLDFit;

public class LMAFit {

    public static class LMAFitWorker<I extends RealType<I>>
    extends AbstractSingleFitWorker<I> {
        private final Float2DMatrix covar;
        private final Float2DMatrix alpha;
        private final Float2DMatrix erraxes;
        private final RLDFit.RLDFitWorker<I> estimatorWorker;

        public LMAFitWorker(FitParams<I> params, FitResults results) {
            super(params, results);
            this.covar = new Float2DMatrix(this.nParam, this.nParam);
            this.alpha = new Float2DMatrix(this.nParam, this.nParam);
            this.erraxes = new Float2DMatrix(this.nParam, this.nParam);
            this.estimatorWorker = new RLDFit.RLDFitWorker<I>(params, results);
        }

        @Override
        protected void beforeFit() {
            for (float param : this.paramBuffer) {
                if (param != Float.POSITIVE_INFINITY) continue;
                this.estimatorWorker.fitSingle();
                break;
            }
            super.beforeFit();
        }

        @Override
        public void doFit() {
            int retCode = FLIMLib.GCI_marquardt_fitting_engine((float)this.params.xInc, (float[])this.transBuffer, (int)this.adjFitStart, (int)this.adjFitEnd, (float[])this.params.instr, (NoiseType)this.params.noise, (float[])this.params.sig, (float[])this.paramBuffer, (boolean[])this.params.paramFree, (RestrainType)this.params.restrain, (FitFunc)this.params.fitFunc, (float[])this.fittedBuffer, (float[])this.residualBuffer, (float[])this.chisqBuffer, (Float2DMatrix)this.covar, (Float2DMatrix)this.alpha, (Float2DMatrix)this.erraxes, (float)this.rawChisq_target, (float)this.params.chisq_delta, (int)this.params.chisq_percent);
            switch (retCode) {
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    this.results.retCode = -1;
                    break;
                }
                default: {
                    this.results.retCode = retCode >= 0 ? 0 : -6;
                }
            }
        }

        @Override
        protected AbstractSingleFitWorker<I> duplicate(FitParams<I> params, FitResults rslts) {
            return new LMAFitWorker<I>(params, rslts);
        }
    }

    public static class LMASingleFitRAI<I extends RealType<I>, K extends RealType<K>>
    extends AbstractFitRAI<I, K> {
        @Override
        public FitWorker<I> createWorker(FitParams<I> params, FitResults results) {
            return new LMAFitWorker<I>(params, results);
        }
    }
}

