/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim.impl;

import flimlib.FLIMLib;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.flim.AbstractFitRAI;
import org.scijava.ops.flim.FitParams;
import org.scijava.ops.flim.FitResults;
import org.scijava.ops.flim.FitWorker;
import org.scijava.ops.flim.impl.AbstractSingleFitWorker;

public class PhasorFit {

    public static class PhasorFitWorker<I extends RealType<I>>
    extends AbstractSingleFitWorker<I> {
        private static final int NPARAMOUT = 6;
        private final float[] z = new float[1];
        private final float[] u = new float[1];
        private final float[] v = new float[1];
        private final float[] tau;
        private final float[] tauPhi = new float[1];
        private final float[] tauMod = new float[1];

        public PhasorFitWorker(FitParams<I> params, FitResults results) {
            super(params, results);
            this.tau = new float[1];
        }

        @Override
        protected void beforeFit() {
            for (int i = 0; i < this.paramBuffer.length; ++i) {
                if (this.paramBuffer[i] != Float.POSITIVE_INFINITY) continue;
                this.paramBuffer[i] = 0.0f;
            }
            super.beforeFit();
            this.z[0] = this.paramBuffer[0];
            this.u[0] = this.paramBuffer[1];
            this.v[0] = this.paramBuffer[2];
            this.tauPhi[0] = this.paramBuffer[3];
            this.tauMod[0] = this.paramBuffer[4];
            this.tau[0] = this.paramBuffer[5];
        }

        @Override
        protected void doFit() {
            int retCode = FLIMLib.GCI_Phasor((float)this.params.xInc, (float[])this.transBuffer, (int)this.adjFitStart, (int)this.adjFitEnd, (float[])this.z, (float[])this.u, (float[])this.v, (float[])this.tauPhi, (float[])this.tauMod, (float[])this.tau, (float[])this.fittedBuffer, (float[])this.residualBuffer, (float[])this.chisqBuffer);
            switch (retCode) {
                case -2: 
                case -1: {
                    this.results.retCode = -3;
                    break;
                }
                default: {
                    this.results.retCode = retCode >= 0 ? 0 : -6;
                }
            }
        }

        @Override
        protected void afterFit() {
            this.paramBuffer[0] = this.z[0];
            this.paramBuffer[1] = this.u[0];
            this.paramBuffer[2] = this.v[0];
            this.paramBuffer[3] = this.tauPhi[0];
            this.paramBuffer[4] = this.tauMod[0];
            this.paramBuffer[5] = this.tau[0];
            super.afterFit();
        }

        @Override
        public int nParamOut() {
            return 6;
        }

        @Override
        protected AbstractSingleFitWorker<I> duplicate(FitParams<I> params, FitResults rslts) {
            return new PhasorFitWorker<I>(params, rslts);
        }
    }

    public static class PhasorSingleFitRAI<I extends RealType<I>, K extends RealType<K>>
    extends AbstractFitRAI<I, K> {
        @Override
        public FitWorker<I> createWorker(FitParams<I> params, FitResults results) {
            return new PhasorFitWorker<I>(params, results);
        }
    }
}

