/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.resourcemanager.v3.CreateFolderMetadata;
import com.google.cloud.resourcemanager.v3.CreateFolderRequest;
import com.google.cloud.resourcemanager.v3.DeleteFolderMetadata;
import com.google.cloud.resourcemanager.v3.DeleteFolderRequest;
import com.google.cloud.resourcemanager.v3.Folder;
import com.google.cloud.resourcemanager.v3.FolderName;
import com.google.cloud.resourcemanager.v3.FoldersSettings;
import com.google.cloud.resourcemanager.v3.GetFolderRequest;
import com.google.cloud.resourcemanager.v3.ListFoldersRequest;
import com.google.cloud.resourcemanager.v3.ListFoldersResponse;
import com.google.cloud.resourcemanager.v3.MoveFolderMetadata;
import com.google.cloud.resourcemanager.v3.MoveFolderRequest;
import com.google.cloud.resourcemanager.v3.SearchFoldersRequest;
import com.google.cloud.resourcemanager.v3.SearchFoldersResponse;
import com.google.cloud.resourcemanager.v3.UndeleteFolderMetadata;
import com.google.cloud.resourcemanager.v3.UndeleteFolderRequest;
import com.google.cloud.resourcemanager.v3.UpdateFolderMetadata;
import com.google.cloud.resourcemanager.v3.UpdateFolderRequest;
import com.google.cloud.resourcemanager.v3.stub.FoldersStub;
import com.google.cloud.resourcemanager.v3.stub.FoldersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FoldersClient
implements BackgroundResource {
    private final FoldersSettings settings;
    private final FoldersStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final FoldersClient create() throws IOException {
        return FoldersClient.create(FoldersSettings.newBuilder().build());
    }

    public static final FoldersClient create(FoldersSettings settings) throws IOException {
        return new FoldersClient(settings);
    }

    public static final FoldersClient create(FoldersStub stub) {
        return new FoldersClient(stub);
    }

    protected FoldersClient(FoldersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FoldersStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected FoldersClient(FoldersStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final FoldersSettings getSettings() {
        return this.settings;
    }

    public FoldersStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Folder getFolder(FolderName name) {
        GetFolderRequest request = GetFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFolder(request);
    }

    public final Folder getFolder(String name) {
        GetFolderRequest request = GetFolderRequest.newBuilder().setName(name).build();
        return this.getFolder(request);
    }

    public final Folder getFolder(GetFolderRequest request) {
        return (Folder)this.getFolderCallable().call((Object)request);
    }

    public final UnaryCallable<GetFolderRequest, Folder> getFolderCallable() {
        return this.stub.getFolderCallable();
    }

    public final ListFoldersPagedResponse listFolders(ResourceName parent) {
        ListFoldersRequest request = ListFoldersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFolders(request);
    }

    public final ListFoldersPagedResponse listFolders(String parent) {
        ListFoldersRequest request = ListFoldersRequest.newBuilder().setParent(parent).build();
        return this.listFolders(request);
    }

    public final ListFoldersPagedResponse listFolders(ListFoldersRequest request) {
        return (ListFoldersPagedResponse)((Object)this.listFoldersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFoldersRequest, ListFoldersPagedResponse> listFoldersPagedCallable() {
        return this.stub.listFoldersPagedCallable();
    }

    public final UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable() {
        return this.stub.listFoldersCallable();
    }

    public final SearchFoldersPagedResponse searchFolders(String query) {
        SearchFoldersRequest request = SearchFoldersRequest.newBuilder().setQuery(query).build();
        return this.searchFolders(request);
    }

    public final SearchFoldersPagedResponse searchFolders(SearchFoldersRequest request) {
        return (SearchFoldersPagedResponse)((Object)this.searchFoldersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchFoldersRequest, SearchFoldersPagedResponse> searchFoldersPagedCallable() {
        return this.stub.searchFoldersPagedCallable();
    }

    public final UnaryCallable<SearchFoldersRequest, SearchFoldersResponse> searchFoldersCallable() {
        return this.stub.searchFoldersCallable();
    }

    public final OperationFuture<Folder, CreateFolderMetadata> createFolderAsync(Folder folder) {
        CreateFolderRequest request = CreateFolderRequest.newBuilder().setFolder(folder).build();
        return this.createFolderAsync(request);
    }

    public final OperationFuture<Folder, CreateFolderMetadata> createFolderAsync(CreateFolderRequest request) {
        return this.createFolderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFolderRequest, Folder, CreateFolderMetadata> createFolderOperationCallable() {
        return this.stub.createFolderOperationCallable();
    }

    public final UnaryCallable<CreateFolderRequest, Operation> createFolderCallable() {
        return this.stub.createFolderCallable();
    }

    public final OperationFuture<Folder, UpdateFolderMetadata> updateFolderAsync(Folder folder, FieldMask updateMask) {
        UpdateFolderRequest request = UpdateFolderRequest.newBuilder().setFolder(folder).setUpdateMask(updateMask).build();
        return this.updateFolderAsync(request);
    }

    public final OperationFuture<Folder, UpdateFolderMetadata> updateFolderAsync(UpdateFolderRequest request) {
        return this.updateFolderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateFolderRequest, Folder, UpdateFolderMetadata> updateFolderOperationCallable() {
        return this.stub.updateFolderOperationCallable();
    }

    public final UnaryCallable<UpdateFolderRequest, Operation> updateFolderCallable() {
        return this.stub.updateFolderCallable();
    }

    public final OperationFuture<Folder, MoveFolderMetadata> moveFolderAsync(FolderName name, ResourceName destinationParent) {
        MoveFolderRequest request = MoveFolderRequest.newBuilder().setName(name == null ? null : name.toString()).setDestinationParent(destinationParent == null ? null : destinationParent.toString()).build();
        return this.moveFolderAsync(request);
    }

    public final OperationFuture<Folder, MoveFolderMetadata> moveFolderAsync(FolderName name, String destinationParent) {
        MoveFolderRequest request = MoveFolderRequest.newBuilder().setName(name == null ? null : name.toString()).setDestinationParent(destinationParent).build();
        return this.moveFolderAsync(request);
    }

    public final OperationFuture<Folder, MoveFolderMetadata> moveFolderAsync(String name, ResourceName destinationParent) {
        MoveFolderRequest request = MoveFolderRequest.newBuilder().setName(name).setDestinationParent(destinationParent == null ? null : destinationParent.toString()).build();
        return this.moveFolderAsync(request);
    }

    public final OperationFuture<Folder, MoveFolderMetadata> moveFolderAsync(String name, String destinationParent) {
        MoveFolderRequest request = MoveFolderRequest.newBuilder().setName(name).setDestinationParent(destinationParent).build();
        return this.moveFolderAsync(request);
    }

    public final OperationFuture<Folder, MoveFolderMetadata> moveFolderAsync(MoveFolderRequest request) {
        return this.moveFolderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<MoveFolderRequest, Folder, MoveFolderMetadata> moveFolderOperationCallable() {
        return this.stub.moveFolderOperationCallable();
    }

    public final UnaryCallable<MoveFolderRequest, Operation> moveFolderCallable() {
        return this.stub.moveFolderCallable();
    }

    public final OperationFuture<Folder, DeleteFolderMetadata> deleteFolderAsync(FolderName name) {
        DeleteFolderRequest request = DeleteFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFolderAsync(request);
    }

    public final OperationFuture<Folder, DeleteFolderMetadata> deleteFolderAsync(String name) {
        DeleteFolderRequest request = DeleteFolderRequest.newBuilder().setName(name).build();
        return this.deleteFolderAsync(request);
    }

    public final OperationFuture<Folder, DeleteFolderMetadata> deleteFolderAsync(DeleteFolderRequest request) {
        return this.deleteFolderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFolderRequest, Folder, DeleteFolderMetadata> deleteFolderOperationCallable() {
        return this.stub.deleteFolderOperationCallable();
    }

    public final UnaryCallable<DeleteFolderRequest, Operation> deleteFolderCallable() {
        return this.stub.deleteFolderCallable();
    }

    public final OperationFuture<Folder, UndeleteFolderMetadata> undeleteFolderAsync(FolderName name) {
        UndeleteFolderRequest request = UndeleteFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeleteFolderAsync(request);
    }

    public final OperationFuture<Folder, UndeleteFolderMetadata> undeleteFolderAsync(String name) {
        UndeleteFolderRequest request = UndeleteFolderRequest.newBuilder().setName(name).build();
        return this.undeleteFolderAsync(request);
    }

    public final OperationFuture<Folder, UndeleteFolderMetadata> undeleteFolderAsync(UndeleteFolderRequest request) {
        return this.undeleteFolderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeleteFolderRequest, Folder, UndeleteFolderMetadata> undeleteFolderOperationCallable() {
        return this.stub.undeleteFolderOperationCallable();
    }

    public final UnaryCallable<UndeleteFolderRequest, Operation> undeleteFolderCallable() {
        return this.stub.undeleteFolderCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchFoldersFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchFoldersRequest, SearchFoldersResponse, Folder, SearchFoldersPage, SearchFoldersFixedSizeCollection> {
        private SearchFoldersFixedSizeCollection(List<SearchFoldersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchFoldersFixedSizeCollection createEmptyCollection() {
            return new SearchFoldersFixedSizeCollection(null, 0);
        }

        protected SearchFoldersFixedSizeCollection createCollection(List<SearchFoldersPage> pages, int collectionSize) {
            return new SearchFoldersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchFoldersPage
    extends AbstractPage<SearchFoldersRequest, SearchFoldersResponse, Folder, SearchFoldersPage> {
        private SearchFoldersPage(PageContext<SearchFoldersRequest, SearchFoldersResponse, Folder> context, SearchFoldersResponse response) {
            super(context, (Object)response);
        }

        private static SearchFoldersPage createEmptyPage() {
            return new SearchFoldersPage(null, null);
        }

        protected SearchFoldersPage createPage(PageContext<SearchFoldersRequest, SearchFoldersResponse, Folder> context, SearchFoldersResponse response) {
            return new SearchFoldersPage(context, response);
        }

        public ApiFuture<SearchFoldersPage> createPageAsync(PageContext<SearchFoldersRequest, SearchFoldersResponse, Folder> context, ApiFuture<SearchFoldersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchFoldersPagedResponse
    extends AbstractPagedListResponse<SearchFoldersRequest, SearchFoldersResponse, Folder, SearchFoldersPage, SearchFoldersFixedSizeCollection> {
        public static ApiFuture<SearchFoldersPagedResponse> createAsync(PageContext<SearchFoldersRequest, SearchFoldersResponse, Folder> context, ApiFuture<SearchFoldersResponse> futureResponse) {
            ApiFuture<SearchFoldersPage> futurePage = SearchFoldersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchFoldersPagedResponse((SearchFoldersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchFoldersPagedResponse(SearchFoldersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchFoldersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFoldersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFoldersRequest, ListFoldersResponse, Folder, ListFoldersPage, ListFoldersFixedSizeCollection> {
        private ListFoldersFixedSizeCollection(List<ListFoldersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFoldersFixedSizeCollection createEmptyCollection() {
            return new ListFoldersFixedSizeCollection(null, 0);
        }

        protected ListFoldersFixedSizeCollection createCollection(List<ListFoldersPage> pages, int collectionSize) {
            return new ListFoldersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFoldersPage
    extends AbstractPage<ListFoldersRequest, ListFoldersResponse, Folder, ListFoldersPage> {
        private ListFoldersPage(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ListFoldersResponse response) {
            super(context, (Object)response);
        }

        private static ListFoldersPage createEmptyPage() {
            return new ListFoldersPage(null, null);
        }

        protected ListFoldersPage createPage(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ListFoldersResponse response) {
            return new ListFoldersPage(context, response);
        }

        public ApiFuture<ListFoldersPage> createPageAsync(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ApiFuture<ListFoldersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFoldersPagedResponse
    extends AbstractPagedListResponse<ListFoldersRequest, ListFoldersResponse, Folder, ListFoldersPage, ListFoldersFixedSizeCollection> {
        public static ApiFuture<ListFoldersPagedResponse> createAsync(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ApiFuture<ListFoldersResponse> futureResponse) {
            ApiFuture<ListFoldersPage> futurePage = ListFoldersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFoldersPagedResponse((ListFoldersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFoldersPagedResponse(ListFoldersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFoldersFixedSizeCollection.createEmptyCollection());
        }
    }
}

