/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import levelsets.algorithm.DeferredArray3D;

public class DeferredDoubleArray3D
extends DeferredArray3D {
    double defaultval = 0.0;

    public DeferredDoubleArray3D(int xdim, int ydim, int zdim, int tilesize, double defaultval) {
        super(xdim, ydim, zdim, tilesize);
        this.defaultval = defaultval;
    }

    public final void set(int x, int y, int z, double value) {
        double[][][] tile = (double[][][])this.getTile(x, y, z, true);
        tile[x % this.tilesize][y % this.tilesize][z % this.tilesize] = value;
    }

    public final double get(int x, int y, int z) {
        double[][][] tile = (double[][][])this.getTile(x, y, z, false);
        if (tile == null) {
            return this.defaultval;
        }
        return tile[x % this.tilesize][y % this.tilesize][z % this.tilesize];
    }

    @Override
    public final String getAsString(int x, int y, int z) {
        return Double.toString(this.get(x, y, z));
    }

    @Override
    protected final Object createTile(int tilesize) {
        double[][][] tile = new double[tilesize][tilesize][tilesize];
        if (this.defaultval != 0.0) {
            for (int x = 0; x < tile.length; ++x) {
                for (int y = 0; y < tile[0].length; ++y) {
                    for (int z = 0; z < tile[0][0].length; ++z) {
                        tile[x][y][z] = this.defaultval;
                    }
                }
            }
        }
        return tile;
    }
}

