/*
 * Decompiled with CFR 0.152.
 */
package levelsets.filter;

import ij.process.ShortProcessor;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferUShort;
import java.awt.image.Kernel;
import levelsets.filter.Filter;

public class SimpleEdgeDetect
implements Filter {
    final float[] edgeKernel = new float[]{2.0f, -4.0f, 2.0f, -4.0f, 8.0f, -4.0f, 2.0f, -4.0f, 2.0f};

    @Override
    public final BufferedImage filter(BufferedImage input) {
        ConvolveOp edge = new ConvolveOp(new Kernel(3, 3, this.edgeKernel));
        ColorModel cm = input.getColorModel();
        BufferedImage srccpy = edge.createCompatibleDestImage(input, cm);
        input.copyData(srccpy.getRaster());
        BufferedImage result = edge.createCompatibleDestImage(input, cm);
        return edge.filter(srccpy, result);
    }

    @Override
    public void filter(int width, int height, short[] source, short[] target) {
        ShortProcessor sp = new ShortProcessor(width, height, source, null);
        BufferedImage bi = this.filter(sp.get16BitBufferedImage());
        DataBufferUShort db = (DataBufferUShort)bi.getData().getDataBuffer();
        System.arraycopy(target, 0, db.getData(), 0, target.length);
    }
}

