/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import com.google.common.collect.TreeMultimap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.scijava.common3.Any;
import org.scijava.common3.Types;
import org.scijava.discovery.Discoverer;
import org.scijava.discovery.ManualDiscoverer;
import org.scijava.meta.Versions;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpHistory;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpInstance;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.api.OpRequest;
import org.scijava.ops.api.RichOp;
import org.scijava.ops.engine.DependencyMatchingException;
import org.scijava.ops.engine.InfoTreeGenerator;
import org.scijava.ops.engine.MatchingConditions;
import org.scijava.ops.engine.OpDependencyMember;
import org.scijava.ops.engine.OpDescriptionGenerator;
import org.scijava.ops.engine.OpInfoGenerator;
import org.scijava.ops.engine.OpWrapper;
import org.scijava.ops.engine.impl.DependencyRichOpInfoTree;
import org.scijava.ops.engine.impl.LambdaTypeBaker;
import org.scijava.ops.engine.matcher.MatchingRoutine;
import org.scijava.ops.engine.matcher.OpCandidate;
import org.scijava.ops.engine.matcher.OpMatcher;
import org.scijava.ops.engine.matcher.impl.DefaultOpClassInfo;
import org.scijava.ops.engine.matcher.impl.DefaultOpMatcher;
import org.scijava.ops.engine.matcher.impl.DefaultOpRequest;
import org.scijava.ops.engine.matcher.impl.InfoMatchingOpRequest;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.FunctionalParameters;
import org.scijava.ops.engine.util.Infos;
import org.scijava.ops.spi.Op;
import org.scijava.ops.spi.OpCollection;
import org.scijava.struct.ItemIO;
import org.scijava.types.Nil;
import org.scijava.types.extract.DefaultTypeReifier;
import org.scijava.types.extract.TypeReifier;
import org.scijava.types.infer.GenericAssignability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpEnvironment
implements OpEnvironment {
    private final Discoverer metaDiscoverer = Discoverer.union((Iterable)Discoverer.all(ServiceLoader::load));
    private final List<Discoverer> discoverers = new ArrayList<Discoverer>();
    private final ManualDiscoverer manDiscoverer = new ManualDiscoverer();
    private final OpMatcher matcher;
    private final TypeReifier typeReifier;
    private final OpHistory history;
    private final TreeMultimap<String, OpInfo> opDirectory = TreeMultimap.create();
    private Map<String, OpInfo> idDirectory;
    private final Map<MatchingConditions, OpInstance<?>> opCache = new HashMap();
    private Map<Class<?>, OpWrapper<?>> wrappers;
    private Hints environmentHints = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Consumer<OpInfo> addToOpIndex = opInfo -> {
        if (opInfo.names() == null || opInfo.names().isEmpty()) {
            this.log.error("Skipping Op " + opInfo.implementationName() + ":\nOp implementation must provide name.");
            return;
        }
        for (String opName : opInfo.names()) {
            this.opDirectory.put((Object)opName, opInfo);
        }
    };

    public DefaultOpEnvironment() {
        this(new Discoverer[0]);
    }

    public DefaultOpEnvironment(Discoverer ... discoverers) {
        this.typeReifier = new DefaultTypeReifier(new Discoverer[]{this.metaDiscoverer});
        this.history = OpHistory.getOpHistory();
        this.matcher = new DefaultOpMatcher(this.metaDiscoverer.discover(MatchingRoutine.class));
        this.discoverUsing(discoverers);
        this.discoverUsing(new Discoverer[]{this.manDiscoverer});
    }

    public OpHistory history() {
        return this.history;
    }

    public SortedSet<OpInfo> infos() {
        return new TreeSet<OpInfo>(this.opDirectory.values());
    }

    public SortedSet<OpInfo> infos(String name) {
        if (name == null || name.isEmpty()) {
            return this.infos();
        }
        return this.opsOfName(name);
    }

    public SortedSet<OpInfo> infos(Hints hints) {
        return this.filterInfos(this.infos(), hints);
    }

    public SortedSet<OpInfo> infos(String name, Hints hints) {
        return this.filterInfos(this.infos(name), hints);
    }

    public void discoverUsing(Discoverer ... arr) {
        for (Discoverer d : arr) {
            this.discoverers.add(d);
            d.discover(OpInfo.class).forEach(this::registerInfosFrom);
            d.discover(Op.class).forEach(this::registerInfosFrom);
            d.discover(OpCollection.class).forEach(this::registerInfosFrom);
        }
    }

    public void discoverEverything() {
        this.discoverUsing(this.metaDiscoverer);
    }

    private SortedSet<OpInfo> filterInfos(SortedSet<OpInfo> infos, Hints hints) {
        boolean adapting = hints.contains("adaptation.IN_PROGRESS");
        boolean converting = hints.contains("conversion.IN_PROGRESS");
        boolean depMatching = hints.contains("dependencyMatching.IN_PROGRESS");
        if (!(adapting || converting || depMatching)) {
            return infos;
        }
        return infos.stream().filter(info -> !adapting || !info.declaredHints().contains("adaptation.FORBIDDEN")).filter(info -> !converting || !info.declaredHints().contains("conversion.FORBIDDEN")).filter(info -> !depMatching || !info.declaredHints().contains("dependencyMatching.FORBIDDEN")).collect(Collectors.toCollection(TreeSet::new));
    }

    public <T> T op(String opName, Nil<T> specialType, Nil<?>[] inTypes, Nil<?> outType, Hints hints) {
        return (T)this.findOp(opName, specialType, inTypes, outType, hints).asOpType();
    }

    public <T> T opFromInfoTree(InfoTree tree, Nil<T> specialType, Hints hints) {
        if (!(specialType.type() instanceof ParameterizedType)) {
            throw new IllegalArgumentException("TODO");
        }
        OpInstance instance = tree.newInstance(specialType.type());
        MatchingConditions conditions = MatchingConditions.from(new InfoMatchingOpRequest(tree.info(), Nil.of((Type)tree.info().opType())), hints);
        RichOp<T> wrappedOp = this.wrapOp(instance, conditions);
        return (T)wrappedOp.asOpType();
    }

    public InfoTree treeFromSignature(String signature) {
        if (this.idDirectory == null) {
            this.initIdDirectory();
        }
        List<InfoTreeGenerator> infoTreeGenerators = this.discoverers.stream().flatMap(d -> d.discover(InfoTreeGenerator.class).stream()).collect(Collectors.toList());
        InfoTreeGenerator genOpt = InfoTreeGenerator.findSuitableGenerator(signature, infoTreeGenerators);
        return genOpt.generate(this, signature, this.idDirectory, infoTreeGenerators);
    }

    public Type genericType(Object obj) {
        return this.typeReifier.reify(obj);
    }

    public OpInfo opify(Class<?> opClass, double priority, String ... names) {
        return new DefaultOpClassInfo(opClass, Versions.of(opClass), "", new Hints(new String[0]), priority, names);
    }

    public <T> T typeLambda(Nil<T> opType, T lambda) {
        return LambdaTypeBaker.bakeLambdaType(lambda, opType.type());
    }

    public void register(Object ... objects) {
        for (Object o : objects) {
            if (o.getClass().isArray()) {
                this.register(o);
            } else if (o instanceof Iterable) {
                ((Iterable)o).forEach(xva$0 -> this.register(xva$0));
            } else {
                this.manDiscoverer.register(new Object[]{o});
            }
            this.registerInfosFrom(o);
        }
    }

    private List<OpInfo> generateAllInfos(Object o) {
        return this.metaDiscoverer.discover(OpInfoGenerator.class).stream().filter(g -> g.canGenerateFrom(o)).flatMap(g -> g.generateInfosFrom(o).stream()).collect(Collectors.toList());
    }

    private void registerInfosFrom(Object o) {
        List<OpInfo> infos = o instanceof OpInfo ? Collections.singletonList((OpInfo)o) : this.generateAllInfos(o);
        infos.forEach(this.addToOpIndex);
        for (OpInfo info : infos) {
            this.generateAllInfos(info).forEach(this.addToOpIndex);
        }
    }

    public String help(OpRequest request) {
        Optional opt = this.metaDiscoverer.discoverMax(OpDescriptionGenerator.class);
        if (opt.isEmpty()) {
            return "";
        }
        return ((OpDescriptionGenerator)opt.get()).simpleDescriptions(this, request);
    }

    public String helpVerbose(OpRequest request) {
        Optional opt = this.metaDiscoverer.discoverMax(OpDescriptionGenerator.class);
        if (opt.isEmpty()) {
            return "";
        }
        return ((OpDescriptionGenerator)opt.get()).verboseDescriptions(this, request);
    }

    private <T> RichOp<T> findOp(String opName, Nil<T> specialType, Nil<?>[] inTypes, Nil<?> outType, Hints hints) {
        DefaultOpRequest request = DefaultOpRequest.fromTypes(opName, specialType.type(), outType != null ? outType.type() : null, this.toTypes(inTypes));
        MatchingConditions conditions = MatchingConditions.from(request, hints);
        try {
            OpInstance<?> instance = this.generateCacheHit(conditions);
            return this.wrapOp(instance, conditions);
        }
        catch (OpMatchingException e) {
            this.log.debug("Op matching failed.", (Throwable)e);
            String debugText = "See debugging output for full failure report.";
            if (e instanceof DependencyMatchingException) {
                throw new DependencyMatchingException("Error matching dependencies for request:\n\n" + request + "\n\n" + debugText);
            }
            String failedRequest = "\n\n" + request + "\n\n";
            for (Throwable t : e.getSuppressed()) {
                if (!t.getMessage().startsWith("Multiple") || !t.getMessage().contains("ops of priority")) continue;
                throw new OpMatchingException("Multiple ops of equal priority detected for request:" + failedRequest + "\n" + debugText);
            }
            Object msg = this.helpVerbose(request);
            msg = !((String)msg).equals("No Ops found matching this request.") ? "No Ops found matching this request." + failedRequest + "Perhaps you meant one of these:\n" + (String)msg + "\n\n" : (String)msg + failedRequest;
            msg = (String)msg + debugText;
            throw new OpMatchingException((String)msg);
        }
    }

    private <T> OpInstance<T> findOp(OpInfo info, Nil<T> specialType, Hints hints) throws OpMatchingException {
        InfoMatchingOpRequest request = new InfoMatchingOpRequest(info, specialType);
        OpCandidate candidate = new OpCandidate(this, request, info);
        MatchingConditions conditions = MatchingConditions.from(request, hints);
        OpInstance<?> instance = this.instantiateOp(candidate, conditions.hints());
        this.setInstance(conditions, instance);
        return instance;
    }

    private Type[] toTypes(Nil<?> ... nils) {
        return (Type[])Arrays.stream(nils).filter(Objects::nonNull).map(Nil::type).toArray(Type[]::new);
    }

    private OpInstance<?> generateCacheHit(MatchingConditions conditions) {
        OpInstance<?> cachedOp = this.getInstance(conditions);
        if (cachedOp != null) {
            return cachedOp;
        }
        OpCandidate candidate = this.findOpCandidate(conditions.request(), conditions.hints());
        OpInstance<?> instance = this.instantiateOp(candidate, conditions.hints());
        this.setInstance(conditions, instance);
        return instance;
    }

    private OpInstance<?> getInstance(MatchingConditions conditions) {
        if (conditions.hints().contains("cache.IGNORE")) {
            return null;
        }
        return this.opCache.get(conditions);
    }

    private void setInstance(MatchingConditions conditions, OpInstance<?> instance) {
        if (conditions.hints().contains("cache.IGNORE")) {
            return;
        }
        this.opCache.put(conditions, instance);
    }

    private OpCandidate findOpCandidate(OpRequest request, Hints hints) {
        return this.matcher.match(MatchingConditions.from(request, hints), this);
    }

    private OpInstance<?> instantiateOp(OpCandidate candidate, Hints hints) {
        List<RichOp<?>> conditions = this.resolveOpDependencies(candidate, hints);
        DependencyRichOpInfoTree adaptorTree = new DependencyRichOpInfoTree(candidate.opInfo(), conditions);
        return adaptorTree.newInstance(candidate.getType());
    }

    private <T> RichOp<T> wrapOp(OpInstance<T> instance, MatchingConditions conditions) throws IllegalArgumentException {
        if (this.wrappers == null) {
            this.initWrappers();
        }
        try {
            OpInfo info = instance.infoTree().info();
            Class rawType = Types.raw((Type)info.opType());
            Class<?> wrapper = this.getWrapperClass(rawType);
            if (wrapper == null) {
                throw new IllegalArgumentException(info.implementationName() + ": matched op Type " + info.opType().getClass() + " does not match a wrappable Op type.");
            }
            if (!wrapper.equals(rawType)) {
                this.log.debug("OpInfo " + info.implementationName() + " could not be wrapped as a " + rawType + ", so it is instead wrapped as a " + wrapper + ". If you want it to be wrapped as a " + rawType + ", then you must define a new OpWrapper for that class!");
            }
            Type reifiedSuperType = Types.superTypeOf((Type)instance.type(), wrapper);
            OpWrapper<?> opWrapper = this.wrappers.get(Types.raw((Type)reifiedSuperType));
            return opWrapper.wrap(instance, this, conditions);
        }
        catch (IllegalArgumentException | SecurityException exc) {
            throw new IllegalArgumentException((String)(exc.getMessage() != null ? exc.getMessage() : "Cannot wrap " + instance.op().getClass()));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("No wrapper exists for " + Types.raw((Type)instance.type()).toString() + ".");
        }
    }

    private Class<?> getWrapperClass(Class<?> opType) {
        if (opType == null) {
            return null;
        }
        if (this.wrappers.containsKey(opType)) {
            return opType;
        }
        Class<?> wrapperSuperClass = this.getWrapperClass(opType.getSuperclass());
        if (wrapperSuperClass != null) {
            return wrapperSuperClass;
        }
        for (Class<?> iFace : opType.getInterfaces()) {
            Class<?> wrapperIFace = this.getWrapperClass(iFace);
            if (wrapperIFace == null) continue;
            return wrapperIFace;
        }
        return null;
    }

    private List<RichOp<?>> resolveOpDependencies(OpCandidate candidate, Hints hints) {
        return this.resolveOpDependencies(candidate.opInfo(), candidate.typeVarAssigns(), hints);
    }

    private synchronized void initWrappers() {
        if (this.wrappers != null) {
            return;
        }
        HashMap tmp = new HashMap();
        for (Discoverer d : this.discoverers) {
            for (OpWrapper wrapper : d.discover(OpWrapper.class)) {
                tmp.put(wrapper.type(), wrapper);
            }
        }
        this.wrappers = tmp;
    }

    private List<RichOp<?>> resolveOpDependencies(OpInfo info, Map<TypeVariable<?>, Type> typeVarAssigns, Hints hints) {
        HashMap dependencyTypeVarAssigns = new HashMap();
        for (Map.Entry<TypeVariable<?>, Type> entry : typeVarAssigns.entrySet()) {
            Type value = entry.getValue();
            if (Any.is((Object)value)) continue;
            dependencyTypeVarAssigns.put(entry.getKey(), entry.getValue());
        }
        Hints baseDepHints = hints.plus(new String[]{"dependencyMatching.IN_PROGRESS", "conversion.FORBIDDEN", "history.IGNORE"}).minus(new String[]{"progress.TRACK"});
        ArrayList dependencies = new ArrayList();
        for (OpDependencyMember<?> dependency : Infos.dependencies(info)) {
            OpRequest request = this.inferOpRequest(dependency, dependencyTypeVarAssigns);
            try {
                Hints depHints = baseDepHints.plus(dependency.hints());
                MatchingConditions conditions = MatchingConditions.from(request, depHints);
                OpInstance<?> instance = this.generateCacheHit(conditions);
                dependencies.add(this.wrapOp(instance, conditions));
                GenericAssignability.inferTypeVariables((Type)request.type(), (Type)instance.type()).forEach(dependencyTypeVarAssigns::putIfAbsent);
            }
            catch (OpMatchingException e) {
                String message = DependencyMatchingException.message(info.implementationName(), dependency.key(), request);
                if (e instanceof DependencyMatchingException) {
                    throw new DependencyMatchingException(message, (DependencyMatchingException)e);
                }
                throw new DependencyMatchingException(message);
            }
        }
        return dependencies;
    }

    private OpRequest inferOpRequest(OpDependencyMember<?> dependency, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type mappedDependencyType = Types.unroll((Type[])new Type[]{dependency.type()}, typeVarAssigns)[0];
        String dependencyName = dependency.getDependencyName();
        return this.inferOpRequest(mappedDependencyType, dependencyName, typeVarAssigns);
    }

    private OpRequest inferOpRequest(Type type, String name, Map<TypeVariable<?>, Type> typeVarAssigns) {
        List<FunctionalMethodType> fmts = FunctionalParameters.findFunctionalMethodTypes(type);
        EnumSet<ItemIO> inIos = EnumSet.of(ItemIO.INPUT, ItemIO.CONTAINER, ItemIO.MUTABLE);
        EnumSet<ItemIO> outIos = EnumSet.of(ItemIO.OUTPUT, ItemIO.CONTAINER, ItemIO.MUTABLE);
        Type[] inputs = (Type[])fmts.stream().filter(fmt -> inIos.contains(fmt.itemIO())).map(FunctionalMethodType::type).toArray(Type[]::new);
        Object[] outputs = (Type[])fmts.stream().filter(fmt -> outIos.contains(fmt.itemIO())).map(FunctionalMethodType::type).toArray(Type[]::new);
        Type[] mappedInputs = Types.unroll((Type[])inputs, typeVarAssigns);
        Type[] mappedOutputs = Types.unroll((Type[])outputs, typeVarAssigns);
        int numOutputs = mappedOutputs.length;
        if (numOutputs != 1) {
            String error = "Op '" + name + "' of type " + type + " specifies ";
            error = error + (String)(numOutputs == 0 ? "no outputs" : "multiple outputs: " + Arrays.toString(outputs));
            error = error + ". This is not supported.";
            throw new OpMatchingException(error);
        }
        return new DefaultOpRequest(name, type, mappedOutputs[0], mappedInputs);
    }

    private synchronized void initIdDirectory() {
        if (this.idDirectory != null) {
            return;
        }
        this.idDirectory = new HashMap<String, OpInfo>();
        this.opDirectory.values().forEach(info -> this.idDirectory.put(info.id(), (OpInfo)info));
    }

    private SortedSet<OpInfo> opsOfName(String name) {
        return new TreeSet<OpInfo>(this.opDirectory.get((Object)name));
    }

    public void setDefaultHints(Hints hints) {
        this.environmentHints = hints.copy();
    }

    public Hints getDefaultHints() {
        if (this.environmentHints != null) {
            return this.environmentHints.copy();
        }
        return new Hints(new String[0]);
    }

    public double priority() {
        return -10000.0;
    }
}

