/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.struct;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scijava.ops.engine.struct.ConvertedParameterMember;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.RetypingRequest;
import org.scijava.struct.ItemIO;
import org.scijava.struct.Member;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Struct;
import org.scijava.struct.Structs;

public class OpRetypingMemberParser
implements MemberParser<RetypingRequest, Member<?>> {
    public List<Member<?>> parse(RetypingRequest source, Type structType) {
        List original = source.struct().members();
        List<FunctionalMethodType> newFmts = source.newFmts();
        List ios = original.stream().filter(m -> m.isInput() || m.isOutput()).collect(Collectors.toList());
        if (ios.size() == newFmts.size()) {
            return this.strictConversion(original, newFmts);
        }
        return this.synthesizedConversion(newFmts, original);
    }

    private List<Member<?>> synthesizedConversion(List<FunctionalMethodType> newFmts, List<Member<?>> original) {
        List<Member<?>> newMembers = IntStream.range(0, newFmts.size()).boxed().map(foo -> this.mapToMember((int)foo, (FunctionalMethodType)newFmts.get((int)foo))).collect(Collectors.toList());
        for (Member<?> m : original) {
            if (m.isInput() || m.isOutput()) continue;
            newMembers.add(m);
        }
        return newMembers;
    }

    private Member<?> mapToMember(final int i, final FunctionalMethodType fmt) {
        return new Member<Object>(){

            public String key() {
                ItemIO ioType = fmt.itemIO();
                if (ioType == ItemIO.INPUT) {
                    return "in" + i + "1";
                }
                if (ioType == ItemIO.CONTAINER) {
                    return "container";
                }
                if (ioType == ItemIO.MUTABLE) {
                    return "mutable";
                }
                if (ioType == ItemIO.OUTPUT) {
                    return "output";
                }
                return "";
            }

            public Type type() {
                return fmt.type();
            }

            public ItemIO getIOType() {
                return fmt.itemIO();
            }

            public String toString() {
                return Structs.toString((Member)this);
            }
        };
    }

    private List<Member<?>> strictConversion(List<Member<?>> originalMembers, List<FunctionalMethodType> newFmts) {
        FunctionalMethodType outputFmt = newFmts.stream().filter(fmt -> fmt.itemIO() == ItemIO.OUTPUT || fmt.itemIO() == ItemIO.MUTABLE || fmt.itemIO() == ItemIO.CONTAINER).findFirst().get();
        ArrayList newMembers = new ArrayList();
        int inputIndex = 0;
        for (Member<?> m : originalMembers) {
            if (m.isInput()) {
                m = ConvertedParameterMember.from(m, newFmts.get(inputIndex++));
            } else if (m.isOutput()) {
                m = ConvertedParameterMember.from(m, outputFmt);
            }
            newMembers.add(m);
        }
        return newMembers;
    }

    public List<Member<?>> parse(Struct s, List<FunctionalMethodType> newFmts, Type structType) {
        return this.parse(new RetypingRequest(s, newFmts), structType);
    }
}

