/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.animate;

import bdv.util.Affine3DHelpers;
import bdv.viewer.animate.AbstractTransformAnimator;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;

public class SimilarityTransformAnimator3D
extends AbstractTransformAnimator {
    private final double[] qStart;
    private final double[] qDiff;
    private final double[] xg0Start;
    private final double[] xg0Diff;
    private final double scaleStart;
    private final double scaleEnd;
    private final double scaleDiff;
    private final double cX;
    private final double cY;

    public SimilarityTransformAnimator3D(AffineTransform3D transformStart, AffineTransform3D transformEnd, double cX, double cY, long duration) {
        super(duration);
        this.cX = cX;
        this.cY = cY;
        this.qStart = new double[4];
        double[] qStartInv = new double[4];
        double[] qEnd = new double[4];
        double[] qEndInv = new double[4];
        this.qDiff = new double[4];
        Affine3DHelpers.extractRotation((AffineTransform3D)transformStart, (double[])this.qStart);
        LinAlgHelpers.quaternionInvert((double[])this.qStart, (double[])qStartInv);
        Affine3DHelpers.extractRotation((AffineTransform3D)transformEnd, (double[])qEnd);
        LinAlgHelpers.quaternionInvert((double[])qEnd, (double[])qEndInv);
        LinAlgHelpers.quaternionMultiply((double[])qStartInv, (double[])qEnd, (double[])this.qDiff);
        if (this.qDiff[0] < 0.0) {
            LinAlgHelpers.scale((double[])this.qDiff, (double)-1.0, (double[])this.qDiff);
        }
        this.scaleStart = Affine3DHelpers.extractScale((AffineTransform3D)transformStart, (int)0);
        this.scaleEnd = Affine3DHelpers.extractScale((AffineTransform3D)transformEnd, (int)0);
        this.scaleDiff = this.scaleEnd - this.scaleStart;
        double[] tStart = new double[3];
        double[] tEnd = new double[3];
        for (int d = 0; d < 3; ++d) {
            tStart[d] = transformStart.get(d, 3) / this.scaleStart;
            tEnd[d] = transformEnd.get(d, 3) / this.scaleEnd;
        }
        this.xg0Start = new double[3];
        double[] xg0End = new double[3];
        this.xg0Diff = new double[3];
        double[][] R = new double[3][3];
        LinAlgHelpers.quaternionToR((double[])qStartInv, (double[][])R);
        LinAlgHelpers.mult((double[][])R, (double[])tStart, (double[])this.xg0Start);
        LinAlgHelpers.scale((double[])this.xg0Start, (double)-1.0, (double[])this.xg0Start);
        LinAlgHelpers.quaternionToR((double[])qEndInv, (double[][])R);
        LinAlgHelpers.mult((double[][])R, (double[])tEnd, (double[])xg0End);
        LinAlgHelpers.scale((double[])xg0End, (double)-1.0, (double[])xg0End);
        LinAlgHelpers.subtract((double[])xg0End, (double[])this.xg0Start, (double[])this.xg0Diff);
    }

    public AffineTransform3D get(double t) {
        double[] qDiffCurrent = new double[4];
        double[] qCurrent = new double[4];
        LinAlgHelpers.quaternionPower((double[])this.qDiff, (double)t, (double[])qDiffCurrent);
        LinAlgHelpers.quaternionMultiply((double[])this.qStart, (double[])qDiffCurrent, (double[])qCurrent);
        double scaleCurrent = this.scaleStart + t * this.scaleDiff;
        double[] xg0Current = new double[3];
        double[] tCurrent = new double[3];
        LinAlgHelpers.scale((double[])this.xg0Diff, (double)(-(t * this.scaleEnd / scaleCurrent)), (double[])xg0Current);
        for (int r = 0; r < 3; ++r) {
            int n = r;
            xg0Current[n] = xg0Current[n] - this.xg0Start[r];
        }
        double[][] Rcurrent = new double[3][3];
        LinAlgHelpers.quaternionToR((double[])qCurrent, (double[][])Rcurrent);
        LinAlgHelpers.mult((double[][])Rcurrent, (double[])xg0Current, (double[])tCurrent);
        double[][] m = new double[3][4];
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                m[r][c] = scaleCurrent * Rcurrent[r][c];
            }
            m[r][3] = scaleCurrent * tCurrent[r];
        }
        AffineTransform3D transform = new AffineTransform3D();
        transform.set(m);
        return transform;
    }
}

