/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.landmarks.actions;

import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.landmarks.actions.AbstractPointEdit;

public class DeleteRowEdit
extends AbstractPointEdit {
    private static final long serialVersionUID = -3624020789748090982L;
    private final int index;
    private final double[] movingPt;
    private final double[] targetPt;

    public DeleteRowEdit(LandmarkTableModel ltm, int index) {
        super(ltm);
        this.index = index;
        this.movingPt = LandmarkTableModel.toPrimitive(ltm.getPoints(true).get(index));
        this.targetPt = LandmarkTableModel.toPrimitive(ltm.getPoints(false).get(index));
    }

    @Override
    public void undo() {
        this.ltm.pointEdit(this.index, this.movingPt, true, true, null, false);
        this.ltm.pointEdit(this.index, this.targetPt, false, false, null, false);
    }

    @Override
    public void redo() {
        this.ltm.deleteRowHelper(this.index);
    }

    @Override
    public String toString() {
        return "DeletePointEdit " + this.index;
    }
}

