/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.util.Arrays;
import java.util.List;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;

public class IntegerTypes {
    private static List<? extends IntegerType<?>> signedTypes = Arrays.asList(new ByteType(), new ShortType(), new IntType(), new LongType());
    private static List<? extends IntegerType<?>> unsignedTypes = Arrays.asList(new BitType(), new UnsignedByteType(), new UnsignedShortType(), new UnsignedIntType(), new UnsignedLongType());

    private IntegerTypes() {
    }

    public static IntegerType<?> smallestType(boolean signed, long max) {
        return IntegerTypes.smallestType(signed ? -1L : 0L, max);
    }

    public static IntegerType<?> smallestType(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("Wrong usage: min (" + min + ") > max (" + max + ")");
        }
        if (min >= 0L) {
            return (IntegerType)unsignedTypes.stream().filter(i -> (double)min >= i.getMinValue() && (double)max <= i.getMaxValue()).findFirst().get().createVariable();
        }
        return (IntegerType)signedTypes.stream().filter(i -> (double)min >= i.getMinValue() && (double)max <= i.getMaxValue()).findFirst().get().createVariable();
    }
}

