/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.composite;

import java.util.Iterator;
import net.imglib2.RandomAccess;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.composite.AbstractComposite;

public abstract class AbstractNumericComposite<T extends NumericType<T>, C extends AbstractNumericComposite<T, C>>
extends AbstractComposite<T>
implements NumericType<C>,
Iterable<T> {
    protected final int length;
    protected final Iterator<T> iterator = new Iterator<T>(){

        @Override
        public boolean hasNext() {
            return AbstractNumericComposite.this.sourceAccess.getIntPosition(AbstractNumericComposite.this.d) + 1 < AbstractNumericComposite.this.length;
        }

        @Override
        public T next() {
            AbstractNumericComposite.this.sourceAccess.fwd(AbstractNumericComposite.this.d);
            NumericType t = (NumericType)AbstractNumericComposite.this.sourceAccess.get();
            return t;
        }
    };

    public int getLength() {
        return this.length;
    }

    public AbstractNumericComposite(RandomAccess<T> sourceAccess, int length) {
        super(sourceAccess);
        this.length = length;
    }

    @Override
    public void set(C c) {
        this.sourceAccess.setPosition(0, this.d);
        ((AbstractNumericComposite)c).sourceAccess.setPosition(0, ((AbstractNumericComposite)c).d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).set((Type)((AbstractNumericComposite)c).sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            ((AbstractNumericComposite)c).sourceAccess.fwd(((AbstractNumericComposite)c).d);
        }
    }

    @Override
    public void add(C c) {
        this.sourceAccess.setPosition(0, this.d);
        ((AbstractNumericComposite)c).sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).add(((AbstractNumericComposite)c).sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            ((AbstractNumericComposite)c).sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void sub(C c) {
        this.sourceAccess.setPosition(0, this.d);
        ((AbstractNumericComposite)c).sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).sub(((AbstractNumericComposite)c).sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            ((AbstractNumericComposite)c).sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void mul(C c) {
        this.sourceAccess.setPosition(0, this.d);
        ((AbstractNumericComposite)c).sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).mul(((AbstractNumericComposite)c).sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            ((AbstractNumericComposite)c).sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void div(C c) {
        this.sourceAccess.setPosition(0, this.d);
        ((AbstractNumericComposite)c).sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).div(((AbstractNumericComposite)c).sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            ((AbstractNumericComposite)c).sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void pow(C c) {
        this.sourceAccess.setPosition(0, this.d);
        ((AbstractNumericComposite)c).sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).pow(((AbstractNumericComposite)c).sourceAccess.get());
            this.sourceAccess.fwd(this.d);
            ((AbstractNumericComposite)c).sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void pow(double power) {
        this.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).pow(power);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setZero() {
        this.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).setZero();
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setOne() {
        this.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).setOne();
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void mul(float c) {
        this.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).mul(c);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void mul(double c) {
        this.sourceAccess.setPosition(0, this.d);
        while (this.sourceAccess.getLongPosition(this.d) < (long)this.length) {
            ((NumericType)this.sourceAccess.get()).mul(c);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public Iterator<T> iterator() {
        this.sourceAccess.setPosition(-1, this.d);
        return this.iterator;
    }

    @Override
    public boolean valueEquals(C t) {
        if (((AbstractNumericComposite)t).length == this.length) {
            Iterator<T> a = this.iterator();
            Iterator<T> b = ((AbstractNumericComposite)t).iterator();
            while (a.hasNext()) {
                if (((NumericType)a.next()).valueEquals(b.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

