/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import java.io.File;
import java.io.IOException;
import org.apposed.appose.BuilderFactory;
import org.apposed.appose.Environment;
import org.apposed.appose.builder.Builders;
import org.apposed.appose.builder.DynamicBuilder;
import org.apposed.appose.builder.MambaBuilder;
import org.apposed.appose.builder.PixiBuilder;
import org.apposed.appose.builder.SimpleBuilder;
import org.apposed.appose.builder.UvBuilder;
import org.apposed.appose.util.Versions;

public class Appose {
    public static PixiBuilder pixi() {
        return new PixiBuilder();
    }

    public static PixiBuilder pixi(String source) throws IOException {
        return new PixiBuilder(source);
    }

    public static MambaBuilder mamba() {
        return new MambaBuilder();
    }

    public static MambaBuilder mamba(String source) throws IOException {
        return new MambaBuilder(source);
    }

    public static UvBuilder uv() {
        return new UvBuilder();
    }

    public static UvBuilder uv(String source) throws IOException {
        return new UvBuilder(source);
    }

    public static DynamicBuilder file(String source) {
        return new DynamicBuilder(source);
    }

    public static Environment wrap(File envDir) throws IOException {
        if (!envDir.exists()) {
            throw new IOException("Environment directory does not exist: " + envDir);
        }
        BuilderFactory factory = Builders.findFactoryForWrapping(envDir);
        if (factory != null) {
            return factory.createBuilder().wrap(envDir);
        }
        return new SimpleBuilder().wrap(envDir);
    }

    public static Environment wrap(String envDir) throws IOException {
        return Appose.wrap(new File(envDir));
    }

    public static Environment system() throws IOException {
        return new SimpleBuilder().inheritRunningJava().appendSystemPath().build();
    }

    public static SimpleBuilder custom() {
        return new SimpleBuilder();
    }

    public static String version() {
        String v = Versions.version(Appose.class);
        return v == null ? "(unknown)" : v;
    }
}

