/*
 * Decompiled with CFR 0.152.
 */
package imglib.ops.operation;

import imglib.ops.condition.Condition;
import imglib.ops.function.RealFunction;
import imglib.ops.observer.IterationStatus;
import imglib.ops.operation.MultiImageIterator;
import java.util.Observable;
import java.util.Observer;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;

public class AssignOperation<T extends RealType<T>> {
    private int imageCount;
    private MultiImageIterator<T> cursor;
    private T outputVariable;
    private int[][] positions;
    private Observable notifier;
    private Condition[] conditions;
    private boolean requireIntersection;
    private RealFunction<T> function;
    private boolean wasInterrupted;

    public AssignOperation(Image<T>[] inputs, Image<T> output, RealFunction<T> func) {
        int i;
        this.imageCount = inputs.length + 1;
        Image[] images = new Image[this.imageCount];
        images[0] = output;
        for (i = 1; i <= inputs.length; ++i) {
            images[i] = inputs[i - 1];
        }
        this.cursor = new MultiImageIterator(images);
        this.positions = new int[this.imageCount][];
        this.positions[0] = new int[output.getNumDimensions()];
        for (i = 1; i < this.imageCount; ++i) {
            this.positions[i] = new int[inputs[i - 1].getNumDimensions()];
        }
        this.outputVariable = null;
        this.notifier = null;
        this.conditions = new Condition[this.imageCount];
        this.requireIntersection = true;
        this.function = func;
        this.wasInterrupted = false;
        if (!this.function.canAccept(inputs.length)) {
            throw new IllegalArgumentException("function cannot handle " + inputs.length + " input images");
        }
    }

    public void addObserver(Observer o) {
        if (this.notifier == null) {
            this.notifier = new Observable();
        }
        this.notifier.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        if (this.notifier != null) {
            this.notifier.deleteObserver(o);
            if (this.notifier.countObservers() == 0) {
                this.notifier = null;
            }
        }
    }

    public void setOutputRegion(int[] origin, int[] span) {
        this.cursor.setRegion(0, origin, span);
    }

    public void setOutputCondition(Condition<T> c) {
        this.conditions[0] = c;
    }

    public void setInputRegion(int i, int[] origin, int[] span) {
        this.cursor.setRegion(i + 1, origin, span);
    }

    public void setInputCondition(int i, Condition<T> c) {
        this.conditions[i + 1] = c;
    }

    public void intersectConditions() {
        this.requireIntersection = true;
    }

    public void unionConditions() {
        this.requireIntersection = false;
    }

    public void execute() {
        this.cursor.initialize();
        RegionOfInterestCursor[] subCursors = this.cursor.getSubcursors();
        this.outputVariable = (RealType)subCursors[0].getType();
        RealType[] inputVariables = this.getInputVariables(subCursors);
        int[] position = subCursors[0].createPositionArray();
        IterationTracker status = new IterationTracker();
        if (this.notifier != null) {
            status.message = IterationStatus.Message.INITIALIZE;
            this.notifier.notifyObservers(status);
        }
        while (this.cursor.hasNext() && !this.wasInterrupted) {
            this.cursor.fwd();
            double value = Double.NaN;
            boolean conditionsSatisfied = this.conditionsSatisfied(subCursors);
            if (conditionsSatisfied) {
                this.function.compute(inputVariables, (RealType)this.outputVariable);
                value = this.outputVariable.getRealDouble();
            }
            if (this.notifier == null) continue;
            subCursors[0].getPosition(position);
            status.message = IterationStatus.Message.UPDATE;
            status.position = position;
            status.value = value;
            status.conditionsSatisfied = conditionsSatisfied;
            this.notifier.notifyObservers(status);
        }
        if (this.notifier != null) {
            status.message = IterationStatus.Message.DONE;
            status.wasInterrupted = this.wasInterrupted;
            this.notifier.notifyObservers(status);
        }
    }

    public void quit() {
        this.wasInterrupted = true;
    }

    private boolean conditionsSatisfied(LocalizableCursor<T>[] cursors) {
        for (int i = 0; i < this.conditions.length; ++i) {
            Condition condition = this.conditions[i];
            if (condition == null) continue;
            LocalizableCursor<T> subcursor = cursors[i];
            subcursor.getPosition(this.positions[i]);
            if (condition.isSatisfied(subcursor, this.positions[i])) {
                if (this.requireIntersection) continue;
                return true;
            }
            if (!this.requireIntersection) continue;
            return false;
        }
        return this.requireIntersection;
    }

    private T[] getInputVariables(RegionOfInterestCursor<T>[] cursors) {
        RealType[] variables = (RealType[])this.outputVariable.createArray1D(this.imageCount - 1);
        for (int i = 0; i < variables.length; ++i) {
            variables[i] = (RealType)cursors[i + 1].getType();
        }
        return variables;
    }

    private class IterationTracker
    implements IterationStatus {
        IterationStatus.Message message;
        int[] position;
        double value;
        boolean conditionsSatisfied;
        boolean wasInterrupted;

        private IterationTracker() {
        }

        @Override
        public IterationStatus.Message getMessage() {
            return this.message;
        }

        @Override
        public int[] getPosition() {
            return this.position;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public boolean getConditionsSatisfied() {
            return this.conditionsSatisfied;
        }

        @Override
        public boolean wasInterrupted() {
            return this.wasInterrupted;
        }
    }
}

