/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.extremafinder;

import java.util.ArrayList;
import mpicbg.imglib.algorithm.extremafinder.AbstractRegionalExtremaFinder;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;

public class RegionalExtremaFinder2D<T extends RealType<T>>
extends AbstractRegionalExtremaFinder<T> {
    protected int sign;
    private long processingTime;
    private String errorMessage = "";
    static final byte CC_MEMBER = 1;
    static final byte PROCESSED = 2;

    public RegionalExtremaFinder2D(Image<T> image, boolean findMaxima) {
        this.sign = findMaxima ? 1 : -1;
        this.image = image;
        this.processingTime = -1L;
    }

    public RegionalExtremaFinder2D(Image<T> image) {
        this(image, true);
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "FindMaxima3D: [Image<T> img] is null.";
            return false;
        }
        if (this.outOfBoundsFactory == null) {
            this.errorMessage = "FindMaxima3D: [OutOfBoundsStrategyFactory<T>] is null.";
            return false;
        }
        return true;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        LocalizableByDimCursor curr = this.image.createLocalizableByDimCursor(this.outOfBoundsFactory);
        LocalizableByDimCursor local = this.image.createLocalizableByDimCursor(this.outOfBoundsFactory);
        LocalNeighborhoodCursor neighbors = new LocalNeighborhoodCursor(local);
        ArrayList<Object> toSearch = new ArrayList<Object>();
        ArrayList<Object> searched = new ArrayList<Object>();
        RealType currentValue = (RealType)this.image.createType();
        int width = this.image.getDimensions()[0];
        byte[] visitedAndProcessed = new byte[this.image.getNumPixels()];
        int[] nextCoords = new int[3];
        int[] currCoords = new int[3];
        int[] neighborCoords = new int[3];
        while (curr.hasNext()) {
            curr.fwd();
            curr.getPosition(currCoords);
            if (null != this.threshold && this.sign * ((RealType)curr.getType()).compareTo(this.threshold) < 0 || (visitedAndProcessed[RegionalExtremaFinder2D.getIndexOfPosition(currCoords, width)] & 2) != 0) continue;
            boolean isExtreme = true;
            currentValue.set(curr.getType());
            toSearch.add(currCoords);
            while (!toSearch.isEmpty()) {
                nextCoords = (int[])toSearch.remove(0);
                if ((visitedAndProcessed[RegionalExtremaFinder2D.getIndexOfPosition(nextCoords, width)] & 2) != 0) continue;
                int n = RegionalExtremaFinder2D.getIndexOfPosition(nextCoords, width);
                visitedAndProcessed[n] = (byte)(visitedAndProcessed[n] | 2);
                if (this.allowEdgeMax || !this.allowEdgeMax && !this.isEdgeMax(nextCoords)) {
                    searched.add(nextCoords.clone());
                }
                local.setPosition(nextCoords);
                neighbors.update();
                while (neighbors.hasNext()) {
                    neighbors.fwd();
                    local.getPosition(neighborCoords);
                    if (!this.isWithinImageBounds(neighborCoords) || (visitedAndProcessed[RegionalExtremaFinder2D.getIndexOfPosition(neighborCoords, width)] & 1) != 0) continue;
                    RealType neighborValue = (RealType)neighbors.getType();
                    int compare = neighborValue.compareTo(currentValue);
                    if (this.sign * compare > 0) {
                        isExtreme = false;
                        continue;
                    }
                    if (compare == 0 && (visitedAndProcessed[RegionalExtremaFinder2D.getIndexOfPosition(nextCoords, width)] & 2) != 0) {
                        toSearch.add(neighborCoords.clone());
                        int n2 = RegionalExtremaFinder2D.getIndexOfPosition(neighborCoords, width);
                        visitedAndProcessed[n2] = (byte)(visitedAndProcessed[n2] | 1);
                        continue;
                    }
                    int n3 = RegionalExtremaFinder2D.getIndexOfPosition(neighborCoords, width);
                    visitedAndProcessed[n3] = (byte)(visitedAndProcessed[n3] | 2);
                }
                neighbors.reset();
            }
            if (isExtreme && searched.size() > 0) {
                this.maxima.add((ArrayList)searched.clone());
            }
            searched.clear();
        }
        curr.close();
        neighbors.close();
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public ArrayList<ArrayList<int[]>> getRegionalExtrema() {
        return this.maxima;
    }

    protected final boolean isEdgeMax(int[] coords) {
        return coords[0] == 0 || coords[0] == this.image.getDimension(0) - 1 || coords[1] == 0 || coords[1] == this.image.getDimension(1) - 1;
    }

    protected final boolean isWithinImageBounds(int[] pos) {
        return pos[0] > -1 && pos[0] < this.image.getDimension(0) && pos[1] > -1 && pos[1] < this.image.getDimension(1);
    }

    protected static final int getIndexOfPosition(int[] pos, int width) {
        return pos[0] + width * pos[1];
    }
}

