/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.dynamic;

import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.DirectAccessContainerImpl;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.dynamic.DynamicContainerAccessor;
import mpicbg.imglib.container.dynamic.DynamicContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.dynamic.DynamicCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizableByDimCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizableCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public abstract class DynamicContainer<T extends Type<T>, A extends DynamicContainerAccessor>
extends DirectAccessContainerImpl<T, A> {
    protected final int[] step;
    protected int numPixels;
    protected int numEntities;

    public DynamicContainer(DynamicContainerFactory factory, int[] dim, int entitiesPerPixel) {
        super(factory, dim, entitiesPerPixel);
        this.step = Array.createAllocationSteps(dim);
        this.numPixels = ((DirectAccessContainerImpl)this).numPixels;
        this.numEntities = ((DirectAccessContainerImpl)this).numEntities;
    }

    public int[] getSteps() {
        return (int[])this.step.clone();
    }

    public int getStep(int dim) {
        return this.step[dim];
    }

    public final int getPos(int[] l) {
        int i = l[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            i += l[d] * this.step[d];
        }
        return i;
    }

    public abstract A createAccessor();

    @Override
    public int getNumEntities() {
        return this.numEntities;
    }

    @Override
    public int getNumPixels() {
        return this.numPixels;
    }

    @Override
    public DynamicCursor<T> createCursor(Image<T> image) {
        return new DynamicCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public LocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        return new DynamicLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public LocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        return new DynamicLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsFactory);
    }

    @Override
    public DynamicLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        return new DynamicLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public LocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        return new DynamicLocalizablePlaneCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public boolean compareStorageContainerCompatibility(Container<?> container) {
        if (this.compareStorageContainerDimensions(container)) {
            return this.getFactory().getClass().isInstance(container.getFactory());
        }
        return false;
    }
}

