/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.IntAccess;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.imagej.RGBALegacyTypeDisplay;
import mpicbg.imglib.type.TypeImpl;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.util.Util;

public final class RGBALegacyType
extends TypeImpl<RGBALegacyType>
implements NumericType<RGBALegacyType> {
    final DirectAccessContainer<RGBALegacyType, ? extends IntAccess> storage;
    IntAccess b;

    public RGBALegacyType(DirectAccessContainer<RGBALegacyType, ? extends IntAccess> byteStorage) {
        this.storage = byteStorage;
    }

    public RGBALegacyType(int value) {
        this.storage = null;
        this.b = new IntArray(1);
        this.set(value);
    }

    public RGBALegacyType() {
        this(0);
    }

    @Override
    public DirectAccessContainer<RGBALegacyType, ? extends IntAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<RGBALegacyType, IntAccess> container = storageFactory.createIntInstance(dim, 1);
        RGBALegacyType linkedType = new RGBALegacyType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Cursor<?> c) {
        this.b = this.storage.update(c);
    }

    @Override
    public RGBALegacyType duplicateTypeOnSameDirectAccessContainer() {
        return new RGBALegacyType(this.storage);
    }

    public RGBALegacyTypeDisplay getDefaultDisplay(Image<RGBALegacyType> image) {
        return new RGBALegacyTypeDisplay(image);
    }

    public static final int rgba(int r, int g, int b, int a) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF | (a & 0xFF) << 24;
    }

    public static final int rgba(float r, float g, float b, float a) {
        return RGBALegacyType.rgba(Util.round(r), Util.round(g), Util.round(b), Util.round(a));
    }

    public static final int rgba(double r, double g, double b, double a) {
        return RGBALegacyType.rgba((int)Util.round(r), (int)Util.round(g), (int)Util.round(b), (int)Util.round(a));
    }

    public static final int red(int value) {
        return value >> 16 & 0xFF;
    }

    public static final int green(int value) {
        return value >> 8 & 0xFF;
    }

    public static final int blue(int value) {
        return value & 0xFF;
    }

    public static final int alpha(int value) {
        return value >> 24 & 0xFF;
    }

    public int get() {
        return this.b.getValue(this.i);
    }

    @Override
    public void set(int f) {
        this.b.setValue(this.i, f);
    }

    @Override
    public void mul(float c) {
        int value = this.get();
        this.set(RGBALegacyType.rgba((float)RGBALegacyType.red(value) * c, (float)RGBALegacyType.green(value) * c, (float)RGBALegacyType.blue(value) * c, (float)RGBALegacyType.alpha(value) * c));
    }

    @Override
    public void mul(double c) {
        int value = this.get();
        this.set(RGBALegacyType.rgba((double)RGBALegacyType.red(value) * c, (double)RGBALegacyType.green(value) * c, (double)RGBALegacyType.blue(value) * c, (double)RGBALegacyType.alpha(value) * c));
    }

    @Override
    public void add(RGBALegacyType c) {
        int value1 = this.get();
        int value2 = c.get();
        this.set(RGBALegacyType.rgba(RGBALegacyType.red(value1) + RGBALegacyType.red(value2), RGBALegacyType.green(value1) + RGBALegacyType.green(value2), RGBALegacyType.blue(value1) + RGBALegacyType.blue(value2), RGBALegacyType.alpha(value1) + RGBALegacyType.alpha(value2)));
    }

    @Override
    public void div(RGBALegacyType c) {
        int value1 = this.get();
        int value2 = c.get();
        this.set(RGBALegacyType.rgba(RGBALegacyType.red(value1) / RGBALegacyType.red(value2), RGBALegacyType.green(value1) / RGBALegacyType.green(value2), RGBALegacyType.blue(value1) / RGBALegacyType.blue(value2), RGBALegacyType.alpha(value1) / RGBALegacyType.alpha(value2)));
    }

    @Override
    public void mul(RGBALegacyType c) {
        int value1 = this.get();
        int value2 = c.get();
        this.set(RGBALegacyType.rgba(RGBALegacyType.red(value1) * RGBALegacyType.red(value2), RGBALegacyType.green(value1) * RGBALegacyType.green(value2), RGBALegacyType.blue(value1) * RGBALegacyType.blue(value2), RGBALegacyType.alpha(value1) * RGBALegacyType.alpha(value2)));
    }

    @Override
    public void sub(RGBALegacyType c) {
        int value1 = this.get();
        int value2 = c.get();
        this.set(RGBALegacyType.rgba(RGBALegacyType.red(value1) - RGBALegacyType.red(value2), RGBALegacyType.green(value1) - RGBALegacyType.green(value2), RGBALegacyType.blue(value1) - RGBALegacyType.blue(value2), RGBALegacyType.alpha(value1) - RGBALegacyType.alpha(value2)));
    }

    @Override
    public void set(RGBALegacyType c) {
        this.set(c.get());
    }

    @Override
    public void setOne() {
        this.set(RGBALegacyType.rgba(1, 1, 1, 1));
    }

    @Override
    public void setZero() {
        this.set(0);
    }

    public RGBALegacyType[] createArray1D(int size1) {
        return new RGBALegacyType[size1];
    }

    public RGBALegacyType[][] createArray2D(int size1, int size2) {
        return new RGBALegacyType[size1][size2];
    }

    public RGBALegacyType[][][] createArray3D(int size1, int size2, int size3) {
        return new RGBALegacyType[size1][size2][size3];
    }

    @Override
    public RGBALegacyType createVariable() {
        return new RGBALegacyType(0);
    }

    @Override
    public RGBALegacyType copy() {
        return new RGBALegacyType(this.get());
    }

    @Override
    public String toString() {
        int rgba = this.get();
        return "(r=" + RGBALegacyType.red(rgba) + ",g=" + RGBALegacyType.green(rgba) + ",b=" + RGBALegacyType.blue(rgba) + ",a=" + RGBALegacyType.alpha(rgba) + ")";
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }
}

