/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.math.ComputeMinMax;
import mpicbg.imglib.algorithm.math.ImageConverter;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import script.imglib.algorithm.fn.AbstractNormalize;
import script.imglib.color.Alpha;
import script.imglib.color.Blue;
import script.imglib.color.Green;
import script.imglib.color.RGBA;
import script.imglib.color.Red;
import script.imglib.color.fn.ColorFunction;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

public class Normalize<N extends NumericType<N>>
extends AbstractNormalize<N> {
    public Normalize(Object fn) throws Exception {
        super(Normalize.process(fn));
    }

    private static final Image process(Object fn) throws Exception {
        if (fn instanceof ColorFunction) {
            return Normalize.processRGBA(Compute.inRGBA((ColorFunction)fn));
        }
        if (fn instanceof IFunction) {
            return Normalize.processReal((IFunction)fn);
        }
        if (fn instanceof Image) {
            if (((Image)fn).createType() instanceof RGBALegacyType) {
                return Normalize.processRGBA((Image)fn);
            }
            return Normalize.processReal((Image)fn);
        }
        throw new Exception("NormalizeMinMax: don't know how to process " + fn.getClass());
    }

    private static final Image<RGBALegacyType> processRGBA(Image<RGBALegacyType> img) throws Exception {
        return new RGBA(Normalize.processReal(new Red(img)), Normalize.processReal(new Green(img)), Normalize.processReal(new Blue(img)), Normalize.processReal(new Alpha(img))).asImage();
    }

    private static final Image<FloatType> processReal(IFunction fn) throws Exception {
        return Normalize.processReal(Compute.inFloats(fn));
    }

    private static final <T extends RealType<T>> Image<FloatType> processReal(Image<T> img) throws Exception {
        double max;
        double range;
        double min;
        ComputeMinMax<T> cmm = new ComputeMinMax<T>(img);
        if (!cmm.checkInput() || !cmm.process()) {
            throw new Exception("Coult not compute min and max: " + cmm.getErrorMessage());
        }
        if (0 == ((RealType)cmm.getMin()).compareTo(cmm.getMax())) {
            return new Image<FloatType>(img.getContainerFactory().createContainer(img.getDimensions(), new FloatType()), new FloatType());
        }
        Image<FloatType> target = new Image<FloatType>(img.getContainerFactory().createContainer(img.getDimensions(), new FloatType()), new FloatType());
        ImageConverter<FloatType, FloatType> conv = new ImageConverter<FloatType, FloatType>(img, target, new Converter<T, FloatType>(min = ((RealType)cmm.getMin()).getRealDouble(), range = (max = ((RealType)cmm.getMax()).getRealDouble()) - min){
            final /* synthetic */ double val$min;
            final /* synthetic */ double val$range;
            {
                this.val$min = d;
                this.val$range = d2;
            }

            @Override
            public void convert(T input, FloatType output) {
                output.setReal((input.getRealDouble() - this.val$min) / this.val$range);
            }
        });
        if (!conv.checkInput() || !conv.process()) {
            throw new Exception("Could not normalize image: " + conv.getErrorMessage());
        }
        return target;
    }
}

