/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics;

import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;

public enum LineType {
    BLANK(0),
    SOLID(1),
    DASHED(2),
    DOTTED(3),
    DOTDASH(4),
    LONGDASH(5),
    TWODASH(6);

    private final int code;

    private LineType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static LineType valueOf(SEXP exp2) {
        return LineType.valueOf(exp2);
    }

    public static LineType valueOf(SEXP exp2, int elementIndex) {
        if (exp2 instanceof StringVector) {
            return LineType.valueOf(((StringVector)exp2).getElementAsString(elementIndex).toUpperCase());
        }
        if (exp2 instanceof IntVector) {
            return LineType.valueOf(((IntVector)exp2).getElementAsInt(elementIndex));
        }
        throw new IllegalArgumentException("" + exp2);
    }

    private static LineType valueOf(int code) {
        for (LineType lineType : LineType.values()) {
            if (lineType.getCode() != code) continue;
            return lineType;
        }
        throw new IllegalArgumentException("Unknown LineType code: " + code);
    }

    public StringVector toExpression() {
        return new StringArrayVector(this.name().toLowerCase());
    }
}

