/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.appose;

import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.appose.NDArrays;
import net.imglib2.appose.WrappedNDArray;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.WrappedImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.stream.LocalizableSpliterator;
import net.imglib2.type.NativeType;
import net.imglib2.util.ImgUtil;
import net.imglib2.util.Util;
import org.apposed.appose.NDArray;

public class ShmImg<T extends NativeType<T>>
implements WrappedNDArray,
WrappedImg<T>,
Img<T> {
    private final NDArray ndArray;
    private final ArrayImg<T, ?> img;

    public static <T extends NativeType<T>> ShmImg<T> copyOf(RandomAccessibleInterval<T> rai) {
        ShmImg<NativeType> copy = new ShmImg<NativeType>((NativeType)rai.getType(), Util.long2int(rai.dimensionsAsLongArray()));
        ImgUtil.copy(rai, copy);
        return copy;
    }

    public ShmImg(NDArray ndArray) {
        this.ndArray = ndArray;
        this.img = NDArrays.asArrayImg(ndArray);
    }

    public ShmImg(T type, int ... dimensions) {
        this(type, NDArrays.ndArray(type, dimensions));
    }

    private ShmImg(T type, NDArray ndArray) {
        this.ndArray = ndArray;
        this.img = NDArrays.asArrayImg(ndArray, type);
    }

    @Override
    public NDArray ndArray() {
        return this.ndArray;
    }

    public ArrayImg<T, ?> getImg() {
        return this.img;
    }

    @Override
    public T getType() {
        return (T)this.img.getType();
    }

    @Override
    public int numDimensions() {
        return this.img.numDimensions();
    }

    @Override
    public long min(int d) {
        return this.img.min(d);
    }

    @Override
    public long max(int d) {
        return this.img.max(d);
    }

    @Override
    public long dimension(int d) {
        return this.img.dimension(d);
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return this.img.randomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return this.img.randomAccess(interval);
    }

    @Override
    public Cursor<T> cursor() {
        return this.img.cursor();
    }

    @Override
    public Cursor<T> localizingCursor() {
        return this.img.localizingCursor();
    }

    @Override
    public LocalizableSpliterator<T> spliterator() {
        return this.img.spliterator();
    }

    @Override
    public LocalizableSpliterator<T> localizingSpliterator() {
        return this.img.localizingSpliterator();
    }

    @Override
    public long size() {
        return this.img.size();
    }

    @Override
    public Object iterationOrder() {
        return this.img.iterationOrder();
    }

    @Override
    public ImgFactory<T> factory() {
        return new ShmImgFactory<Object>(this.getType());
    }

    @Override
    public Img<T> copy() {
        return ShmImg.copyOf(this);
    }

    private static class ShmImgFactory<T extends NativeType<T>>
    extends ImgFactory<T> {
        ShmImgFactory(T type) {
            super(type);
        }

        @Override
        public Img<T> create(long ... dimensions) {
            return new ShmImg<NativeType>((NativeType)this.type(), Util.long2int(dimensions));
        }

        @Override
        public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
            if (type instanceof NativeType) {
                return new ShmImgFactory<NativeType>((NativeType)type);
            }
            throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
        }

        @Override
        @Deprecated
        public Img<T> create(long[] dim, T type) {
            return new ShmImg<T>(type, Util.long2int(dim));
        }
    }
}

