/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.detection.ThresholdDetector;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.detector.ThresholdDetectorConfigurationPanel;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class ThresholdDetectorFactory<T extends RealType<T> & NativeType<T>>
implements SpotDetectorFactory<T> {
    public static final String DETECTOR_KEY = "THRESHOLD_DETECTOR";
    public static final String NAME = "Thresholding detector";
    public static final String INFO_TEXT = "<html>This detector creates spots by thresholding a grayscale image.<p>Pixels in the designated channel that have a value larger than the threshold are considered as part of the foreground, and used to build connected regions. In 2D, spots are created with the (possibly simplified) contour of the region. In 3D, a spherical spot is created for each region in its center, with a volume equal to the region volume.<p>The spot quality stores the object area or volume in pixels.</html>";
    public static final String URL_DOC = "https://imagej.net/plugins/trackmate/detectors/trackmate-thresholding-detector";
    public static final ImageIcon ICON = new ImageIcon(Icons.class.getResource("images/LabelImageDetector-icon-64px.png"));
    public static final String KEY_SIMPLIFY_CONTOURS = "SIMPLIFY_CONTOURS";
    public static final String KEY_INTENSITY_THRESHOLD = "INTENSITY_THRESHOLD";

    @Override
    public SpotDetector<T> getDetector(ImgPlus<T> img, Map<String, Object> settings, Interval interval, int frame) {
        double intensityThreshold = (Double)settings.get(KEY_INTENSITY_THRESHOLD);
        boolean simplifyContours = (Boolean)settings.get(KEY_SIMPLIFY_CONTOURS);
        double[] calibration = TMUtils.getSpatialCalibration(img);
        int channel = (Integer)settings.get("TARGET_CHANNEL") - 1;
        RandomAccessibleInterval<T> imFrame = DetectionUtils.prepareFrameImg(img, channel, frame);
        ThresholdDetector<T> detector = new ThresholdDetector<T>(imFrame, interval, calibration, intensityThreshold, simplifyContours);
        detector.setNumThreads(1);
        return detector;
    }

    @Override
    public boolean has2Dsegmentation() {
        return true;
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    @Override
    public ConfigurationPanel getDetectorConfigurationPanel(Settings lSettings, Model model) {
        return new ThresholdDetectorConfigurationPanel(lSettings, model);
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getUrl() {
        return URL_DOC;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> lSettings = new HashMap<String, Object>();
        lSettings.put("TARGET_CHANNEL", 1);
        lSettings.put(KEY_INTENSITY_THRESHOLD, 0.0);
        lSettings.put(KEY_SIMPLIFY_CONTOURS, true);
        return lSettings;
    }
}

