/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.graph;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.graph.Function1;
import fiji.plugin.trackmate.graph.Function2;
import fiji.plugin.trackmate.graph.RecursiveCumSum;
import fiji.plugin.trackmate.graph.SortedDepthFirstIterator;
import fiji.plugin.trackmate.graph.TimeDirectedNeighborIndex;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.jgrapht.graph.SimpleWeightedGraph;

public class GraphUtils {
    public static <V, E> SimpleWeightedGraph<V, E> convertToSimpleWeightedGraph(SimpleDirectedWeightedGraph<V, E> directedGraph) {
        Class<?> edgeClass = directedGraph.getEdgeSupplier().get().getClass();
        SimpleWeightedGraph undirectedGraph = new SimpleWeightedGraph(edgeClass);
        for (Object vertex : directedGraph.vertexSet()) {
            undirectedGraph.addVertex(vertex);
        }
        for (Object edge : directedGraph.edgeSet()) {
            Object source = directedGraph.getEdgeSource(edge);
            Object target = directedGraph.getEdgeTarget(edge);
            double weight = directedGraph.getEdgeWeight(edge);
            if (undirectedGraph.containsEdge(source, target)) {
                double existingWeight = undirectedGraph.getEdgeWeight(undirectedGraph.getEdge(source, target));
                undirectedGraph.setEdgeWeight(undirectedGraph.getEdge(source, target), Math.max(existingWeight, weight));
                continue;
            }
            Object newEdge = undirectedGraph.addEdge(source, target);
            undirectedGraph.setEdgeWeight(newEdge, weight);
        }
        return undirectedGraph;
    }

    public static final String toString(TrackModel model) {
        TimeDirectedNeighborIndex cache = model.getDirectedNeighborIndex();
        if (!GraphUtils.isTree(model, cache)) {
            throw new IllegalArgumentException("toString cannot be applied to graphs that are not trees (each vertex must have at most one predecessor).");
        }
        Map<Spot, Integer> widths = GraphUtils.cumulativeBranchWidth(model);
        int largestName = 0;
        for (Spot spot : model.vertexSet()) {
            if (spot.getName().length() <= largestName) continue;
            largestName = spot.getName().length();
        }
        largestName += 2;
        TreeSet<Integer> frames = new TreeSet<Integer>();
        for (Spot spot : model.vertexSet()) {
            frames.add(spot.getFeature("FRAME").intValue());
        }
        int n = frames.size();
        HashMap<Integer, StringBuilder> strings = new HashMap<Integer, StringBuilder>(n);
        for (Integer n2 : frames) {
            strings.put(n2, new StringBuilder());
        }
        HashMap<Integer, StringBuilder> below = new HashMap<Integer, StringBuilder>(n);
        for (Integer frame : frames) {
            below.put(frame, new StringBuilder());
        }
        HashMap<Spot, Integer> hashMap = new HashMap<Spot, Integer>(model.vertexSet().size());
        Comparator<Spot> comparator = Spot.nameComparator;
        for (Integer n3 : model.trackIDs(true)) {
            Set<Spot> track = model.trackSpots(n3);
            Iterator<Spot> it = track.iterator();
            Spot first = it.next();
            for (Spot spot : track) {
                if (!(first.diffTo(spot, "FRAME") > 0.0)) continue;
                first = spot;
            }
            for (Integer n4 : frames) {
                int columnWidth = widths.get(first);
                ((StringBuilder)below.get(n4)).append(GraphUtils.makeSpaces(columnWidth * largestName));
            }
            SortedDepthFirstIterator<Spot, DefaultWeightedEdge> iterator = model.getSortedDepthFirstIterator(first, comparator, true);
            while (iterator.hasNext()) {
                Spot spot = iterator.next();
                int frame = spot.getFeature("FRAME").intValue();
                boolean isLeaf = cache.successorsOf(spot).size() == 0;
                int columnWidth = widths.get(spot);
                String str = spot.getName();
                int nprespaces = largestName / 2 - str.length() / 2;
                ((StringBuilder)strings.get(frame)).append(GraphUtils.makeSpaces(columnWidth / 2 * largestName));
                ((StringBuilder)strings.get(frame)).append(GraphUtils.makeSpaces(nprespaces));
                ((StringBuilder)strings.get(frame)).append(str);
                int currentBranchingPosition = ((StringBuilder)strings.get(frame)).length() - str.length() / 2;
                hashMap.put(spot, currentBranchingPosition);
                ((StringBuilder)strings.get(frame)).append(GraphUtils.makeSpaces(largestName - nprespaces - str.length()));
                ((StringBuilder)strings.get(frame)).append(GraphUtils.makeSpaces(columnWidth * largestName - columnWidth / 2 * largestName - largestName));
                if (isLeaf) {
                    NavigableSet<Integer> framesToFill = frames.tailSet(frame, false);
                    for (Integer subsequentFrame : framesToFill) {
                        ((StringBuilder)strings.get(subsequentFrame)).append(GraphUtils.makeSpaces(columnWidth * largestName));
                    }
                    continue;
                }
                Set<Spot> successors = cache.successorsOf(spot);
                for (Spot successor : successors) {
                    if (!(successor.diffTo(spot, "FRAME") > 1.0)) continue;
                    for (int subFrame = successor.getFeature("FRAME").intValue(); subFrame <= successor.getFeature("FRAME").intValue(); ++subFrame) {
                        ((StringBuilder)strings.get(subFrame - 1)).append(GraphUtils.makeSpaces(columnWidth * largestName));
                    }
                }
            }
            for (Integer frame : frames) {
                StringBuilder sb;
                int pos;
                int columnWidth = widths.get(first);
                int nspaces = columnWidth * largestName - (pos = (sb = (StringBuilder)strings.get(frame)).length());
                if (nspaces <= 0) continue;
                sb.append(GraphUtils.makeSpaces(nspaces));
            }
        }
        Set<DefaultWeightedEdge> edges = model.edgeSet();
        for (DefaultWeightedEdge edge : edges) {
            int frame;
            Spot source = model.getEdgeSource(edge);
            Spot target = model.getEdgeTarget(edge);
            int sourceCarret = (Integer)hashMap.get(source) - 1;
            int n5 = (Integer)hashMap.get(target) - 1;
            int sourceFrame = source.getFeature("FRAME").intValue();
            int targetFrame = target.getFeature("FRAME").intValue();
            for (frame = sourceFrame; frame < targetFrame; ++frame) {
                ((StringBuilder)below.get(frame)).setCharAt(sourceCarret, '|');
            }
            for (frame = sourceFrame + 1; frame < targetFrame; ++frame) {
                ((StringBuilder)strings.get(frame)).setCharAt(sourceCarret, '|');
            }
            if (cache.successorsOf(source).size() <= 1) continue;
            int minC = Math.min(sourceCarret, n5);
            int maxC = Math.max(sourceCarret, n5);
            StringBuilder sb = (StringBuilder)below.get(sourceFrame);
            for (int i = minC + 1; i < maxC; ++i) {
                if (sb.charAt(i) != ' ') continue;
                sb.setCharAt(i, '-');
            }
            sb.setCharAt(minC, '+');
            sb.setCharAt(maxC, '+');
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer frame : frames) {
            stringBuilder.append(((StringBuilder)strings.get(frame)).toString());
            stringBuilder.append('\n');
            stringBuilder.append(((StringBuilder)below.get(frame)).toString());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static final boolean isTree(TrackModel model, TimeDirectedNeighborIndex cache) {
        return GraphUtils.isTree(model.vertexSet(), cache);
    }

    public static final boolean isTree(Iterable<Spot> spots, TimeDirectedNeighborIndex cache) {
        for (Spot spot : spots) {
            if (cache.predecessorsOf(spot).size() <= 1) continue;
            return false;
        }
        return true;
    }

    public static final Map<Spot, Integer> cumulativeBranchWidth(TrackModel model) {
        Supplier<int[]> factory = new Supplier<int[]>(){

            @Override
            public int[] get() {
                return new int[1];
            }
        };
        final TimeDirectedNeighborIndex cache = model.getDirectedNeighborIndex();
        Function1<Spot, int[]> isLeafFun = new Function1<Spot, int[]>(){

            @Override
            public void compute(Spot input, int[] output) {
                output[0] = cache.successorsOf(input).size() == 0 ? 1 : 0;
            }
        };
        HashMap mappings = new HashMap();
        SimpleDirectedWeightedGraph<int[], DefaultWeightedEdge> leafTree = model.copy(factory, isLeafFun, mappings);
        HashSet<Spot> roots = new HashSet<Spot>(model.nTracks(false));
        HashSet<Spot> firsts = new HashSet<Spot>(model.nTracks(false));
        Set<Integer> ids = model.trackIDs(false);
        for (Integer id : ids) {
            Set<Spot> track = model.trackSpots(id);
            boolean firstFound = false;
            Iterator<Spot> iterator = track.iterator();
            while (iterator.hasNext()) {
                Spot spot = iterator.next();
                if (cache.predecessorsOf(spot).size() != 0) continue;
                if (!firstFound) {
                    firsts.add(spot);
                }
                roots.add(spot);
                firstFound = true;
            }
        }
        Function2<int[], int[]> cumsumFun = new Function2<int[], int[]>(){

            @Override
            public void compute(int[] input1, int[] input2, int[] output) {
                output[0] = input1[0] + input2[0];
            }
        };
        RecursiveCumSum<int[], DefaultWeightedEdge> cumsum = new RecursiveCumSum<int[], DefaultWeightedEdge>((SimpleDirectedGraph<int[], DefaultWeightedEdge>)leafTree, cumsumFun);
        for (Spot root : firsts) {
            int[] current = (int[])mappings.get(root);
            cumsum.apply(current);
        }
        HashMap<Spot, Integer> widths = new HashMap<Spot, Integer>();
        for (Spot spot : model.vertexSet()) {
            widths.put(spot, ((int[])mappings.get(spot))[0]);
        }
        return widths;
    }

    private static char[] makeSpaces(int width) {
        return GraphUtils.makeChars(width, ' ');
    }

    private static char[] makeChars(int width, char c) {
        char[] chars = new char[width];
        Arrays.fill(chars, c);
        return chars;
    }
}

